/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.parser.ExprLexer;
import org.apache.drill.common.expression.parser.ExprParser;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.TemplateClassDefinition;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.EvaluationVisitor;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.physical.impl.project.Projector;
import org.apache.drill.exec.record.TypedFieldId;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEvaluationVisitor {
    static final Logger logger = LoggerFactory.getLogger(TestEvaluationVisitor.class);

    @Test
    public void x() throws Exception {
        DrillConfig c = DrillConfig.create();
        FunctionImplementationRegistry reg = new FunctionImplementationRegistry(c);
        EvaluationVisitor v = new EvaluationVisitor(reg);
        CodeGenerator g = CodeGenerator.get((TemplateClassDefinition)Projector.TEMPLATE_DEFINITION, (FunctionImplementationRegistry)reg);
        SchemaPath path = (SchemaPath)this.getExpr("a.b[4][2].c[6]");
        TypedFieldId id = TypedFieldId.newBuilder().addId(1).addId(3).remainder((PathSegment)path.getRootSegment()).intermediateType(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.MAP)).finalType(Types.repeated((TypeProtos.MinorType)TypeProtos.MinorType.MAP)).hyper().withIndex().build();
        ValueVectorReadExpression e = new ValueVectorReadExpression(id);
        TypedFieldId outId = TypedFieldId.newBuilder().addId(1).finalType(Types.repeated((TypeProtos.MinorType)TypeProtos.MinorType.MAP)).intermediateType(Types.repeated((TypeProtos.MinorType)TypeProtos.MinorType.MAP)).build();
        ValueVectorWriteExpression e2 = new ValueVectorWriteExpression(outId, (LogicalExpression)e, true);
        v.addExpr((LogicalExpression)e2, g.getRoot());
        System.out.println(g.generateAndGet());
    }

    private LogicalExpression getExpr(String expr) throws Exception {
        ExprLexer lexer = new ExprLexer((CharStream)new ANTLRStringStream(expr));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExprParser parser = new ExprParser((TokenStream)tokens);
        ExprParser.parse_return ret = parser.parse();
        return ret.e;
    }
}

