/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import java.io.IOException;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.compile.ExampleInner;
import org.apache.drill.exec.compile.ExampleTemplateWithInner;
import org.apache.drill.exec.compile.QueryClassLoader;
import org.apache.drill.exec.compile.TemplateClassDefinition;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.SessionOptionManager;
import org.codehaus.commons.compiler.CompileException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClassTransformation
extends BaseTestQuery {
    private static final Logger logger = LoggerFactory.getLogger(TestClassTransformation.class);
    private static final int ITERATION_COUNT = Integer.valueOf(System.getProperty("TestClassTransformation.iteration", "1"));
    private static SessionOptionManager sessionOptions;

    @BeforeClass
    public static void beforeTestClassTransformation() throws Exception {
        UserSession userSession = UserSession.Builder.newBuilder().withOptionManager((OptionManager)TestClassTransformation.getDrillbitContext().getOptionManager()).build();
        sessionOptions = (SessionOptionManager)userSession.getOptions();
    }

    @Test
    public void testJaninoClassCompiler() throws Exception {
        logger.debug("Testing JaninoClassCompiler");
        sessionOptions.setOption(OptionValue.createString((OptionValue.OptionType)OptionValue.OptionType.SESSION, (String)"exec.java_compiler", (String)QueryClassLoader.CompilerPolicy.JANINO.name()));
        QueryClassLoader loader = new QueryClassLoader(config, (OptionManager)sessionOptions);
        for (int i = 0; i < ITERATION_COUNT; ++i) {
            this.compilationInnerClass(loader);
        }
        loader.close();
    }

    @Test
    public void testJDKClassCompiler() throws Exception {
        logger.debug("Testing JDKClassCompiler");
        sessionOptions.setOption(OptionValue.createString((OptionValue.OptionType)OptionValue.OptionType.SESSION, (String)"exec.java_compiler", (String)QueryClassLoader.CompilerPolicy.JDK.name()));
        QueryClassLoader loader = new QueryClassLoader(config, (OptionManager)sessionOptions);
        for (int i = 0; i < ITERATION_COUNT; ++i) {
            this.compilationInnerClass(loader);
        }
        loader.close();
    }

    @Test
    public void testCompilationNoDebug() throws CompileException, ClassNotFoundException, ClassTransformationException, IOException {
        CodeGenerator<ExampleInner> cg = this.newCodeGenerator(ExampleInner.class, ExampleTemplateWithInner.class);
        ClassTransformer.ClassSet classSet = new ClassTransformer.ClassSet(null, cg.getDefinition().getTemplateClassName(), cg.getMaterializedClassName());
        String sourceCode = cg.generateAndGet();
        sessionOptions.setOption(OptionValue.createString((OptionValue.OptionType)OptionValue.OptionType.SESSION, (String)"exec.java_compiler", (String)QueryClassLoader.CompilerPolicy.JDK.name()));
        sessionOptions.setOption(OptionValue.createBoolean((OptionValue.OptionType)OptionValue.OptionType.SESSION, (String)"exec.java_compiler_debug", (boolean)false));
        QueryClassLoader loader = new QueryClassLoader(config, (OptionManager)sessionOptions);
        byte[][] codeWithoutDebug = loader.getClassByteCode(classSet.generated, sourceCode);
        loader.close();
        int sizeWithoutDebug = 0;
        for (byte[] bs : codeWithoutDebug) {
            sizeWithoutDebug += bs.length;
        }
        sessionOptions.setOption(OptionValue.createBoolean((OptionValue.OptionType)OptionValue.OptionType.SESSION, (String)"exec.java_compiler_debug", (boolean)true));
        loader = new QueryClassLoader(config, (OptionManager)sessionOptions);
        byte[][] codeWithDebug = loader.getClassByteCode(classSet.generated, sourceCode);
        loader.close();
        int sizeWithDebug = 0;
        for (byte[] bs : codeWithDebug) {
            sizeWithDebug += bs.length;
        }
        Assert.assertTrue((String)"Debug code is smaller than optimized code!!!", (sizeWithDebug > sizeWithoutDebug ? 1 : 0) != 0);
        logger.debug("Optimized code is {}% smaller than debug code.", (Object)((int)((double)(sizeWithDebug - sizeWithoutDebug) / (double)sizeWithDebug * 100.0)));
    }

    private void compilationInnerClass(QueryClassLoader loader) throws Exception {
        CodeGenerator<ExampleInner> cg = this.newCodeGenerator(ExampleInner.class, ExampleTemplateWithInner.class);
        ClassTransformer ct = new ClassTransformer((OptionManager)sessionOptions);
        Class c = ct.getImplementationClass(loader, cg.getDefinition(), cg.generateAndGet(), cg.getMaterializedClassName());
        ExampleInner t = (ExampleInner)c.newInstance();
        t.doOutside();
        t.doInsideOutside();
    }

    private <T, X extends T> CodeGenerator<T> newCodeGenerator(Class<T> iface, Class<X> impl) {
        TemplateClassDefinition template = new TemplateClassDefinition(iface, impl);
        CodeGenerator cg = CodeGenerator.get((TemplateClassDefinition)template, (FunctionImplementationRegistry)TestClassTransformation.getDrillbitContext().getFunctionImplementationRegistry());
        ClassGenerator root = cg.getRoot();
        root.setMappingSet(new MappingSet(new GeneratorMapping("doOutside", null, null, null)));
        root.getSetupBlock().directStatement("System.out.println(\"outside\");");
        ClassGenerator inner = root.getInnerGenerator("TheInnerClass");
        inner.setMappingSet(new MappingSet(new GeneratorMapping("doInside", null, null, null)));
        inner.getSetupBlock().directStatement("System.out.println(\"inside\");");
        ClassGenerator doubleInner = inner.getInnerGenerator("DoubleInner");
        doubleInner.setMappingSet(new MappingSet(new GeneratorMapping("doDouble", null, null, null)));
        doubleInner.getSetupBlock().directStatement("System.out.println(\"double\");");
        return cg;
    }
}

