/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.client;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.client.DumpCat;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class DumpCatTest
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();

    @Test
    public void testDumpCat(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)DumpCatTest.this.c);
                bitContext.getConfig();
                result = DumpCatTest.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)DumpCatTest.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(DumpCatTest.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/trace/simple_trace.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
        }
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
        exec.close();
        ExecProtos.FragmentHandle handle = context.getHandle();
        String qid = QueryIdHelper.getQueryId((UserBitShared.QueryId)handle.getQueryId());
        int majorFragmentId = handle.getMajorFragmentId();
        int minorFragmentId = handle.getMinorFragmentId();
        String logLocation = this.c.getString("drill.exec.trace.directory");
        System.out.println("Found log location: " + logLocation);
        String filename = String.format("%s//%s_%d_%d_mock-scan", logLocation, qid, majorFragmentId, minorFragmentId);
        System.out.println("File Name: " + filename);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", this.c.getString("drill.exec.trace.filesystem"));
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path path = new Path(filename);
        Assert.assertTrue((String)"Trace file does not exist", (boolean)fs.exists(path));
        DumpCat dumpCat = new DumpCat();
        try (FileInputStream input = new FileInputStream(filename);){
            dumpCat.doQuery(input);
        }
        input = new FileInputStream(filename);
        var19_19 = null;
        try {
            dumpCat.doBatch(input, 0, true);
        }
        catch (Throwable throwable) {
            var19_19 = throwable;
            throw throwable;
        }
        finally {
            if (input != null) {
                if (var19_19 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable x2) {
                        var19_19.addSuppressed(x2);
                    }
                } else {
                    input.close();
                }
            }
        }
    }
}

