/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.cache;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.cache.VectorAccessibleSerializable;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class TestWriteToDisk
extends ExecTest {
    @Rule
    public final TestRule TIMEOUT = TestTools.getTimeoutRule((int)90000);

    @Test
    public void test() throws Exception {
        ArrayList vectorList = Lists.newArrayList();
        DrillConfig config = DrillConfig.create();
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(config, serviceSet);){
            bit.run();
            DrillbitContext context = bit.getContext();
            MaterializedField intField = MaterializedField.create((SchemaPath)new SchemaPath("int", ExpressionPosition.UNKNOWN), (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.INT));
            MaterializedField binField = MaterializedField.create((SchemaPath)new SchemaPath("binary", ExpressionPosition.UNKNOWN), (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VARBINARY));
            try (IntVector intVector = (IntVector)TypeHelper.getNewVector(intField, context.getAllocator());
                 VarBinaryVector binVector = (VarBinaryVector)TypeHelper.getNewVector(binField, context.getAllocator());){
                AllocationHelper.allocate((ValueVector)intVector, (int)4, (int)4);
                AllocationHelper.allocate((ValueVector)binVector, (int)4, (int)5);
                vectorList.add(intVector);
                vectorList.add(binVector);
                intVector.getMutator().setSafe(0, 0);
                binVector.getMutator().setSafe(0, "ZERO".getBytes());
                intVector.getMutator().setSafe(1, 1);
                binVector.getMutator().setSafe(1, "ONE".getBytes());
                intVector.getMutator().setSafe(2, 2);
                binVector.getMutator().setSafe(2, "TWO".getBytes());
                intVector.getMutator().setSafe(3, 3);
                binVector.getMutator().setSafe(3, "THREE".getBytes());
                intVector.getMutator().setValueCount(4);
                binVector.getMutator().setValueCount(4);
                VectorContainer container = new VectorContainer();
                container.addCollection((Iterable)vectorList);
                container.setRecordCount(4);
                WritableBatch batch = WritableBatch.getBatchNoHVWrap((int)container.getRecordCount(), (Iterable)container, (boolean)false);
                VectorAccessibleSerializable wrap = new VectorAccessibleSerializable(batch, context.getAllocator());
                Configuration conf = new Configuration();
                conf.set("fs.defaultFS", "file:///");
                VectorAccessibleSerializable newWrap = new VectorAccessibleSerializable(context.getAllocator());
                try (FileSystem fs = FileSystem.get((Configuration)conf);){
                    File tempDir = Files.createTempDir();
                    tempDir.deleteOnExit();
                    Path path = new Path(tempDir.getAbsolutePath(), "drillSerializable");
                    try (FSDataOutputStream out = fs.create(path);){
                        wrap.writeToStream((OutputStream)out);
                        out.close();
                    }
                    var24_34 = null;
                    try (FSDataInputStream in = fs.open(path);){
                        newWrap.readFromStream((InputStream)in);
                    }
                    catch (Throwable x2) {
                        var24_34 = x2;
                        throw x2;
                    }
                }
                VectorContainer newContainer = newWrap.get();
                for (VectorWrapper w : newContainer) {
                    ValueVector vv = w.getValueVector();
                    Throwable throwable = null;
                    try {
                        int values = vv.getAccessor().getValueCount();
                        for (int i = 0; i < values; ++i) {
                            Object o = vv.getAccessor().getObject(i);
                            if (o instanceof byte[]) {
                                System.out.println(new String((byte[])o));
                                continue;
                            }
                            System.out.println(o);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (vv == null) continue;
                        if (throwable != null) {
                            try {
                                vv.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        vv.close();
                    }
                }
            }
        }
    }
}

