/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.util.MiniZooKeeperCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperHelper {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperHelper.class);
    private final File testDir = new File("target/test-data");
    private final DrillConfig config;
    private final String zkUrl;
    private MiniZooKeeperCluster zkCluster;

    public ZookeeperHelper() {
        this(false);
    }

    public ZookeeperHelper(boolean failureInCancelled) {
        Properties overrideProps = new Properties();
        if (failureInCancelled) {
            overrideProps.setProperty("drill.exec.debug.return_error_for_failure_in_cancelled_fragments", "true");
        }
        this.config = DrillConfig.create((Properties)overrideProps);
        this.zkUrl = this.config.getString("drill.exec.zk.connect");
        if (!this.testDir.exists()) {
            this.testDir.mkdirs();
        }
    }

    public void startZookeeper(int numServers) {
        if (this.zkCluster != null) {
            throw new IllegalStateException("Zookeeper cluster already running");
        }
        try {
            this.zkCluster = new MiniZooKeeperCluster();
            this.zkCluster.setDefaultClientPort(Integer.parseInt(this.zkUrl.split(":")[1]));
            this.zkCluster.startup(this.testDir, numServers);
        }
        catch (IOException | InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void stopZookeeper() {
        try {
            this.zkCluster.shutdown();
            this.zkCluster = null;
        }
        catch (IOException e) {
            String message = "Unable to shutdown Zookeeper";
            System.err.println("Unable to shutdown Zookeeper.");
            logger.warn("Unable to shutdown Zookeeper", (Throwable)e);
        }
    }

    public DrillConfig getConfig() {
        return this.config;
    }
}

