/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.work.foreman.SqlUnsupportedException;
import org.apache.drill.exec.work.foreman.UnsupportedFunctionException;
import org.apache.drill.test.UserExceptionMatcher;
import org.hamcrest.Matcher;
import org.junit.Test;

public class TestWindowFunctions
extends BaseTestQuery {
    static final String WORKING_PATH = TestTools.getWorkingPath();
    static final String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";

    private static void throwAsUnsupportedException(UserException ex) throws Exception {
        SqlUnsupportedException.errorClassNameToException((String)ex.getOrCreatePBError(false).getException().getExceptionClass());
        throw ex;
    }

    @Test
    public void testSinglePartition() throws Exception {
        String query = "select sum(n_nationKey) over(partition by n_nationKey) as col1, count(*) over(partition by n_nationKey) as col2 \nfrom cp.`tpch/nation.parquet`";
        String[] expectedPlan = new String[]{"Window.*partition \\{0\\} order by \\[\\].*\\[SUM\\(\\$0\\), COUNT\\(\\)", "Scan.*columns=\\[`n_nationKey`\\].*"};
        String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\].*"};
        PlanTestBase.testPlanMatchingPatterns("select sum(n_nationKey) over(partition by n_nationKey) as col1, count(*) over(partition by n_nationKey) as col2 \nfrom cp.`tpch/nation.parquet`", expectedPlan, excludedPatterns);
        TestWindowFunctions.testBuilder().sqlQuery("select sum(n_nationKey) over(partition by n_nationKey) as col1, count(*) over(partition by n_nationKey) as col2 \nfrom cp.`tpch/nation.parquet`").unOrdered().baselineColumns("col1", "col2").baselineValues(0L, 1L).baselineValues(1L, 1L).baselineValues(2L, 1L).baselineValues(3L, 1L).baselineValues(4L, 1L).baselineValues(5L, 1L).baselineValues(6L, 1L).baselineValues(7L, 1L).baselineValues(8L, 1L).baselineValues(9L, 1L).baselineValues(10L, 1L).baselineValues(11L, 1L).baselineValues(12L, 1L).baselineValues(13L, 1L).baselineValues(14L, 1L).baselineValues(15L, 1L).baselineValues(16L, 1L).baselineValues(17L, 1L).baselineValues(18L, 1L).baselineValues(19L, 1L).baselineValues(20L, 1L).baselineValues(21L, 1L).baselineValues(22L, 1L).baselineValues(23L, 1L).baselineValues(24L, 1L).build().run();
    }

    @Test
    public void testSinglePartitionDefinedInWindowList() throws Exception {
        String query = "select sum(n_nationKey) over w as col \nfrom cp.`tpch/nation.parquet` \nwindow w as (partition by n_nationKey order by n_nationKey)";
        String[] expectedPlan = new String[]{"Window.*partition \\{0\\} order by \\[0\\].*SUM\\(\\$0\\)", "Scan.*columns=\\[`n_nationKey`\\].*"};
        String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\].*"};
        PlanTestBase.testPlanMatchingPatterns("select sum(n_nationKey) over w as col \nfrom cp.`tpch/nation.parquet` \nwindow w as (partition by n_nationKey order by n_nationKey)", expectedPlan, excludedPatterns);
        TestWindowFunctions.testBuilder().sqlQuery("select sum(n_nationKey) over w as col \nfrom cp.`tpch/nation.parquet` \nwindow w as (partition by n_nationKey order by n_nationKey)").unOrdered().baselineColumns("col").baselineValues(0L).baselineValues(1L).baselineValues(2L).baselineValues(3L).baselineValues(4L).baselineValues(5L).baselineValues(6L).baselineValues(7L).baselineValues(8L).baselineValues(9L).baselineValues(10L).baselineValues(11L).baselineValues(12L).baselineValues(13L).baselineValues(14L).baselineValues(15L).baselineValues(16L).baselineValues(17L).baselineValues(18L).baselineValues(19L).baselineValues(20L).baselineValues(21L).baselineValues(22L).baselineValues(23L).baselineValues(24L).build().run();
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testWindowFunctionWithDistinct() throws Exception {
        try {
            String query = "explain plan for select a2, count(distinct b2) over(partition by a2) \nfrom cp.`tpch/nation.parquet`";
            TestWindowFunctions.test("explain plan for select a2, count(distinct b2) over(partition by a2) \nfrom cp.`tpch/nation.parquet`");
        }
        catch (UserException ex) {
            TestWindowFunctions.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testWindowFrame() throws Exception {
        try {
            String query = "select a2, sum(a2) over(partition by a2 order by a2 rows between 1 preceding and 1 following ) \nfrom cp.`tpch/nation.parquet` t \norder by a2";
            TestWindowFunctions.test("select a2, sum(a2) over(partition by a2 order by a2 rows between 1 preceding and 1 following ) \nfrom cp.`tpch/nation.parquet` t \norder by a2");
        }
        catch (UserException ex) {
            TestWindowFunctions.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testRowsUnboundedPreceding() throws Exception {
        try {
            String query = "explain plan for select sum(n_nationKey) over(partition by n_nationKey order by n_nationKey \nrows UNBOUNDED PRECEDING)from cp.`tpch/nation.parquet` t \norder by n_nationKey";
            TestWindowFunctions.test("explain plan for select sum(n_nationKey) over(partition by n_nationKey order by n_nationKey \nrows UNBOUNDED PRECEDING)from cp.`tpch/nation.parquet` t \norder by n_nationKey");
        }
        catch (UserException ex) {
            TestWindowFunctions.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testFramesDefinedInWindowClause() throws Exception {
        try {
            String query = "explain plan for select sum(n_nationKey) over w \nfrom cp.`tpch/nation.parquet` \nwindow w as (partition by n_nationKey order by n_nationKey rows UNBOUNDED PRECEDING)";
            TestWindowFunctions.test("explain plan for select sum(n_nationKey) over w \nfrom cp.`tpch/nation.parquet` \nwindow w as (partition by n_nationKey order by n_nationKey rows UNBOUNDED PRECEDING)");
        }
        catch (UserException ex) {
            TestWindowFunctions.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testWindowWithAlias() throws Exception {
        try {
            String query = "explain plan for SELECT sum(n_nationkey) OVER (PARTITION BY n_name ORDER BY n_name ROWS BETWEEN CURRENT ROW AND 1 FOLLOWING) as col2 \nfrom cp.`tpch/nation.parquet`";
            TestWindowFunctions.test(query);
        }
        catch (UserException ex) {
            TestWindowFunctions.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testWindowWithAllowDisallow() throws Exception {
        try {
            String query = "select sum(n_nationKey) over(partition by n_nationKey \nrows between unbounded preceding and unbounded following disallow partial) \nfrom cp.`tpch/nation.parquet` \norder by n_nationKey";
            TestWindowFunctions.test("select sum(n_nationKey) over(partition by n_nationKey \nrows between unbounded preceding and unbounded following disallow partial) \nfrom cp.`tpch/nation.parquet` \norder by n_nationKey");
        }
        catch (UserException ex) {
            TestWindowFunctions.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test
    public void testWindowInWindow() throws Exception {
        this.thrownException.expect((Matcher)new UserExceptionMatcher(UserBitShared.DrillPBError.ErrorType.VALIDATION));
        String query = "select rank() over(order by row_number() over(order by n_nationkey)) \nfrom cp.`tpch/nation.parquet`";
        TestWindowFunctions.test(query);
    }

    @Test
    public void testMissingOverWithWindowClause() throws Exception {
        this.thrownException.expect((Matcher)new UserExceptionMatcher(UserBitShared.DrillPBError.ErrorType.VALIDATION));
        String query = "select rank(), cume_dist() over w \nfrom cp.`tpch/nation.parquet` \nwindow w as (partition by n_name order by n_nationkey)";
        TestWindowFunctions.test(query);
    }

    @Test
    public void testLeadMissingOver() throws Exception {
        this.thrownException.expect((Matcher)new UserExceptionMatcher(UserBitShared.DrillPBError.ErrorType.VALIDATION));
        String query = "select lead(n_nationkey) from cp.`tpch/nation.parquet`";
        TestWindowFunctions.test(query);
    }

    @Test
    public void testMissingOverWithConstant() throws Exception {
        this.thrownException.expect((Matcher)new UserExceptionMatcher(UserBitShared.DrillPBError.ErrorType.VALIDATION));
        String query = "select NTILE(1) from cp.`tpch/nation.parquet`";
        TestWindowFunctions.test(query);
    }

    @Test
    public void testWindowGroupBy() throws Exception {
        this.thrownException.expect((Matcher)new UserExceptionMatcher(UserBitShared.DrillPBError.ErrorType.VALIDATION));
        String query = "explain plan for SELECT max(n_nationkey) OVER (), n_name as col2 \nfrom cp.`tpch/nation.parquet` \ngroup by n_name";
        TestWindowFunctions.test(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWindowGroupByOnView() throws Exception {
        try {
            this.thrownException.expect((Matcher)new UserExceptionMatcher(UserBitShared.DrillPBError.ErrorType.VALIDATION));
            String createView = "create view testWindowGroupByOnView(a, b) as \nselect n_nationkey, n_name from cp.`tpch/nation.parquet`";
            String query = "explain plan for SELECT max(a) OVER (), b as col2 \nfrom testWindowGroupByOnView \ngroup by b";
            TestWindowFunctions.test("use dfs_test.tmp");
            TestWindowFunctions.test(createView);
            TestWindowFunctions.test(query);
        }
        finally {
            TestWindowFunctions.test("drop view testWindowGroupByOnView");
        }
    }

    @Test
    public void testWindowFrameEquivalentToDefault() throws Exception {
        String query1 = "select sum(n_nationKey) over(partition by n_nationKey order by n_nationKey) as col\nfrom cp.`tpch/nation.parquet` t \norder by n_nationKey";
        String query2 = "select sum(n_nationKey) over(partition by n_nationKey order by n_nationKey \nrange between unbounded preceding and current row) as col \nfrom cp.`tpch/nation.parquet` t \norder by n_nationKey";
        String query3 = "select sum(n_nationKey) over(partition by n_nationKey \nrows BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) as col \nfrom cp.`tpch/nation.parquet` t \norder by n_nationKey";
        String[] expectedPlan1 = new String[]{"Window.*partition \\{0\\} order by \\[0\\].*SUM\\(\\$0\\)", "Scan.*columns=\\[`n_nationKey`\\].*"};
        String[] excludedPatterns1 = new String[]{"Scan.*columns=\\[`\\*`\\].*"};
        PlanTestBase.testPlanMatchingPatterns("select sum(n_nationKey) over(partition by n_nationKey order by n_nationKey) as col\nfrom cp.`tpch/nation.parquet` t \norder by n_nationKey", expectedPlan1, excludedPatterns1);
        TestWindowFunctions.testBuilder().sqlQuery("select sum(n_nationKey) over(partition by n_nationKey order by n_nationKey) as col\nfrom cp.`tpch/nation.parquet` t \norder by n_nationKey").unOrdered().baselineColumns("col").baselineValues(0L).baselineValues(1L).baselineValues(2L).baselineValues(3L).baselineValues(4L).baselineValues(5L).baselineValues(6L).baselineValues(7L).baselineValues(8L).baselineValues(9L).baselineValues(10L).baselineValues(11L).baselineValues(12L).baselineValues(13L).baselineValues(14L).baselineValues(15L).baselineValues(16L).baselineValues(17L).baselineValues(18L).baselineValues(19L).baselineValues(20L).baselineValues(21L).baselineValues(22L).baselineValues(23L).baselineValues(24L).build().run();
        String[] expectedPlan2 = new String[]{"Window.*partition \\{0\\} order by \\[0\\].*SUM\\(\\$0\\)", "Scan.*columns=\\[`n_nationKey`\\].*"};
        String[] excludedPatterns2 = new String[]{"Scan.*columns=\\[`\\*`\\].*"};
        PlanTestBase.testPlanMatchingPatterns("select sum(n_nationKey) over(partition by n_nationKey order by n_nationKey \nrange between unbounded preceding and current row) as col \nfrom cp.`tpch/nation.parquet` t \norder by n_nationKey", expectedPlan2, excludedPatterns2);
        TestWindowFunctions.testBuilder().sqlQuery("select sum(n_nationKey) over(partition by n_nationKey order by n_nationKey \nrange between unbounded preceding and current row) as col \nfrom cp.`tpch/nation.parquet` t \norder by n_nationKey").unOrdered().baselineColumns("col").baselineValues(0L).baselineValues(1L).baselineValues(2L).baselineValues(3L).baselineValues(4L).baselineValues(5L).baselineValues(6L).baselineValues(7L).baselineValues(8L).baselineValues(9L).baselineValues(10L).baselineValues(11L).baselineValues(12L).baselineValues(13L).baselineValues(14L).baselineValues(15L).baselineValues(16L).baselineValues(17L).baselineValues(18L).baselineValues(19L).baselineValues(20L).baselineValues(21L).baselineValues(22L).baselineValues(23L).baselineValues(24L).build().run();
        String[] expectedPlan3 = new String[]{"Window.*partition \\{0\\}.*SUM\\(\\$0\\)", "Scan.*columns=\\[`n_nationKey`\\].*"};
        String[] excludedPatterns3 = new String[]{"Scan.*columns=\\[`\\*`\\].*"};
        PlanTestBase.testPlanMatchingPatterns("select sum(n_nationKey) over(partition by n_nationKey \nrows BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) as col \nfrom cp.`tpch/nation.parquet` t \norder by n_nationKey", expectedPlan3, excludedPatterns3);
        TestWindowFunctions.testBuilder().sqlQuery("select sum(n_nationKey) over(partition by n_nationKey \nrows BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) as col \nfrom cp.`tpch/nation.parquet` t \norder by n_nationKey").unOrdered().baselineColumns("col").baselineValues(0L).baselineValues(1L).baselineValues(2L).baselineValues(3L).baselineValues(4L).baselineValues(5L).baselineValues(6L).baselineValues(7L).baselineValues(8L).baselineValues(9L).baselineValues(10L).baselineValues(11L).baselineValues(12L).baselineValues(13L).baselineValues(14L).baselineValues(15L).baselineValues(16L).baselineValues(17L).baselineValues(18L).baselineValues(19L).baselineValues(20L).baselineValues(21L).baselineValues(22L).baselineValues(23L).baselineValues(24L).build().run();
    }

    @Test
    public void testWindowWithJoin() throws Exception {
        String query = "select sum(t1.r_regionKey) over(partition by t1.r_regionKey) as col \nfrom cp.`tpch/region.parquet` t1, cp.`tpch/nation.parquet` t2 \nwhere t1.r_regionKey = t2.n_nationKey \ngroup by t1.r_regionKey";
        String[] expectedPlan = new String[]{"Window.*partition \\{0\\}.*SUM\\(\\$0\\)", "Scan.*columns=\\[`n_nationKey`\\].*", "Scan.*columns=\\[`n_nationKey`\\].*"};
        String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\].*"};
        PlanTestBase.testPlanMatchingPatterns("select sum(t1.r_regionKey) over(partition by t1.r_regionKey) as col \nfrom cp.`tpch/region.parquet` t1, cp.`tpch/nation.parquet` t2 \nwhere t1.r_regionKey = t2.n_nationKey \ngroup by t1.r_regionKey", expectedPlan, excludedPatterns);
        TestWindowFunctions.testBuilder().sqlQuery("select sum(t1.r_regionKey) over(partition by t1.r_regionKey) as col \nfrom cp.`tpch/region.parquet` t1, cp.`tpch/nation.parquet` t2 \nwhere t1.r_regionKey = t2.n_nationKey \ngroup by t1.r_regionKey").unOrdered().baselineColumns("col").baselineValues(0L).baselineValues(1L).baselineValues(2L).baselineValues(3L).baselineValues(4L).build().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountEmptyPartitionByWithExchange() throws Exception {
        String query = String.format("select count(*) over (order by o_orderpriority) as cnt from dfs.`%s/multilevel/parquet` where o_custkey < 100", TEST_RES_PATH);
        try {
            String[] expectedPlan = new String[]{"Window.*partition \\{\\} order by \\[0\\].*COUNT\\(\\)", "Scan.*columns=\\[`o_custkey`, `o_orderpriority`\\]"};
            String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\]"};
            PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPatterns);
            TestWindowFunctions.testBuilder().sqlQuery(query).ordered().baselineColumns("cnt").optionSettingQueriesForTestQuery("alter session set `planner.slice_target` = 1").baselineValues(1L).baselineValues(4L).baselineValues(4L).baselineValues(4L).build().run();
        }
        finally {
            TestWindowFunctions.test("alter session set `planner.slice_target` = 100000");
        }
    }

    @Test
    public void testAvgVarianceWindowFunctions() throws Exception {
        String avgQuery = "select avg(n_nationkey) over (partition by n_nationkey) col1 from cp.`tpch/nation.parquet` where n_nationkey = 1";
        String[] expectedPlan1 = new String[]{"Window.*partition \\{0\\} order by \\[\\].*SUM\\(\\$0\\), COUNT\\(\\$0\\)", "Scan.*columns=\\[`n_nationkey`\\]"};
        String[] excludedPatterns1 = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns("select avg(n_nationkey) over (partition by n_nationkey) col1 from cp.`tpch/nation.parquet` where n_nationkey = 1", expectedPlan1, excludedPatterns1);
        TestWindowFunctions.testBuilder().sqlQuery("select avg(n_nationkey) over (partition by n_nationkey) col1 from cp.`tpch/nation.parquet` where n_nationkey = 1").unOrdered().baselineColumns("col1").baselineValues(1.0).go();
        String varianceQuery = "select var_pop(n_nationkey) over (partition by n_nationkey) col1 from cp.`tpch/nation.parquet` where n_nationkey = 1";
        String[] expectedPlan2 = new String[]{"Window.*partition \\{0\\} order by \\[\\].*SUM\\(\\$1\\), SUM\\(\\$0\\), COUNT\\(\\$0\\)", "Scan.*columns=\\[`n_nationkey`\\]"};
        String[] excludedPatterns2 = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns("select var_pop(n_nationkey) over (partition by n_nationkey) col1 from cp.`tpch/nation.parquet` where n_nationkey = 1", expectedPlan2, excludedPatterns2);
        TestWindowFunctions.testBuilder().sqlQuery("select var_pop(n_nationkey) over (partition by n_nationkey) col1 from cp.`tpch/nation.parquet` where n_nationkey = 1").unOrdered().baselineColumns("col1").baselineValues(0.0).go();
    }

    @Test
    public void testWindowFunctionWithKnownType() throws Exception {
        String query = "select sum(cast(col_int as int)) over (partition by col_varchar) as col1 from cp.`jsoninput/large_int.json` limit 1";
        String[] expectedPlan1 = new String[]{"Window.*partition \\{0\\} order by \\[\\].*SUM\\(\\$1\\)", "Scan.*columns=\\[`col_varchar`, `col_int`\\]"};
        String[] excludedPatterns1 = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns("select sum(cast(col_int as int)) over (partition by col_varchar) as col1 from cp.`jsoninput/large_int.json` limit 1", expectedPlan1, excludedPatterns1);
        TestWindowFunctions.testBuilder().sqlQuery("select sum(cast(col_int as int)) over (partition by col_varchar) as col1 from cp.`jsoninput/large_int.json` limit 1").unOrdered().baselineColumns("col1").baselineValues(0x80000001L).go();
        String avgQuery = "select avg(cast(col_int as int)) over (partition by col_varchar) as col1 from cp.`jsoninput/large_int.json` limit 1";
        String[] expectedPlan2 = new String[]{"Window.*partition \\{0\\} order by \\[\\].*SUM\\(\\$1\\), COUNT\\(\\$1\\)", "Scan.*columns=\\[`col_varchar`, `col_int`\\]"};
        String[] excludedPatterns2 = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns("select avg(cast(col_int as int)) over (partition by col_varchar) as col1 from cp.`jsoninput/large_int.json` limit 1", expectedPlan2, excludedPatterns2);
        TestWindowFunctions.testBuilder().sqlQuery("select avg(cast(col_int as int)) over (partition by col_varchar) as col1 from cp.`jsoninput/large_int.json` limit 1").unOrdered().baselineColumns("col1").baselineValues(1.0737418245E9).go();
    }

    @Test
    public void testCompoundIdentifierInWindowDefinition() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/csv/1994/Q1/orders_94_q1.csv").toURI().toString();
        String query = String.format("SELECT count(*) OVER w as col1, count(*) OVER w as col2 \nFROM dfs_test.`%s` \nWINDOW w AS (PARTITION BY columns[1] ORDER BY columns[0] DESC)", root);
        String[] expectedPlan = new String[]{"Window.*partition \\{1\\} order by \\[0 DESC\\].*COUNT\\(\\)", "Scan.*columns=\\[`columns`\\[0\\], `columns`\\[1\\]\\]"};
        String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPatterns);
        TestWindowFunctions.testBuilder().sqlQuery(query).ordered().baselineColumns("col1", "col2").baselineValues(1L, 1L).baselineValues(1L, 1L).baselineValues(1L, 1L).baselineValues(1L, 1L).baselineValues(1L, 1L).baselineValues(1L, 1L).baselineValues(1L, 1L).baselineValues(1L, 1L).baselineValues(1L, 1L).baselineValues(1L, 1L).build().run();
    }

    @Test
    public void testRankWithGroupBy() throws Exception {
        String query = "select dense_rank() over (order by l_suppkey) as rank1  from cp.`tpch/lineitem.parquet` group by l_partkey, l_suppkey order by 1 desc limit 1";
        String[] expectedPlan = new String[]{"Window.*partition \\{\\} order by \\[1\\].*DENSE_RANK\\(\\)", "Scan.*columns=\\[`l_partkey`, `l_suppkey`\\]"};
        String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns("select dense_rank() over (order by l_suppkey) as rank1  from cp.`tpch/lineitem.parquet` group by l_partkey, l_suppkey order by 1 desc limit 1", expectedPlan, excludedPatterns);
        TestWindowFunctions.testBuilder().sqlQuery("select dense_rank() over (order by l_suppkey) as rank1  from cp.`tpch/lineitem.parquet` group by l_partkey, l_suppkey order by 1 desc limit 1").unOrdered().baselineColumns("rank1").baselineValues(100L).go();
    }

    @Test
    public void testWindowSumAggIsNotNull() throws Exception {
        String query = String.format("select count(*) cnt from (select sum ( c1 ) over ( partition by c2 order by c1 asc nulls first ) w_sum from dfs.`%s/window/table_with_nulls.parquet` ) sub_query where w_sum is not null", TEST_RES_PATH);
        String[] expectedPlan = new String[]{"Window.*partition \\{1\\} order by \\[0 ASC-nulls-first\\].*SUM\\(\\$0\\)", "Scan.*columns=\\[`c1`, `c2`\\]"};
        String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPatterns);
        TestWindowFunctions.testBuilder().sqlQuery(query).ordered().baselineColumns("cnt").baselineValues(26L).build().run();
    }

    @Test
    public void testWindowConstants() throws Exception {
        String query = "select rank() over w fn, sum(2) over w sumINTEGER, sum(employee_id) over w sumEmpId, sum(0.5) over w sumFLOAT \nfrom cp.`employee.json` \nwhere position_id = 2 \nwindow w as(partition by position_id order by employee_id)";
        String[] expectedPlan = new String[]{"Window.*partition \\{0\\} order by \\[1\\].*RANK\\(\\), SUM\\(\\$2\\), SUM\\(\\$1\\), SUM\\(\\$3\\)", "Scan.*columns=\\[`position_id`, `employee_id`\\]"};
        String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPatterns);
        TestWindowFunctions.testBuilder().sqlQuery(query).ordered().baselineColumns("fn", "sumINTEGER", "sumEmpId", "sumFLOAT").baselineValues(1L, 2L, 2L, 0.5).baselineValues(2L, 4L, 6L, 1.0).baselineValues(3L, 6L, 11L, 1.5).baselineValues(4L, 8L, 31L, 2.0).baselineValues(5L, 10L, 52L, 2.5).baselineValues(6L, 12L, 74L, 3.0).build().run();
    }

    @Test
    public void testMultiplePartitions1() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/t.json").toURI().toString();
        String query = String.format("select count(*) over(partition by b1 order by c1) as count1, \nsum(a1)  over(partition by b1 order by c1) as sum1, \ncount(*) over(partition by a1 order by c1) as count2 \nfrom dfs_test.`%s`", root);
        String[] expectedPlan = new String[]{"Window.*partition \\{2\\} order by \\[1\\].*COUNT\\(\\)", "Window.*partition \\{0\\} order by \\[1\\].*COUNT\\(\\), SUM\\(\\$2\\)", "Scan.*columns=\\[`b1`, `c1`, `a1`\\]"};
        String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPatterns);
        TestWindowFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("count1", "sum1", "count2").baselineValues(1L, 0L, 2L).baselineValues(1L, 0L, 2L).baselineValues(2L, 0L, 5L).baselineValues(3L, 0L, 5L).baselineValues(3L, 0L, 5L).baselineValues(1L, 10L, 2L).baselineValues(1L, 10L, 2L).baselineValues(2L, 20L, 5L).baselineValues(3L, 30L, 5L).baselineValues(3L, 30L, 5L).build().run();
    }

    @Test
    public void testMultiplePartitions2() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/t.json").toURI().toString();
        String query = String.format("select count(*) over(partition by b1 order by c1) as count1, \ncount(*) over(partition by a1 order by c1) as count2, \nsum(a1)  over(partition by b1 order by c1) as sum1 \nfrom dfs_test.`%s`", root);
        String[] expectedPlan = new String[]{"Window.*partition \\{2\\} order by \\[1\\].*COUNT\\(\\)", "Window.*partition \\{0\\} order by \\[1\\].*COUNT\\(\\), SUM\\(\\$2\\)", "Scan.*columns=\\[`b1`, `c1`, `a1`\\]"};
        String[] excludedPatterns = new String[]{"Scan.*columns=\\[`\\*`\\]"};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPatterns);
        TestWindowFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("count1", "count2", "sum1").baselineValues(1L, 2L, 0L).baselineValues(1L, 2L, 0L).baselineValues(2L, 5L, 0L).baselineValues(3L, 5L, 0L).baselineValues(3L, 5L, 0L).baselineValues(1L, 2L, 10L).baselineValues(1L, 2L, 10L).baselineValues(2L, 5L, 20L).baselineValues(3L, 5L, 30L).baselineValues(3L, 5L, 30L).build().run();
    }

    @Test
    public void testWithAndWithoutPartitions() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/t.json").toURI().toString();
        String query = String.format("select sum(a1) over(partition by b1, c1) as s1, sum(a1) over() as s2 \nfrom dfs_test.`%s` \norder by a1", root);
        TestWindowFunctions.test("alter session set `planner.slice_target` = 1");
        String[] expectedPlan = new String[]{"Window\\(window#0=\\[window\\(partition \\{\\}.*\n.*UnionExchange"};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, new String[0]);
        TestWindowFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("s1", "s2").baselineValues(0L, 50L).baselineValues(0L, 50L).baselineValues(0L, 50L).baselineValues(0L, 50L).baselineValues(0L, 50L).baselineValues(10L, 50L).baselineValues(10L, 50L).baselineValues(10L, 50L).baselineValues(20L, 50L).baselineValues(20L, 50L).build().run();
    }

    @Test
    public void testConstantsInMultiplePartitions() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/t.json").toURI().toString();
        String query = String.format("select sum(1) over(partition by b1 order by a1) as sum1, sum(1) over(partition by a1) as sum2, rank() over(order by b1) as rank1, rank() over(order by 1) as rank2 \nfrom dfs_test.`%s` \norder by 1, 2, 3, 4", root);
        String[] expectedPlan = new String[]{"Window.*SUM\\(\\$3\\).*\n.*SelectionVectorRemover.*\n.*Sort.*\n.*Window.*SUM\\(\\$2\\).*"};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, new String[0]);
        TestWindowFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("sum1", "sum2", "rank1", "rank2").baselineValues(2L, 5L, 1L, 1L).baselineValues(2L, 5L, 1L, 1L).baselineValues(2L, 5L, 6L, 1L).baselineValues(2L, 5L, 6L, 1L).baselineValues(3L, 5L, 3L, 1L).baselineValues(3L, 5L, 3L, 1L).baselineValues(3L, 5L, 3L, 1L).baselineValues(3L, 5L, 8L, 1L).baselineValues(3L, 5L, 8L, 1L).baselineValues(3L, 5L, 8L, 1L).build().run();
    }

    @Test
    public void testExpressionInWindowFunction() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/t.json").toURI().toString();
        String query = String.format("select a1, b1, sum(b1) over (partition by a1) as c1, sum(a1 + b1) over (partition by a1) as c2\nfrom dfs_test.`%s`", root);
        String[] expectedPlan = new String[]{"Window\\(window#0=\\[window\\(partition \\{0\\} order by \\[\\].*\\[SUM\\(\\$1\\), SUM\\(\\$2\\)\\]"};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, new String[0]);
        TestWindowFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("a1", "b1", "c1", "c2").baselineValues(0L, 1L, 8L, 8L).baselineValues(0L, 1L, 8L, 8L).baselineValues(0L, 2L, 8L, 8L).baselineValues(0L, 2L, 8L, 8L).baselineValues(0L, 2L, 8L, 8L).baselineValues(10L, 3L, 21L, 71L).baselineValues(10L, 3L, 21L, 71L).baselineValues(10L, 5L, 21L, 71L).baselineValues(10L, 5L, 21L, 71L).baselineValues(10L, 5L, 21L, 71L).build().run();
    }

    @Test
    public void testProjectPushPastWindow() throws Exception {
        String query = "select sum(n_nationkey) over(partition by 1 order by 1) as col1, \ncount(n_nationkey) over(partition by 1 order by 1) as col2 \nfrom cp.`tpch/nation.parquet` \nlimit 5";
        String[] expectedPlan = new String[]{"Scan.*columns=\\[`n_nationkey`\\].*"};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, new String[0]);
        TestWindowFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col1", "col2").baselineValues(300L, 25L).baselineValues(300L, 25L).baselineValues(300L, 25L).baselineValues(300L, 25L).baselineValues(300L, 25L).build().run();
    }

    @Test
    public void testWindowFunInNestSubQ() throws Exception {
        String query = " select n_nationkey , n_regionkey ,         lead(n_regionkey) OVER ( PARTITION BY n_regionkey ORDER BY n_nationkey) lead_c2  FROM (SELECT n_nationkey ,n_regionkey,           ntile(3) over(PARTITION BY n_regionkey ORDER BY n_nationkey)        FROM cp.`tpch/nation.parquet`)  order by n_regionkey, n_nationkey";
        TestWindowFunctions.test(" select n_nationkey , n_regionkey ,         lead(n_regionkey) OVER ( PARTITION BY n_regionkey ORDER BY n_nationkey) lead_c2  FROM (SELECT n_nationkey ,n_regionkey,           ntile(3) over(PARTITION BY n_regionkey ORDER BY n_nationkey)        FROM cp.`tpch/nation.parquet`)  order by n_regionkey, n_nationkey");
        String baselineQuery = "select n_nationkey , n_regionkey ,        lead(n_regionkey) OVER ( PARTITION BY n_regionkey ORDER BY n_nationkey) lead_c2 FROM cp.`tpch/nation.parquet`   order by n_regionkey, n_nationkey";
        TestWindowFunctions.testBuilder().sqlQuery(" select n_nationkey , n_regionkey ,         lead(n_regionkey) OVER ( PARTITION BY n_regionkey ORDER BY n_nationkey) lead_c2  FROM (SELECT n_nationkey ,n_regionkey,           ntile(3) over(PARTITION BY n_regionkey ORDER BY n_nationkey)        FROM cp.`tpch/nation.parquet`)  order by n_regionkey, n_nationkey").ordered().sqlBaselineQuery("select n_nationkey , n_regionkey ,        lead(n_regionkey) OVER ( PARTITION BY n_regionkey ORDER BY n_nationkey) lead_c2 FROM cp.`tpch/nation.parquet`   order by n_regionkey, n_nationkey").build().run();
        String query2 = " select rnum, position_id,    ntile(4) over(order by position_id)  from (select position_id, row_number()        over(order by position_id) as rnum        from cp.`employee.json`)";
        String baselineQuery2 = " select row_number() over(order by position_id) as rnum,     position_id,     ntile(4) over(order by position_id)  from cp.`employee.json`";
        TestWindowFunctions.testBuilder().sqlQuery(" select rnum, position_id,    ntile(4) over(order by position_id)  from (select position_id, row_number()        over(order by position_id) as rnum        from cp.`employee.json`)").ordered().sqlBaselineQuery(" select row_number() over(order by position_id) as rnum,     position_id,     ntile(4) over(order by position_id)  from cp.`employee.json`").build().run();
    }
}

