/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec;

import org.apache.drill.BaseTestQuery;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRepeatedReaders
extends BaseTestQuery {
    static FileSystem fs;

    @BeforeClass
    public static void initFs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "local");
        fs = FileSystem.get((Configuration)conf);
    }

    private static void deleteTableIfExists(String tableName) {
        try {
            Path path = new Path(TestRepeatedReaders.getDfsTestTmpSchemaLocation(), tableName);
            if (fs.exists(path)) {
                fs.delete(path, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndQuery(String datafile) throws Exception {
        String query = String.format("select * from cp.`parquet/%s`", datafile);
        String tableName = "test_repeated_readers_" + datafile;
        try {
            TestRepeatedReaders.test("create table dfs_test.tmp.`%s` as %s", tableName, query);
            TestRepeatedReaders.testBuilder().sqlQuery("select * from dfs_test.tmp.`%s` d", tableName).ordered().jsonBaselineFile("parquet/" + datafile).go();
        }
        finally {
            TestRepeatedReaders.deleteTableIfExists(tableName);
        }
    }

    @Test
    public void testNestedRepeatedMapInsideRepeatedMap() throws Exception {
        this.createAndQuery("2292.rm_rm.json");
    }

    @Test
    public void testNestedRepeatedMapInsideMapInsideRepeatedMap() throws Exception {
        this.createAndQuery("2292.rm_m_rm.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedRepeatedListInsideRepeatedMap() throws Exception {
        TestRepeatedReaders.runSQL("alter session set `store.format` = 'json'");
        try {
            this.createAndQuery("2292.rl_rm.json");
        }
        finally {
            TestRepeatedReaders.runSQL("alter session set `store.format` = 'parquet'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedRepeatedMapInsideRepeatedList() throws Exception {
        TestRepeatedReaders.runSQL("alter session set `store.format` = 'json'");
        try {
            this.createAndQuery("2292.rm_rl.json");
        }
        finally {
            TestRepeatedReaders.runSQL("alter session set `store.format` = 'parquet'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedRepeatedListInsideRepeatedList() throws Exception {
        TestRepeatedReaders.runSQL("alter session set `store.format` = 'json'");
        try {
            this.createAndQuery("2292.rl_rl.json");
        }
        finally {
            TestRepeatedReaders.runSQL("alter session set `store.format` = 'parquet'");
        }
    }
}

