/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.vector.BigIntVector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestQueriesOnLargeFile
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestQueriesOnLargeFile.class);
    private static File dataFile = null;
    private static int NUM_RECORDS = 15000;

    @BeforeClass
    public static void generateTestData() throws Exception {
        boolean success;
        while (!(dataFile = File.createTempFile("drill-json", ".json")).exists() || !(success = dataFile.delete())) {
            logger.trace("retry creating tmp file");
        }
        PrintWriter printWriter = new PrintWriter(dataFile);
        for (int i = 1; i <= NUM_RECORDS; ++i) {
            printWriter.println("{");
            printWriter.println("  \"id\" : " + Math.random() + ",");
            printWriter.println("  \"summary\" : \"Apache Drill provides low latency ad-hoc queries to many different data sources, including nested data. Inspired by Google's Dremel, Drill is designed to scale to 10,000 servers and query petabytes of data in seconds.\"");
            printWriter.println("}");
        }
        printWriter.close();
    }

    @Test
    public void testRead() throws Exception {
        List<QueryDataBatch> results = TestQueriesOnLargeFile.testSqlWithResults(String.format("SELECT count(*) FROM dfs_test.`default`.`%s`", dataFile.getPath()));
        RecordBatchLoader batchLoader = new RecordBatchLoader(TestQueriesOnLargeFile.getAllocator());
        for (QueryDataBatch batch : results) {
            batchLoader.load(batch.getHeader().getDef(), batch.getData());
            if (batchLoader.getRecordCount() <= 0) continue;
            BigIntVector countV = (BigIntVector)batchLoader.getValueAccessorById(BigIntVector.class, new int[]{0}).getValueVector();
            Assert.assertTrue((String)("Total of " + NUM_RECORDS + " records expected in count"), (countV.getAccessor().get(0) == (long)NUM_RECORDS ? 1 : 0) != 0);
            batchLoader.clear();
            batch.release();
        }
    }

    @Test
    public void testMergingReceiver() throws Exception {
        String plan = Files.toString((File)org.apache.drill.common.util.FileUtils.getResourceAsFile((String)"/largefiles/merging_receiver_large_data.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", TestQueriesOnLargeFile.escapeJsonString((String)dataFile.getPath()));
        List<QueryDataBatch> results = TestQueriesOnLargeFile.testPhysicalWithResults(plan);
        int recordsInOutput = 0;
        for (QueryDataBatch batch : results) {
            recordsInOutput += batch.getHeader().getDef().getRecordCount();
            batch.release();
        }
        Assert.assertTrue((String)String.format("Number of records in output is wrong: expected=%d, actual=%s", NUM_RECORDS, recordsInOutput), (NUM_RECORDS == recordsInOutput ? 1 : 0) != 0);
    }

    @AfterClass
    public static void deleteTestData() throws Exception {
        if (dataFile != null && dataFile.exists()) {
            FileUtils.forceDelete((File)dataFile);
        }
    }
}

