/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec;

import java.util.Random;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.QuickSort;

public class SortTest {
    private static final int RECORD_COUNT = 10000000;
    private static final int KEY_SIZE = 10;
    private static final int DATA_SIZE = 90;
    private static final int RECORD_SIZE = 100;
    private byte[] data;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 100; ++i) {
            SortTest st = new SortTest();
            long nanos = st.doSort();
            System.out.print("Sort Completed in ");
            System.out.print(nanos);
            System.out.println(" ns.");
        }
    }

    SortTest() {
        System.out.print("Generating data... ");
        this.data = new byte[1000000000];
        Random r = new Random();
        r.nextBytes(this.data);
        System.out.print("Data generated. ");
    }

    public long doSort() {
        QuickSort qs = new QuickSort();
        ByteSortable b = new ByteSortable();
        long nano = System.nanoTime();
        qs.sort((IndexedSortable)b, 0, 10000000);
        return System.nanoTime() - nano;
    }

    private class ByteSortable
    implements IndexedSortable {
        final byte[] space = new byte[100];
        final BytesWritable.Comparator comparator = new BytesWritable.Comparator();

        private ByteSortable() {
        }

        public int compare(int index1, int index2) {
            return this.comparator.compare(SortTest.this.data, index1 * 100, 10, SortTest.this.data, index2 * 100, 10);
        }

        public void swap(int index1, int index2) {
            int start1 = index1 * 100;
            int start2 = index2 * 100;
            System.arraycopy(SortTest.this.data, start1, this.space, 0, 100);
            System.arraycopy(SortTest.this.data, start2, SortTest.this.data, start1, 100);
            System.arraycopy(this.space, 0, SortTest.this.data, start2, 100);
        }
    }
}

