/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.ValueVector;

public class RunRootExec {
    public static DrillConfig c = DrillConfig.create();

    public static void main(String[] args) throws Exception {
        String path = args[0];
        int iterations = Integer.parseInt(args[1]);
        Drillbit bit = new Drillbit(c, RemoteServiceSet.getLocalServiceSet());
        bit.run();
        DrillbitContext bitContext = bit.getContext();
        PhysicalPlanReader reader = bitContext.getPlanReader();
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)new File(path), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = bitContext.getFunctionImplementationRegistry();
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), null, registry);
        for (int i = 0; i < iterations; ++i) {
            Stopwatch w = new Stopwatch().start();
            System.out.println("STARTITER:" + i);
            SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
            while (exec.next()) {
                for (ValueVector v : exec) {
                    v.clear();
                }
            }
            System.out.println("ENDITER: " + i);
            System.out.println("TIME: " + w.elapsed(TimeUnit.MILLISECONDS) + "ms");
            exec.close();
        }
        context.close();
        bit.close();
    }
}

