/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec;

import java.util.Iterator;
import org.apache.drill.exec.record.HyperVectorWrapper;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.ValueVector;

public class HyperVectorValueIterator
implements Iterator<Object> {
    private MaterializedField mf;
    private HyperVectorWrapper hyperVector;
    private int indexInVectorList;
    private int indexInCurrentVector;
    private ValueVector currVec;
    private long totalValues;
    private long totalValuesRead;
    private long recordLimit;

    public HyperVectorValueIterator(MaterializedField mf, HyperVectorWrapper hyperVector) {
        this.mf = mf;
        this.hyperVector = hyperVector;
        this.totalValues = 0L;
        this.indexInCurrentVector = 0;
        this.indexInVectorList = 0;
        this.recordLimit = -1L;
    }

    public void setRecordLimit(long limit) {
        this.recordLimit = limit;
    }

    public HyperVectorWrapper getHyperVector() {
        return this.hyperVector;
    }

    public long getTotalRecords() {
        if (this.recordLimit > 0L) {
            return this.recordLimit;
        }
        return this.totalValues;
    }

    public void determineTotalSize() {
        for (ValueVector vv : this.hyperVector.getValueVectors()) {
            this.totalValues += (long)vv.getAccessor().getValueCount();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.totalValuesRead == this.recordLimit) {
            return false;
        }
        if (this.indexInVectorList < this.hyperVector.getValueVectors().length) {
            return true;
        }
        return this.indexInCurrentVector < this.currVec.getAccessor().getValueCount();
    }

    @Override
    public Object next() {
        if (this.currVec == null || this.indexInCurrentVector == this.currVec.getAccessor().getValueCount()) {
            this.currVec = this.hyperVector.getValueVectors()[this.indexInVectorList];
            ++this.indexInVectorList;
            this.indexInCurrentVector = 0;
        }
        Object obj = this.currVec.getAccessor().getObject(this.indexInCurrentVector);
        ++this.indexInCurrentVector;
        ++this.totalValuesRead;
        return obj;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

