/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.TestWithZookeeper;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.server.Drillbit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillSystemTestBase
extends TestWithZookeeper {
    private static final Logger logger = LoggerFactory.getLogger(DrillSystemTestBase.class);
    private List<Drillbit> servers;

    public void startCluster(int numServers) {
        try {
            ImmutableList.Builder servers = ImmutableList.builder();
            for (int i = 0; i < numServers; ++i) {
                servers.add((Object)Drillbit.start((DrillConfig)DrillSystemTestBase.getConfig()));
            }
            this.servers = servers.build();
        }
        catch (DrillbitStartupException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void stopCluster() {
        if (this.servers != null) {
            for (Drillbit server : this.servers) {
                try {
                    server.close();
                }
                catch (Exception e) {
                    logger.warn("Error shutting down Drillbit", (Throwable)e);
                }
            }
        }
    }

    public Drillbit getABit() {
        return this.servers.iterator().next();
    }
}

