/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.work.foreman.SqlUnsupportedException;
import org.apache.drill.exec.work.foreman.UnsupportedRelOperatorException;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUnionAll
extends BaseTestQuery {
    private static final Logger logger = LoggerFactory.getLogger(TestUnionAll.class);

    @Test
    public void testUnionAll1() throws Exception {
        String query = "(select n_regionkey from cp.`tpch/nation.parquet`) union all (select r_regionkey from cp.`tpch/region.parquet`)";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q1.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("n_regionkey").build().run();
    }

    @Test
    public void testUnionAll2() throws Exception {
        String query = "select n1.n_nationkey from cp.`tpch/nation.parquet` n1 inner join cp.`tpch/region.parquet` r1 on n1.n_regionkey = r1.r_regionkey where n1.n_nationkey in (1, 2) union all select n2.n_nationkey from cp.`tpch/nation.parquet` n2 inner join cp.`tpch/region.parquet` r2 on n2.n_regionkey = r2.r_regionkey where n2.n_nationkey in (3, 4)";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q2.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("n_nationkey").build().run();
    }

    @Test
    public void testUnionAll3() throws Exception {
        String query = "select n1.n_nationkey from cp.`tpch/nation.parquet` n1 where n1.n_nationkey in (1, 2) group by n1.n_nationkey union all select r1.r_regionkey from cp.`tpch/region.parquet` r1 group by r1.r_regionkey";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q3.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("n_nationkey").build().run();
    }

    @Test
    public void testUnionAll4() throws Exception {
        String query = "select n_regionkey from cp.`tpch/nation.parquet` union all select r_regionkey from cp.`tpch/region.parquet` union all select n_nationkey from cp.`tpch/nation.parquet` union all select c_custkey from cp.`tpch/customer.parquet` where c_custkey < 5";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q4.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("n_regionkey").build().run();
    }

    @Test
    public void testUnionAll5() throws Exception {
        String query = "select r_name, r_comment, r_regionkey from cp.`tpch/region.parquet` r1 union all select r_name, r_comment, r_regionkey from cp.`tpch/region.parquet` r2";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q5.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT).baselineColumns("r_name", "r_comment", "r_regionkey").build().run();
    }

    @Test
    public void testUnionAll6() throws Exception {
        String query = "select n_nationkey, n_regionkey from cp.`tpch/nation.parquet` where n_regionkey = 1 union all select r_regionkey, r_regionkey from cp.`tpch/region.parquet` where r_regionkey = 2";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q6.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.INT).baselineColumns("n_nationkey", "n_regionkey").build().run();
    }

    @Test
    public void testUnionAll6_1() throws Exception {
        String query = "select n_nationkey, n_nationkey from cp.`tpch/nation.parquet` union all select r_regionkey, r_regionkey from cp.`tpch/region.parquet`";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q6_1.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.INT).baselineColumns("n_nationkey", "n_nationkey0").build().run();
    }

    @Test
    public void testUnionAll7() throws Exception {
        String query = "select 'abc' from cp.`tpch/region.parquet` union all select 'abcdefgh' from cp.`tpch/region.parquet`";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q7.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR).baselineColumns("EXPR$0").build().run();
    }

    @Test
    public void testUnionAll8() throws Exception {
        String query = "select n_name, n_nationkey from cp.`tpch/nation.parquet` union all select r_comment, r_regionkey  from cp.`tpch/region.parquet`";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q8.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT).baselineColumns("n_name", "n_nationkey").build().run();
    }

    @Test
    public void testUnionAll9() throws Exception {
        String file0 = FileUtils.getResourceAsFile((String)"/multilevel/json/1994/Q1/orders_94_q1.json").toURI().toString();
        String file1 = FileUtils.getResourceAsFile((String)"/multilevel/json/1995/Q1/orders_95_q1.json").toURI().toString();
        String query = String.format("select o_custkey, o_orderstatus, o_totalprice, o_orderdate, o_orderpriority, o_clerk, o_shippriority, o_comment, o_orderkey from dfs_test.`%s` union all select o_custkey, o_orderstatus, o_totalprice, o_orderdate, o_orderpriority, o_clerk, o_shippriority, o_comment, o_orderkey from dfs_test.`%s`", file0, file1);
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q9.tsv").baselineTypes(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.FLOAT8, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.BIGINT).baselineColumns("o_custkey", "o_orderstatus", "o_totalprice", "o_orderdate", "o_orderpriority", "o_clerk", "o_shippriority", "o_comment", "o_orderkey").build().run();
    }

    @Test
    public void testUnionAll10() throws Exception {
        String query = "(select n_name, 'LEFT' as LiteralConstant, n_nationkey, '1' as NumberConstant from cp.`tpch/nation.parquet`) union all (select 'RIGHT', r_name, '2', r_regionkey from cp.`tpch/region.parquet`)";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q10.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.INT).baselineColumns("n_name", "LiteralConstant", "n_nationkey", "NumberConstant").build().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnionAllViewExpandableStar() throws Exception {
        TestUnionAll.test("use dfs_test.tmp");
        TestUnionAll.test("create view nation_view_testunionall as select n_name, n_nationkey from cp.`tpch/nation.parquet`;");
        TestUnionAll.test("create view region_view_testunionall as select r_name, r_regionkey from cp.`tpch/region.parquet`;");
        String query1 = "(select * from dfs_test.tmp.`nation_view_testunionall`) union all (select * from dfs_test.tmp.`region_view_testunionall`) ";
        String query2 = "(select r_name, r_regionkey from cp.`tpch/region.parquet`) union all (select * from dfs_test.tmp.`nation_view_testunionall`)";
        try {
            TestUnionAll.testBuilder().sqlQuery(query1).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q11.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT).baselineColumns("n_name", "n_nationkey").build().run();
            TestUnionAll.testBuilder().sqlQuery(query2).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q12.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT).baselineColumns("r_name", "r_regionkey").build().run();
        }
        finally {
            TestUnionAll.test("drop view nation_view_testunionall");
            TestUnionAll.test("drop view region_view_testunionall");
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testUnionAllViewUnExpandableStar() throws Exception {
        TestUnionAll.test("use dfs_test.tmp");
        TestUnionAll.test("create view nation_view_testunionall as select * from cp.`tpch/nation.parquet`;");
        try {
            String query = "(select * from dfs_test.tmp.`nation_view_testunionall`) union all (select * from cp.`tpch/region.parquet`)";
            TestUnionAll.test(query);
        }
        catch (UserException ex) {
            SqlUnsupportedException.errorClassNameToException((String)ex.getOrCreatePBError(false).getException().getExceptionClass());
            throw ex;
        }
        finally {
            TestUnionAll.test("drop view nation_view_testunionall");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiffDataTypesAndModes() throws Exception {
        TestUnionAll.test("use dfs_test.tmp");
        TestUnionAll.test("create view nation_view_testunionall as select n_name, n_nationkey from cp.`tpch/nation.parquet`;");
        TestUnionAll.test("create view region_view_testunionall as select r_name, r_regionkey from cp.`tpch/region.parquet`;");
        String t1 = "(select n_comment, n_regionkey from cp.`tpch/nation.parquet` limit 5)";
        String t2 = "(select * from nation_view_testunionall  limit 5)";
        String t3 = "(select full_name, store_id from cp.`employee.json` limit 5)";
        String t4 = "(select * from region_view_testunionall  limit 5)";
        String query1 = t1 + " union all " + t2 + " union all " + t3 + " union all " + t4;
        try {
            TestUnionAll.testBuilder().sqlQuery(query1).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q13.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.BIGINT).baselineColumns("n_comment", "n_regionkey").build().run();
        }
        finally {
            TestUnionAll.test("drop view nation_view_testunionall");
            TestUnionAll.test("drop view region_view_testunionall");
        }
    }

    @Test
    public void testDistinctOverUnionAllwithFullyQualifiedColumnNames() throws Exception {
        String query = "select distinct sq.x1, sq.x2 from ((select n_regionkey as a1, n_name as b1 from cp.`tpch/nation.parquet`) union all (select r_regionkey as a2, r_name as b2 from cp.`tpch/region.parquet`)) as sq(x1,x2)";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q14.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR).baselineColumns("x1", "x2").build().run();
    }

    @Test
    public void testUnionAllContainsColumnANumericConstant() throws Exception {
        String query = "(select n_nationkey, n_regionkey, n_name from cp.`tpch/nation.parquet`  limit 5) union all (select 1, n_regionkey, 'abc' from cp.`tpch/nation.parquet` limit 5)";
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q15.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_regionkey", "n_name").build().run();
    }

    @Test
    public void testUnionAllEmptySides() throws Exception {
        String query1 = "(select n_nationkey, n_regionkey, n_name from cp.`tpch/nation.parquet`  limit 0) union all (select 1, n_regionkey, 'abc' from cp.`tpch/nation.parquet` limit 5)";
        String query2 = "(select n_nationkey, n_regionkey, n_name from cp.`tpch/nation.parquet`  limit 5) union all (select 1, n_regionkey, 'abc' from cp.`tpch/nation.parquet` limit 0)";
        TestUnionAll.testBuilder().sqlQuery(query1).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q16.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_regionkey", "n_name").build().run();
        TestUnionAll.testBuilder().sqlQuery(query2).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q17.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_regionkey", "n_name").build().run();
    }

    @Test
    public void testAggregationOnUnionAllOperator() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/t.json").toURI().toString();
        String query1 = String.format("(select calc1, max(b1) as `max`, min(b1) as `min`, count(c1) as `count` from (select a1 + 10 as calc1, b1, c1 from dfs_test.`%s` union all select a1 + 100 as diff1, b1 as diff2, c1 as diff3 from dfs_test.`%s`) group by calc1 order by calc1)", root, root);
        String query2 = String.format("(select calc1, min(b1) as `min`, max(b1) as `max`, count(c1) as `count` from (select a1 + 10 as calc1, b1, c1 from dfs_test.`%s` union all select a1 + 100 as diff1, b1 as diff2, c1 as diff3 from dfs_test.`%s`) group by calc1 order by calc1)", root, root);
        TestUnionAll.testBuilder().sqlQuery(query1).ordered().csvBaselineFile("testframework/testExampleQueries/testAggregationOnUnionAllOperator/q1.tsv").baselineTypes(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.BIGINT).baselineColumns("calc1", "max", "min", "count").build().run();
        TestUnionAll.testBuilder().sqlQuery(query2).ordered().csvBaselineFile("testframework/testExampleQueries/testAggregationOnUnionAllOperator/q2.tsv").baselineTypes(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.BIGINT).baselineColumns("calc1", "min", "max", "count").build().run();
    }

    @Test(expected=UserException.class)
    public void testUnionAllImplicitCastingFailure() throws Exception {
        String rootInt = FileUtils.getResourceAsFile((String)"/store/json/intData.json").toURI().toString();
        String rootBoolean = FileUtils.getResourceAsFile((String)"/store/json/booleanData.json").toURI().toString();
        String query = String.format("(select key from dfs_test.`%s` union all select key from dfs_test.`%s` )", rootInt, rootBoolean);
        TestUnionAll.test(query);
    }

    @Test
    public void testDateAndTimestampJson() throws Exception {
        String rootDate = FileUtils.getResourceAsFile((String)"/store/json/dateData.json").toURI().toString();
        String rootTimpStmp = FileUtils.getResourceAsFile((String)"/store/json/timeStmpData.json").toURI().toString();
        String query1 = String.format("(select max(key) as key from dfs_test.`%s` union all select key from dfs_test.`%s`)", rootDate, rootTimpStmp);
        String query2 = String.format("select key from dfs_test.`%s` union all select max(key) as key from dfs_test.`%s`", rootDate, rootTimpStmp);
        String query3 = String.format("select key from dfs_test.`%s` union all select max(key) as key from dfs_test.`%s`", rootDate, rootTimpStmp);
        TestUnionAll.testBuilder().sqlQuery(query1).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q18_1.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR).baselineColumns("key").build().run();
        TestUnionAll.testBuilder().sqlQuery(query2).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q18_2.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR).baselineColumns("key").build().run();
        TestUnionAll.testBuilder().sqlQuery(query3).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/q18_3.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR).baselineColumns("key").build().run();
    }

    @Test
    public void testUnionAllOneInputContainsAggFunction() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/csv/1994/Q1/orders_94_q1.csv").toURI().toString();
        String query1 = String.format("select * from ((select count(c1) as ct from (select columns[0] c1 from dfs.`%s`)) \nunion all \n(select columns[0] c2 from dfs.`%s`)) order by ct limit 3", root, root);
        String query2 = String.format("select * from ((select columns[0] ct from dfs.`%s`)\nunion all \n(select count(c1) as c2 from (select columns[0] c1 from dfs.`%s`))) order by ct limit 3", root, root);
        String query3 = String.format("select * from ((select count(c1) as ct from (select columns[0] c1 from dfs.`%s`))\nunion all \n(select count(c1) as c2 from (select columns[0] c1 from dfs.`%s`))) order by ct", root, root);
        TestUnionAll.testBuilder().sqlQuery(query1).ordered().baselineColumns("ct").baselineValues(10L).baselineValues(66L).baselineValues(99L).build().run();
        TestUnionAll.testBuilder().sqlQuery(query2).ordered().baselineColumns("ct").baselineValues(10L).baselineValues(66L).baselineValues(99L).build().run();
        TestUnionAll.testBuilder().sqlQuery(query3).ordered().baselineColumns("ct").baselineValues(10L).baselineValues(10L).build().run();
    }

    @Test
    public void testUnionInputsGroupByOnCSV() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/csv/1994/Q1/orders_94_q1.csv").toURI().toString();
        String query = String.format("select * from \n((select columns[0] as col0 from dfs.`%s` t1 \nwhere t1.columns[0] = 66) \nunion all \n(select columns[0] c2 from dfs.`%s` t2 \nwhere t2.columns[0] is not null \ngroup by columns[0])) \ngroup by col0", root, root);
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col0").baselineValues("290").baselineValues("291").baselineValues("323").baselineValues("352").baselineValues("389").baselineValues("417").baselineValues("66").baselineValues("673").baselineValues("833").baselineValues("99").build().run();
    }

    @Test
    public void testUnionAllDiffTypesAtPlanning() throws Exception {
        String query = "select count(c1) as ct from (select cast(r_regionkey as int) c1 from cp.`tpch/region.parquet`) union all (select cast(r_regionkey as int) c2 from cp.`tpch/region.parquet`)";
        TestUnionAll.testBuilder().sqlQuery(query).ordered().baselineColumns("ct").baselineValues(5L).baselineValues(0L).baselineValues(1L).baselineValues(2L).baselineValues(3L).baselineValues(4L).build().run();
    }

    @Test
    public void testUnionAllRightEmptyJson() throws Exception {
        String rootEmpty = FileUtils.getResourceAsFile((String)"/project/pushdown/empty.json").toURI().toString();
        String rootSimple = FileUtils.getResourceAsFile((String)"/store/json/booleanData.json").toURI().toString();
        String queryRightEmpty = String.format("select key from dfs_test.`%s` union all select key from dfs_test.`%s`", rootSimple, rootEmpty);
        TestUnionAll.testBuilder().sqlQuery(queryRightEmpty).unOrdered().baselineColumns("key").baselineValues(true).baselineValues(false).build().run();
    }

    @Test
    public void testFilterPushDownOverUnionAll() throws Exception {
        String query = "select n_regionkey from \n(select n_regionkey from cp.`tpch/nation.parquet` union all select r_regionkey from cp.`tpch/region.parquet`) \nwhere n_regionkey > 0 and n_regionkey < 2 \norder by n_regionkey";
        String[] expectedPlan = new String[]{".*Filter.*\n.*UnionAll.*\n.*Scan.*columns=\\[`n_regionkey`\\].*\n.*Scan.*columns=\\[`r_regionkey`\\].*"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPlan);
        TestUnionAll.testBuilder().sqlQuery(query).ordered().baselineColumns("n_regionkey").baselineValues(1).baselineValues(1).baselineValues(1).baselineValues(1).baselineValues(1).baselineValues(1).build().run();
    }

    @Test
    public void testInListPushDownOverUnionAll() throws Exception {
        String query = "select n_nationkey \nfrom (select n1.n_nationkey from cp.`tpch/nation.parquet` n1 inner join cp.`tpch/region.parquet` r1 on n1.n_regionkey = r1.r_regionkey \nunion all \nselect n2.n_nationkey from cp.`tpch/nation.parquet` n2 inner join cp.`tpch/region.parquet` r2 on n2.n_regionkey = r2.r_regionkey) \nwhere n_nationkey in (1, 2)";
        String[] expectedPlan = new String[]{"Filter.*\n.*UnionAll.*\n.*Project.*\n.*HashJoin.*\n.*Project.*\n.*Scan.*columns=\\[`n_regionkey`, `n_nationkey`\\].*\n.*Scan.*columns=\\[`r_regionkey`\\].*\n.*Project.*\n.*HashJoin.*\n.*Project.*\n.*Scan.*columns=\\[`n_regionkey`, `n_nationkey`\\].*\n.*Scan.*columns=\\[`r_regionkey`\\].*"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPlan);
        TestUnionAll.testBuilder().sqlQuery(query).ordered().baselineColumns("n_nationkey").baselineValues(1).baselineValues(2).baselineValues(1).baselineValues(2).build().run();
    }

    @Test
    public void testFilterPushDownOverUnionAllCSV() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/csv/1994/Q1/orders_94_q1.csv").toURI().toString();
        String query = String.format("select ct \nfrom ((select count(c1) as ct from (select columns[0] c1 from dfs.`%s`)) \nunion all \n(select columns[0] c2 from dfs.`%s`)) \nwhere ct < 100", root, root);
        String[] expectedPlan = new String[]{"Filter.*\n.*UnionAll.*\n.*StreamAgg.*\n.*Project.*\n.*Scan.*columns=\\[`columns`\\[0\\]\\].*\n.*Project.*\n.*Scan.*columns=\\[`columns`\\[0\\]\\].*"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPlan);
        TestUnionAll.testBuilder().sqlQuery(query).ordered().baselineColumns("ct").baselineValues(10L).baselineValues(66L).baselineValues(99L).build().run();
    }

    @Test
    public void testProjectPushDownOverUnionAllWithProject() throws Exception {
        String query = "select n_nationkey, n_name from \n(select n_nationkey, n_name, n_comment from cp.`tpch/nation.parquet` \nunion all select r_regionkey, r_name, r_comment  from cp.`tpch/region.parquet`)";
        String[] expectedPlan = new String[]{"Project\\(n_nationkey=\\[\\$0\\], n_name=\\[\\$1\\]\\).*\n.*UnionAll.*\n.*Project.*\n.*Scan.*columns=\\[`n_nationkey`, `n_name`, `n_comment`\\].*\n.*Project.*\n.*Scan.*columns=\\[`r_regionkey`, `r_name`, `r_comment`\\].*"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPlan);
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/testProjectPushDownOverUnionAllWithProject.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_name").build().run();
    }

    @Test
    public void testProjectPushDownOverUnionAllWithoutProject() throws Exception {
        String query = "select n_nationkey from \n(select n_nationkey, n_name, n_comment from cp.`tpch/nation.parquet` \nunion all select r_regionkey, r_name, r_comment  from cp.`tpch/region.parquet`)";
        String[] expectedPlan = new String[]{"Project\\(n_nationkey=\\[\\$0\\]\\).*\n.*UnionAll.*\n.*Project.*\n.*Scan.*columns=\\[`n_nationkey`, `n_name`, `n_comment`\\].*\n.*Project.*\n.*Scan.*columns=\\[`r_regionkey`, `r_name`, `r_comment`\\].*"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPlan);
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/testProjectPushDownOverUnionAllWithoutProject.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("n_nationkey").build().run();
    }

    @Test
    public void testProjectWithExpressionPushDownOverUnionAll() throws Exception {
        String query = "select 2 * n_nationkey as col from \n(select n_nationkey, n_name, n_comment from cp.`tpch/nation.parquet` \nunion all select r_regionkey, r_name, r_comment  from cp.`tpch/region.parquet`)";
        String[] expectedPlan = new String[]{"UnionAll.*\n.*Project.*\n.*Scan.*columns=\\[`n_nationkey`, `n_name`, `n_comment`\\].*\n.*Project.*\n.*Scan.*columns=\\[`r_regionkey`, `r_name`, `r_comment`\\].*"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPlan);
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/testProjectWithExpressionPushDownOverUnionAll.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("col").build().run();
    }

    @Test
    public void testProjectDownOverUnionAllImplicitCasting() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/nations.csv").toURI().toString();
        String query = String.format("select 2 * n_nationkey as col from \n(select n_nationkey, n_name, n_comment from cp.`tpch/nation.parquet` \nunion all select columns[0], columns[1], columns[2] from dfs.`%s`) \norder by col limit 10", root);
        String[] expectedPlan = new String[]{"UnionAll.*\n..*Project.*\n.*Scan.*columns=\\[`n_nationkey`, `n_name`, `n_comment`\\].*\n.*Project.*\n.*Scan.*columns=\\[`columns`\\[0\\], `columns`\\[1\\], `columns`\\[2\\]\\]"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPlan);
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/testProjectDownOverUnionAllImplicitCasting.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("col").build().run();
    }

    @Test
    public void testProjectPushDownProjectColumnReorderingAndAlias() throws Exception {
        String query = "select n_comment as col1, n_nationkey as col2, n_name as col3 from \n(select n_nationkey, n_name, n_comment from cp.`tpch/nation.parquet` \nunion all select r_regionkey, r_name, r_comment  from cp.`tpch/region.parquet`)";
        String[] expectedPlan = new String[]{"UnionAll.*\n.*Project.*\n.*Scan.*columns=\\[`n_nationkey`, `n_name`, `n_comment`\\].*\n.*Project.*\n.*Scan.*columns=\\[`r_regionkey`, `r_name`, `r_comment`\\]"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPlan);
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/testProjectPushDownProjectColumnReorderingAndAlias.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR).baselineColumns("col1", "col2", "col3").build().run();
    }

    @Test
    public void testProjectFiltertPushDownOverUnionAll() throws Exception {
        String query = "select n_nationkey from \n(select n_nationkey, n_name, n_comment from cp.`tpch/nation.parquet` \nunion all select r_regionkey, r_name, r_comment  from cp.`tpch/region.parquet`) \nwhere n_nationkey > 0 and n_nationkey < 4";
        String[] expectedPlan = new String[]{"Filter.*\n.*UnionAll.*\n.*Project.*\n.*Scan.*columns=\\[`n_nationkey`, `n_name`, `n_comment`\\].*\n.*Project.*\n.*Scan.*columns=\\[`r_regionkey`, `r_name`, `r_comment`\\]"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query, expectedPlan, excludedPlan);
        TestUnionAll.testBuilder().sqlQuery(query).unOrdered().csvBaselineFile("testframework/testUnionAllQueries/testProjectFiltertPushDownOverUnionAll.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("n_nationkey").build().run();
    }

    @Test
    public void testUnionAllInWith() throws Exception {
        String query1 = "WITH year_total \n     AS (SELECT c.r_regionkey    customer_id,\n                1 year_total\n         FROM   cp.`tpch/region.parquet` c\n         UNION ALL \n         SELECT c.r_regionkey    customer_id, \n                1 year_total\n         FROM   cp.`tpch/region.parquet` c) \nSELECT count(t_s_secyear.customer_id) as ct \nFROM   year_total t_s_firstyear, \n       year_total t_s_secyear, \n       year_total t_w_firstyear, \n       year_total t_w_secyear \nWHERE  t_s_secyear.customer_id = t_s_firstyear.customer_id \n       AND t_s_firstyear.customer_id = t_w_secyear.customer_id \n       AND t_s_firstyear.customer_id = t_w_firstyear.customer_id \n       AND CASE \n             WHEN t_w_firstyear.year_total > 0 THEN t_w_secyear.year_total \n             ELSE NULL \n           END > -1";
        String query2 = "WITH year_total \n     AS (SELECT c.r_regionkey    customer_id,\n                1 year_total\n         FROM   cp.`tpch/region.parquet` c\n         UNION ALL \n         SELECT c.r_regionkey    customer_id, \n                1 year_total\n         FROM   cp.`tpch/region.parquet` c) \nSELECT count(t_w_firstyear.customer_id) as ct \nFROM   year_total t_w_firstyear, \n       year_total t_w_secyear \nWHERE  t_w_firstyear.year_total = t_w_secyear.year_total \n AND t_w_firstyear.year_total > 0 and t_w_secyear.year_total > 0";
        String query3 = "WITH year_total_1\n             AS (SELECT c.r_regionkey    customer_id,\n                        1 year_total\n                 FROM   cp.`tpch/region.parquet` c\n                 UNION ALL \n                 SELECT c.r_regionkey    customer_id, \n                        1 year_total\n                 FROM   cp.`tpch/region.parquet` c) \n             , year_total_2\n             AS (SELECT c.n_nationkey    customer_id,\n                        1 year_total\n                 FROM   cp.`tpch/nation.parquet` c\n                 UNION ALL \n                 SELECT c.n_nationkey    customer_id, \n                        1 year_total\n                 FROM   cp.`tpch/nation.parquet` c) \n        SELECT count(t_w_firstyear.customer_id) as ct\n        FROM   year_total_1 t_w_firstyear,\n               year_total_2 t_w_secyear\n        WHERE  t_w_firstyear.year_total = t_w_secyear.year_total\n           AND t_w_firstyear.year_total > 0 and t_w_secyear.year_total > 0";
        String query4 = "WITH year_total_1\n             AS (SELECT c.r_regionkey    customer_id,\n                        1 year_total\n                 FROM   cp.`tpch/region.parquet` c\n                 UNION ALL \n                 SELECT c.n_nationkey    customer_id, \n                        1 year_total\n                 FROM   cp.`tpch/nation.parquet` c), \n             year_total_2\n             AS (SELECT c.r_regionkey    customer_id,\n                        1 year_total\n                 FROM   cp.`tpch/region.parquet` c\n                 UNION ALL \n                 SELECT c.n_nationkey    customer_id, \n                        1 year_total\n                 FROM   cp.`tpch/nation.parquet` c) \n        SELECT count(t_w_firstyear.customer_id) as ct \n        FROM   year_total_1 t_w_firstyear,\n               year_total_2 t_w_secyear\n        WHERE  t_w_firstyear.year_total = t_w_secyear.year_total\n         AND t_w_firstyear.year_total > 0 and t_w_secyear.year_total > 0";
        TestUnionAll.testBuilder().sqlQuery("WITH year_total \n     AS (SELECT c.r_regionkey    customer_id,\n                1 year_total\n         FROM   cp.`tpch/region.parquet` c\n         UNION ALL \n         SELECT c.r_regionkey    customer_id, \n                1 year_total\n         FROM   cp.`tpch/region.parquet` c) \nSELECT count(t_s_secyear.customer_id) as ct \nFROM   year_total t_s_firstyear, \n       year_total t_s_secyear, \n       year_total t_w_firstyear, \n       year_total t_w_secyear \nWHERE  t_s_secyear.customer_id = t_s_firstyear.customer_id \n       AND t_s_firstyear.customer_id = t_w_secyear.customer_id \n       AND t_s_firstyear.customer_id = t_w_firstyear.customer_id \n       AND CASE \n             WHEN t_w_firstyear.year_total > 0 THEN t_w_secyear.year_total \n             ELSE NULL \n           END > -1").ordered().baselineColumns("ct").baselineValues(80L).build().run();
        TestUnionAll.testBuilder().sqlQuery("WITH year_total \n     AS (SELECT c.r_regionkey    customer_id,\n                1 year_total\n         FROM   cp.`tpch/region.parquet` c\n         UNION ALL \n         SELECT c.r_regionkey    customer_id, \n                1 year_total\n         FROM   cp.`tpch/region.parquet` c) \nSELECT count(t_w_firstyear.customer_id) as ct \nFROM   year_total t_w_firstyear, \n       year_total t_w_secyear \nWHERE  t_w_firstyear.year_total = t_w_secyear.year_total \n AND t_w_firstyear.year_total > 0 and t_w_secyear.year_total > 0").ordered().baselineColumns("ct").baselineValues(100L).build().run();
        TestUnionAll.testBuilder().sqlQuery("WITH year_total_1\n             AS (SELECT c.r_regionkey    customer_id,\n                        1 year_total\n                 FROM   cp.`tpch/region.parquet` c\n                 UNION ALL \n                 SELECT c.r_regionkey    customer_id, \n                        1 year_total\n                 FROM   cp.`tpch/region.parquet` c) \n             , year_total_2\n             AS (SELECT c.n_nationkey    customer_id,\n                        1 year_total\n                 FROM   cp.`tpch/nation.parquet` c\n                 UNION ALL \n                 SELECT c.n_nationkey    customer_id, \n                        1 year_total\n                 FROM   cp.`tpch/nation.parquet` c) \n        SELECT count(t_w_firstyear.customer_id) as ct\n        FROM   year_total_1 t_w_firstyear,\n               year_total_2 t_w_secyear\n        WHERE  t_w_firstyear.year_total = t_w_secyear.year_total\n           AND t_w_firstyear.year_total > 0 and t_w_secyear.year_total > 0").ordered().baselineColumns("ct").baselineValues(500L).build().run();
        TestUnionAll.testBuilder().sqlQuery("WITH year_total_1\n             AS (SELECT c.r_regionkey    customer_id,\n                        1 year_total\n                 FROM   cp.`tpch/region.parquet` c\n                 UNION ALL \n                 SELECT c.n_nationkey    customer_id, \n                        1 year_total\n                 FROM   cp.`tpch/nation.parquet` c), \n             year_total_2\n             AS (SELECT c.r_regionkey    customer_id,\n                        1 year_total\n                 FROM   cp.`tpch/region.parquet` c\n                 UNION ALL \n                 SELECT c.n_nationkey    customer_id, \n                        1 year_total\n                 FROM   cp.`tpch/nation.parquet` c) \n        SELECT count(t_w_firstyear.customer_id) as ct \n        FROM   year_total_1 t_w_firstyear,\n               year_total_2 t_w_secyear\n        WHERE  t_w_firstyear.year_total = t_w_secyear.year_total\n         AND t_w_firstyear.year_total > 0 and t_w_secyear.year_total > 0").ordered().baselineColumns("ct").baselineValues(900L).build().run();
    }
}

