/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.common.util.TestTools;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStarQueries
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestStarQueries.class);
    static final String WORKING_PATH = TestTools.getWorkingPath();
    static final String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";

    @Test
    public void testSelStarCommaSameColumnRepeated() throws Exception {
        TestStarQueries.testBuilder().sqlQuery("select n_name, *, n_name, n_name from cp.`tpch/nation.parquet`").ordered().csvBaselineFile("testframework/testStarQueries/testSelStarCommaSameColumnRepeated/q1.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("n_name", "n_nationkey", "n_name0", "n_regionkey", "n_comment", "n_name00", "n_name1").build().run();
        TestStarQueries.testBuilder().sqlQuery("select n_name, *, n_name, n_name from cp.`tpch/nation.parquet` limit 2").ordered().csvBaselineFile("testframework/testStarQueries/testSelStarCommaSameColumnRepeated/q2.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("n_name", "n_nationkey", "n_name0", "n_regionkey", "n_comment", "n_name00", "n_name1").build().run();
        TestStarQueries.testBuilder().sqlQuery("select *, n_name, *, n_name, n_name from cp.`tpch/nation.parquet`").ordered().csvBaselineFile("testframework/testStarQueries/testSelStarCommaSameColumnRepeated/q3.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_name", "n_regionkey", "n_comment", "n_name0", "n_nationkey0", "n_name1", "n_regionkey0", "n_comment0", "n_name00", "n_name10").build().run();
        TestStarQueries.testBuilder().sqlQuery("select *, n_name, *, n_name, n_name from cp.`tpch/nation.parquet` limit 2").ordered().csvBaselineFile("testframework/testStarQueries/testSelStarCommaSameColumnRepeated/q4.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_name", "n_regionkey", "n_comment", "n_name0", "n_nationkey0", "n_name1", "n_regionkey0", "n_comment0", "n_name00", "n_name10").build().run();
    }

    @Test
    public void testSelStarMultipleStarsRegularColumnAsAlias() throws Exception {
        TestStarQueries.testBuilder().sqlQuery("select *, n_name as extra, *, n_name as extra from cp.`tpch/nation.parquet`").ordered().csvBaselineFile("testframework/testStarQueries/testSelStarMultipleStarsRegularColumnAsAlias/q1.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_name", "n_regionkey", "n_comment", "extra", "n_nationkey0", "n_name0", "n_regionkey0", "n_comment0", "extra0").build().run();
        TestStarQueries.testBuilder().sqlQuery("select *, n_name as extra, *, n_name as extra from cp.`tpch/nation.parquet` limit 2").ordered().csvBaselineFile("testframework/testStarQueries/testSelStarMultipleStarsRegularColumnAsAlias/q2.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_name", "n_regionkey", "n_comment", "extra", "n_nationkey0", "n_name0", "n_regionkey0", "n_comment0", "extra0").build().run();
    }

    @Test
    public void testSelStarMultipleStars() throws Exception {
        TestStarQueries.testBuilder().sqlQuery("select *, *, n_name from cp.`tpch/nation.parquet`").ordered().csvBaselineFile("testframework/testStarQueries/testSelStarMultipleStars/q1.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_name", "n_regionkey", "n_comment", "n_nationkey0", "n_name0", "n_regionkey0", "n_comment0", "n_name1").build().run();
        TestStarQueries.testBuilder().sqlQuery("select *, *, n_name from cp.`tpch/nation.parquet` limit 2").ordered().csvBaselineFile("testframework/testStarQueries/testSelStarMultipleStars/q2.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_name", "n_regionkey", "n_comment", "n_nationkey0", "n_name0", "n_regionkey0", "n_comment0", "n_name1").build().run();
    }

    @Test
    public void testSelStarWithAdditionalColumnLimit() throws Exception {
        TestStarQueries.testBuilder().sqlQuery("select *, n_nationkey, *, n_name from cp.`tpch/nation.parquet` limit 2").ordered().csvBaselineFile("testframework/testStarQueries/testSelStarWithAdditionalColumnLimit/q1.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("n_nationkey", "n_name", "n_regionkey", "n_comment", "n_nationkey0", "n_nationkey1", "n_name0", "n_regionkey0", "n_comment0", "n_name1").build().run();
    }

    @Test
    public void testSelStarOrderBy() throws Exception {
        TestStarQueries.testBuilder().ordered().sqlQuery(" select * from cp.`employee.json` order by last_name").sqlBaselineQuery(" select employee_id, full_name,first_name,last_name,position_id,position_title,store_id, department_id,birth_date,hire_date,salary,supervisor_id,education_level,marital_status,gender,management_role  from cp.`employee.json`  order by last_name ").build().run();
    }

    @Test
    public void testSelStarOrderByLimit() throws Exception {
        TestStarQueries.testBuilder().ordered().sqlQuery(" select * from cp.`employee.json` order by last_name limit 2").sqlBaselineQuery(" select employee_id, full_name,first_name,last_name,position_id,position_title,store_id, department_id,birth_date,hire_date,salary,supervisor_id,education_level,marital_status,gender,management_role  from cp.`employee.json`  order by last_name limit 2").build().run();
    }

    @Test
    public void testSelStarPlusRegCol() throws Exception {
        TestStarQueries.testBuilder().unOrdered().sqlQuery("select *, n_nationkey as key2 from cp.`tpch/nation.parquet` order by n_name limit 2").sqlBaselineQuery("select n_comment, n_name, n_nationkey, n_regionkey, n_nationkey as key2 from cp.`tpch/nation.parquet` order by n_name limit 2").build().run();
    }

    @Test
    public void testSelStarWhereOrderBy() throws Exception {
        TestStarQueries.testBuilder().ordered().sqlQuery("select * from cp.`employee.json` where first_name = 'James' order by last_name").sqlBaselineQuery("select employee_id, full_name,first_name,last_name,position_id,position_title,store_id, department_id,birth_date,hire_date,salary,supervisor_id,education_level,marital_status,gender,management_role  from cp.`employee.json`  where first_name = 'James' order by last_name").build().run();
    }

    @Test
    public void testSelStarJoin() throws Exception {
        TestStarQueries.testBuilder().ordered().sqlQuery("select * from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey order by n.n_name").sqlBaselineQuery("select n.n_nationkey, n.n_name,n.n_regionkey,n.n_comment,r.r_regionkey,r.r_name, r.r_comment from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey order by n.n_name").build().run();
    }

    @Test
    public void testSelLeftStarJoin() throws Exception {
        TestStarQueries.testBuilder().ordered().sqlQuery("select n.* from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey order by n.n_name").sqlBaselineQuery("select n.n_nationkey, n.n_name, n.n_regionkey, n.n_comment from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey order by n.n_name").build().run();
    }

    @Test
    public void testSelRightStarJoin() throws Exception {
        TestStarQueries.testBuilder().ordered().sqlQuery("select r.* from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey order by n.n_name").sqlBaselineQuery("select r.r_regionkey, r.r_name, r.r_comment from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey order by n.n_name").build().run();
    }

    @Test
    public void testSelStarRegColConstJoin() throws Exception {
        TestStarQueries.testBuilder().ordered().sqlQuery("select *, n.n_nationkey as n_nationkey0, 1 + 2 as constant from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey order by n.n_name").sqlBaselineQuery(" select n.n_nationkey, n.n_name, n.n_regionkey, n.n_comment, r.r_regionkey, r.r_name, r.r_comment,  n.n_nationkey as n_nationkey0, 1 + 2 as constant  from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r  where n.n_regionkey = r.r_regionkey  order by n.n_name").build().run();
    }

    @Test
    public void testSelStarBothSideJoin() throws Exception {
        TestStarQueries.testBuilder().unOrdered().sqlQuery("select n.*, r.* from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey").sqlBaselineQuery("select n.n_nationkey,n.n_name,n.n_regionkey,n.n_comment,r.r_regionkey,r.r_name,r.r_comment from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey order by n.n_name").build().run();
    }

    @Test
    public void testSelStarJoinSameColName() throws Exception {
        TestStarQueries.testBuilder().unOrdered().sqlQuery("select * from cp.`tpch/nation.parquet` n1, cp.`tpch/nation.parquet` n2 where n1.n_nationkey = n2.n_nationkey").sqlBaselineQuery("select n1.n_nationkey,n1.n_name,n1.n_regionkey,n1.n_comment,n2.n_nationkey,n2.n_name,n2.n_regionkey, n2.n_comment from cp.`tpch/nation.parquet` n1, cp.`tpch/nation.parquet` n2 where n1.n_nationkey = n2.n_nationkey").build().run();
    }

    @Test
    public void testStarView1() throws Exception {
        TestStarQueries.test("use dfs_test.tmp");
        TestStarQueries.test("create view vt1 as select * from cp.`tpch/region.parquet` r, cp.`tpch/nation.parquet` n where r.r_regionkey = n.n_regionkey");
        TestStarQueries.test("select * from vt1");
        TestStarQueries.test("drop view vt1");
    }

    @Test
    public void testSelStarSubQSchemaTable() throws Exception {
        TestStarQueries.test("select name, kind, type from (select * from sys.options);");
    }

    @Test
    public void testSelStarJoinSchemaWithSchemaLess() throws Exception {
        String query = "select t1.name, t1.kind, t2.n_nationkey from (select * from sys.options) t1 join (select * from cp.`tpch/nation.parquet`) t2 on t1.name = t2.n_name";
        TestStarQueries.test("alter session set `planner.enable_broadcast_join` = false");
        TestStarQueries.test(query);
        TestStarQueries.test("alter session set `planner.enable_broadcast_join` = true");
        TestStarQueries.test(query);
    }

    @Test
    public void testSelStarDifferentColumnOrder() throws Exception {
        TestStarQueries.test("select first_name, * from cp.`employee.json`;");
        TestStarQueries.test("select *, first_name, *, last_name from cp.`employee.json`;");
    }

    @Test(expected=UserException.class)
    public void testSelStarAmbiguousJoin() throws Exception {
        try {
            TestStarQueries.test("select x.n_nationkey, x.n_name, x.n_regionkey, x.r_name from (select * from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey) x ");
        }
        catch (UserException e) {
            logger.info("***** Test resulted in expected failure: " + e.getMessage());
            throw e;
        }
    }

    @Test
    public void testSelStarSubQJson2() throws Exception {
        TestStarQueries.test("select v.first_name from (select * from cp.`employee.json`) v limit 2");
    }

    @Test
    public void testSelStarSubQPrefix() throws Exception {
        TestStarQueries.test("select t.n_nationkey, t.n_name, t.n_regionkey from (select * from cp.`tpch/nation.parquet`) t where t.n_regionkey > 1 order by t.n_name");
        TestStarQueries.test("select n.n_regionkey, count(*) as cnt from ( select * from ( select * from cp.`tpch/nation.parquet`) t where t.n_nationkey < 10 ) n where n.n_nationkey >1 group by n.n_regionkey order by n.n_regionkey ; ");
        TestStarQueries.test("select t.n_regionkey, count(*) as cnt from (select * from cp.`tpch/nation.parquet`) t where t.n_nationkey > 1 group by t.n_regionkey order by t.n_regionkey;");
    }

    @Test
    public void testSelStarSubQNoPrefix() throws Exception {
        TestStarQueries.test("select n_nationkey, n_name, n_regionkey from (select * from cp.`tpch/nation.parquet`)  where n_regionkey > 1 order by n_name");
        TestStarQueries.test("select n_regionkey, count(*) as cnt from ( select * from ( select * from cp.`tpch/nation.parquet`)  where n_nationkey < 10 ) where n_nationkey >1 group by n_regionkey order by n_regionkey ; ");
        TestStarQueries.test("select n_regionkey, count(*) as cnt from (select * from cp.`tpch/nation.parquet`) t where n_nationkey > 1 group by n_regionkey order by n_regionkey;");
    }

    @Test
    public void testSelStarSubQJoin() throws Exception {
        TestStarQueries.test(" select n.n_nationkey, n.n_name, n.n_regionkey, r.r_name \n from (select * from cp.`tpch/nation.parquet`) n, \n      (select * from cp.`tpch/region.parquet`) r \n where n.n_regionkey = r.r_regionkey ");
        TestStarQueries.test(" select n.n_regionkey, count(*) as cnt \n from (select * from cp.`tpch/nation.parquet`) n  \n    , (select * from cp.`tpch/region.parquet`) r  \n where n.n_regionkey = r.r_regionkey and n.n_nationkey > 10 \n group by n.n_regionkey \n order by n.n_regionkey; ");
        TestStarQueries.test(" select *  \n from (select * from cp.`tpch/nation.parquet`) n \n    , (select * from cp.`tpch/region.parquet`) r \n where n.n_regionkey = r.r_regionkey ");
        TestStarQueries.test(" select *  \n from (select * from cp.`tpch/nation.parquet`) n \n    join (select * from cp.`tpch/region.parquet`) r \n on n.n_regionkey = r.r_regionkey ");
    }

    @Test
    public void testSelectStartSubQueryJoinWithWhereClause() throws Exception {
        TestStarQueries.test(" select n.n_regionkey, count(*) as cnt \n from   (select * from cp.`tpch/nation.parquet`) n  \n   join (select * from cp.`tpch/region.parquet`) r  \n on n.n_regionkey = r.r_regionkey \n where n.n_nationkey > 10 \n group by n.n_regionkey \n order by n.n_regionkey; ");
    }

    @Test
    public void testDRILL_595WithClause() throws Exception {
        TestStarQueries.test(" with x as (select * from cp.`region.json`) \n select x.region_id, x.sales_city \n from x where x.region_id > 10 limit 5;");
        TestStarQueries.test(" with x as (select * from cp.`region.json`) \n select region_id, sales_city \n from x where region_id > 10 limit 5;");
        TestStarQueries.test(" with x as (select * from cp.`tpch/nation.parquet`) \n select x.n_regionkey, count(*) as cnt \n from x \n where x.n_nationkey > 5 \n group by x.n_regionkey \n order by cnt limit 5; ");
    }

    @Test
    public void testDRILL_595WithClauseJoin() throws Exception {
        TestStarQueries.test("with n as (select * from cp.`tpch/nation.parquet`), \n      r as (select * from cp.`tpch/region.parquet`) \nselect n.n_nationkey, n.n_name, n.n_regionkey, r.r_name \nfrom  n, r \nwhere n.n_regionkey = r.r_regionkey ;");
        TestStarQueries.test("with n as (select * from cp.`tpch/nation.parquet`), \n      r as (select * from cp.`tpch/region.parquet`) \nselect n.n_regionkey, count(*) as cnt \nfrom  n, r \nwhere n.n_regionkey = r.r_regionkey  and n.n_nationkey > 5 \ngroup by n.n_regionkey \norder by cnt;");
    }

    @Test
    public void testStarWithOtherExpression() throws Exception {
        TestStarQueries.testBuilder().ordered().sqlQuery("select *  from cp.`tpch/nation.parquet` order by substr(n_name, 2, 5) limit 3").sqlBaselineQuery("select n_comment, n_name, n_nationkey, n_regionkey from cp.`tpch/nation.parquet` order by substr(n_name, 2, 5) limit 3 ").build().run();
        TestStarQueries.testBuilder().ordered().sqlQuery("select *, n_nationkey + 5 as myexpr from cp.`tpch/nation.parquet` limit 3").sqlBaselineQuery("select n_comment, n_name, n_nationkey, n_regionkey, n_nationkey + 5 as myexpr from cp.`tpch/nation.parquet` order by n_nationkey limit 3").build().run();
        TestStarQueries.testBuilder().ordered().sqlQuery("select *  from cp.`tpch/nation.parquet` where n_nationkey + 5 > 10 limit 3").sqlBaselineQuery("select n_comment, n_name, n_nationkey, n_regionkey  from cp.`tpch/nation.parquet` where n_nationkey + 5 > 10 order by n_nationkey limit 3").build().run();
    }

    @Test
    public void testStarPartitionFilterOrderBy() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/parquet` where dir0=1994 and dir1='Q1' order by dir0 limit 1", TEST_RES_PATH);
        DateTime mydate = new DateTime((Object)"1994-01-20T00:00:00.000");
        TestStarQueries.testBuilder().sqlQuery(query).ordered().baselineColumns("dir0", "dir1", "o_clerk", "o_comment", "o_custkey", "o_orderdate", "o_orderkey", "o_orderpriority", "o_orderstatus", "o_shippriority", "o_totalprice").baselineValues("1994", "Q1", "Clerk#000000743", "y pending requests integrate", 1292, mydate, 66, "5-LOW", "F", 0, 104190.66).build().run();
    }

    @Test
    public void testStarInSubquery() throws Exception {
        TestStarQueries.testBuilder().unOrdered().sqlQuery("select * from cp.`tpch/nation.parquet` where n_regionkey in (select r_regionkey from cp.`tpch/region.parquet`)").sqlBaselineQuery("select n_nationkey, n_name, n_regionkey, n_comment from cp.`tpch/nation.parquet` where n_regionkey in (select r_regionkey from cp.`tpch/region.parquet`)").build().run();
        TestStarQueries.testBuilder().unOrdered().sqlQuery("select * from cp.`tpch/nation.parquet` where (n_nationkey, n_name) in ( select n_nationkey, n_name from cp.`tpch/nation.parquet`)").sqlBaselineQuery("select n_nationkey, n_name, n_regionkey, n_comment from cp.`tpch/nation.parquet` where (n_nationkey, n_name) in ( select n_nationkey, n_name from cp.`tpch/nation.parquet`)").build().run();
        TestStarQueries.testBuilder().unOrdered().sqlQuery("select * from cp.`tpch/nation.parquet` where n_regionkey in ( select r_regionkey from cp.`tpch/region.parquet`) and       n_name in (select n_name from cp.`tpch/nation.parquet`)").sqlBaselineQuery("select n_nationkey, n_name, n_regionkey, n_comment from cp.`tpch/nation.parquet` where n_regionkey in ( select r_regionkey from cp.`tpch/region.parquet`) and       n_name in (select n_name from cp.`tpch/nation.parquet`)").build().run();
        TestStarQueries.testBuilder().unOrdered().sqlQuery("select * from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey and        (n.n_nationkey, n.n_name) in           ( select n2.n_nationkey, n2.n_name             from cp.`tpch/nation.parquet` n2, cp.`tpch/region.parquet` r2             where n2.n_regionkey = r2.r_regionkey)").sqlBaselineQuery("select n.n_nationkey, n.n_name, n.n_regionkey, n.n_comment, r.r_regionkey, r.r_name, r.r_comment from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey and        (n.n_nationkey, n.n_name) in           ( select n2.n_nationkey, n2.n_name             from cp.`tpch/nation.parquet` n2, cp.`tpch/region.parquet` r2             where n2.n_regionkey = r2.r_regionkey)").build().run();
    }

    @Test
    public void testSelectPartitionColumnOnly() throws Exception {
        String table = FileUtils.getResourceAsFile((String)"/multilevel/parquet").toURI().toString();
        String query1 = String.format("select dir0 from dfs_test.`%s` limit 1 ", table);
        String[] expectedPlan1 = new String[]{".*Project.*dir0=\\[\\$0\\]"};
        String[] excludedPlan1 = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query1, expectedPlan1, excludedPlan1);
        String query2 = String.format("select dir0, dir1 from dfs_test.`%s` limit 1 ", table);
        String[] expectedPlan2 = new String[]{".*Project.*dir0=\\[\\$0\\], dir1=\\[\\$1\\]"};
        String[] excludedPlan2 = new String[]{};
        PlanTestBase.testPlanMatchingPatterns(query2, expectedPlan2, excludedPlan2);
    }

    @Test
    public void testCaseSenJoinCTEWithRegTab() throws Exception {
        String query1 = "with a as ( select * from cp.`tpch/nation.parquet` ) select * from a, cp.`tpch/region.parquet` b where a.N_REGIONKEY = b.R_REGIONKEY";
        int actualRecordCount = TestStarQueries.testSql("with a as ( select * from cp.`tpch/nation.parquet` ) select * from a, cp.`tpch/region.parquet` b where a.N_REGIONKEY = b.R_REGIONKEY");
        int expectedRecordCount = 25;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output for query:\n%s\n expected=%d, received=%s", "with a as ( select * from cp.`tpch/nation.parquet` ) select * from a, cp.`tpch/region.parquet` b where a.N_REGIONKEY = b.R_REGIONKEY", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        String query2 = "with a as ( select * from cp.`tpch/nation.parquet` ) select * from a, cp.`tpch/region.parquet` b where a.n_regionkey = b.r_regionkey";
        actualRecordCount = TestStarQueries.testSql("with a as ( select * from cp.`tpch/nation.parquet` ) select * from a, cp.`tpch/region.parquet` b where a.n_regionkey = b.r_regionkey");
        expectedRecordCount = 25;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output for query:\n%s\n expected=%d, received=%s", "with a as ( select * from cp.`tpch/nation.parquet` ) select * from a, cp.`tpch/region.parquet` b where a.n_regionkey = b.r_regionkey", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }
}

