/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.PlanTestBase;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProjectPushDown
extends PlanTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestProjectPushDown.class);
    private final String[] TABLES = new String[]{"project/pushdown/empty.json", "project/pushdown/empty.csv", "tpch/lineitem.parquet"};

    @Test
    @Ignore
    public void testGroupBy() throws Exception {
        String expectedColNames = " \"columns\" : [ \"`marital_status`\" ]";
        TestProjectPushDown.testPhysicalPlan("select marital_status, COUNT(1) as cnt from cp.`employee.json` group by marital_status", expectedColNames);
    }

    @Test
    @Ignore
    public void testOrderBy() throws Exception {
        String expectedColNames = "\"columns\" : [ \"`employee_id`\", \"`full_name`\", \"`first_name`\", \"`last_name`\" ]";
        TestProjectPushDown.testPhysicalPlan("select employee_id , full_name, first_name , last_name from cp.`employee.json` order by first_name, last_name", expectedColNames);
    }

    @Test
    @Ignore
    public void testExprInSelect() throws Exception {
        String expectedColNames = "\"columns\" : [ \"`employee_id`\", \"`full_name`\", \"`first_name`\", \"`last_name`\" ]";
        TestProjectPushDown.testPhysicalPlan("select employee_id + 100, full_name, first_name , last_name from cp.`employee.json` order by first_name, last_name", expectedColNames);
    }

    @Test
    @Ignore
    public void testExprInWhere() throws Exception {
        String expectedColNames = "\"columns\" : [ \"`employee_id`\", \"`full_name`\", \"`first_name`\", \"`last_name`\" ]";
        TestProjectPushDown.testPhysicalPlan("select employee_id + 100, full_name, first_name , last_name from cp.`employee.json` where employee_id + 500 < 1000 ", expectedColNames);
    }

    @Test
    public void testJoin() throws Exception {
        String expectedColNames1 = "\"columns\" : [ \"`N_REGIONKEY`\", \"`N_NAME`\" ]";
        String expectedColNames2 = "\"columns\" : [ \"`R_REGIONKEY`\", \"`R_NAME`\" ]";
        TestProjectPushDown.testPhysicalPlan("SELECT\n  nations.N_NAME,\n  regions.R_NAME\nFROM\n  dfs_test.`[WORKING_PATH]/../../sample-data/nation.parquet` nations\nJOIN\n  dfs_test.`[WORKING_PATH]/../../sample-data/region.parquet` regions\n  on nations.N_REGIONKEY = regions.R_REGIONKEY", expectedColNames1, expectedColNames2);
    }

    @Test
    @Ignore
    public void testFromInfoSchema() throws Exception {
        String expectedColNames = " \"columns\" : [ \"`CATALOG_DESCRIPTION`\" ]";
        TestProjectPushDown.testPhysicalPlan("select count(CATALOG_DESCRIPTION) from INFORMATION_SCHEMA.CATALOGS", expectedColNames);
    }

    @Test
    public void testTPCH1() throws Exception {
        String expectedColNames = " \"columns\" : [ \"`l_returnflag`\", \"`l_linestatus`\", \"`l_shipdate`\", \"`l_quantity`\", \"`l_extendedprice`\", \"`l_discount`\", \"`l_tax`\" ]";
        this.testPhysicalPlanFromFile("queries/tpch/01.sql", expectedColNames);
    }

    @Test
    public void testTPCH3() throws Exception {
        String expectedColNames1 = "\"columns\" : [ \"`c_mktsegment`\", \"`c_custkey`\" ]";
        String expectedColNames2 = " \"columns\" : [ \"`o_orderdate`\", \"`o_shippriority`\", \"`o_custkey`\", \"`o_orderkey`\" ";
        String expectedColNames3 = "\"columns\" : [ \"`l_orderkey`\", \"`l_shipdate`\", \"`l_extendedprice`\", \"`l_discount`\" ]";
        this.testPhysicalPlanFromFile("queries/tpch/03.sql", expectedColNames1, expectedColNames2, expectedColNames3);
    }

    @Test
    public void testProjectPushDown() throws Exception {
        String pushDownSqlPattern = "select %s from cp.`%s` t";
        String projection = "t.trans_id, t.user_info.cust_id, t.marketing_info.keywords[0]";
        String expected = "\"columns\" : [ \"`trans_id`\", \"`user_info`.`cust_id`\", \"`marketing_info`.`keywords`[0]\" ],";
        for (String table : this.TABLES) {
            this.testPushDown(new PushDownTestInstance("select %s from cp.`%s` t", "\"columns\" : [ \"`trans_id`\", \"`user_info`.`cust_id`\", \"`marketing_info`.`keywords`[0]\" ],", "t.trans_id, t.user_info.cust_id, t.marketing_info.keywords[0]", table));
        }
    }

    @Test
    public void testProjectPastFilterPushDown() throws Exception {
        String pushDownSqlPattern = "select %s from cp.`%s` t where %s";
        String projection = "t.trans_id, t.user_info.cust_id, t.marketing_info.keywords[0]";
        String filter = "t.another_field = 10 and t.columns[0] = 100 and t.columns[1] = t.other.columns[2]";
        String expected = "\"columns\" : [ \"`another_field`\", \"`trans_id`\", \"`user_info`.`cust_id`\", \"`marketing_info`.`keywords`[0]\", \"`columns`[0]\", \"`columns`[1]\", \"`other`.`columns`[2]\" ],";
        for (String table : this.TABLES) {
            this.testPushDown(new PushDownTestInstance("select %s from cp.`%s` t where %s", "\"columns\" : [ \"`another_field`\", \"`trans_id`\", \"`user_info`.`cust_id`\", \"`marketing_info`.`keywords`[0]\", \"`columns`[0]\", \"`columns`[1]\", \"`other`.`columns`[2]\" ],", "t.trans_id, t.user_info.cust_id, t.marketing_info.keywords[0]", table, "t.another_field = 10 and t.columns[0] = 100 and t.columns[1] = t.other.columns[2]"));
        }
    }

    @Test
    public void testProjectPastJoinPushDown() throws Exception {
        String pushDownSqlPattern = "select %s from cp.`%s` t0, cp.`%s` t1 where %s";
        String projection = "t0.fcolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.scolumns[0], t1.smy.field, t1.sreally.nested.field[0]";
        String filter = "t0.fname = t1.sname and t0.fcolumns[1]=10 and t1.scolumns[1]=100";
        String firstExpected = "\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],";
        String secondExpected = "\"columns\" : [ \"`sname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ],";
        for (String table : this.TABLES) {
            this.testPushDown(new PushDownTestInstance("select %s from cp.`%s` t0, cp.`%s` t1 where %s", new String[]{"\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],", "\"columns\" : [ \"`sname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ],"}, "t0.fcolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.scolumns[0], t1.smy.field, t1.sreally.nested.field[0]", table, table, "t0.fname = t1.sname and t0.fcolumns[1]=10 and t1.scolumns[1]=100"));
        }
    }

    @Test
    public void testProjectPastFilterPastJoinPushDown() throws Exception {
        String pushDownSqlPattern = "select %s from cp.`%s` t0, cp.`%s` t1 where %s";
        String projection = "t0.fcolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.scolumns[0], t1.smy.field, t1.sreally.nested.field[0]";
        String filter = "t0.fname = t1.sname and t0.fcolumns[1] + t1.scolumns[1]=100";
        String firstExpected = "\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],";
        String secondExpected = "\"columns\" : [ \"`sname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ],";
        for (String table : this.TABLES) {
            this.testPushDown(new PushDownTestInstance("select %s from cp.`%s` t0, cp.`%s` t1 where %s", new String[]{"\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],", "\"columns\" : [ \"`sname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ],"}, "t0.fcolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.scolumns[0], t1.smy.field, t1.sreally.nested.field[0]", table, table, "t0.fname = t1.sname and t0.fcolumns[1] + t1.scolumns[1]=100"));
        }
    }

    @Test
    public void testProjectPastFilterPastJoinPushDownWhenItemsAreWithinNestedOperators() throws Exception {
        String pushDownSqlPattern = "select %s from cp.`%s` t0, cp.`%s` t1 where %s";
        String projection = "concat(t0.fcolumns[0], concat(t1.scolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.smy.field, t1.sreally.nested.field[0]))";
        String filter = "t0.fname = t1.sname and t0.fcolumns[1] + t1.scolumns[1]=100";
        String firstExpected = "\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],";
        String secondExpected = "\"columns\" : [ \"`sname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ],";
        for (String table : this.TABLES) {
            this.testPushDown(new PushDownTestInstance("select %s from cp.`%s` t0, cp.`%s` t1 where %s", new String[]{"\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],", "\"columns\" : [ \"`sname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ],"}, "concat(t0.fcolumns[0], concat(t1.scolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.smy.field, t1.sreally.nested.field[0]))", table, table, "t0.fname = t1.sname and t0.fcolumns[1] + t1.scolumns[1]=100"));
        }
    }

    @Test
    public void testProjectPastFilterPastJoinPastJoinPushDown() throws Exception {
        String pushDownSqlPattern = "select %s from cp.`%s` t0, cp.`%s` t1, cp.`%s` t2 where %s";
        String projection = "t0.fcolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.scolumns[0], t1.smy.field, t1.sreally.nested.field[0], t2.tcolumns[0], t2.tmy.field, t2.treally.nested.field[0]";
        String filter = "t0.fname = t1.sname and t1.slastname = t2.tlastname and t0.fcolumns[1] + t1.scolumns[1] + t2.tcolumns[1]=100";
        String firstExpected = "\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],";
        String secondExpected = "\"columns\" : [ \"`sname`\", \"`slastname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ],";
        String thirdExpected = "\"columns\" : [ \"`tlastname`\", \"`tcolumns`[0]\", \"`tmy`.`field`\", \"`treally`.`nested`.`field`[0]\", \"`tcolumns`[1]\" ],";
        for (String table : this.TABLES) {
            this.testPushDown(new PushDownTestInstance("select %s from cp.`%s` t0, cp.`%s` t1, cp.`%s` t2 where %s", new String[]{"\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],", "\"columns\" : [ \"`sname`\", \"`slastname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ],", "\"columns\" : [ \"`tlastname`\", \"`tcolumns`[0]\", \"`tmy`.`field`\", \"`treally`.`nested`.`field`[0]\", \"`tcolumns`[1]\" ],"}, "t0.fcolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.scolumns[0], t1.smy.field, t1.sreally.nested.field[0], t2.tcolumns[0], t2.tmy.field, t2.treally.nested.field[0]", table, table, table, "t0.fname = t1.sname and t1.slastname = t2.tlastname and t0.fcolumns[1] + t1.scolumns[1] + t2.tcolumns[1]=100"));
        }
    }

    @Test
    public void testProjectPastJoinPastFilterPastJoinPushDown() throws Exception {
        String pushDownSqlPattern = "select %s from cp.`%s` t0, cp.`%s` t1, cp.`%s` t2 where %s";
        String projection = "t0.fcolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.scolumns[0], t1.smy.field, t1.sreally.nested.field[0], t2.tcolumns[0], t2.tmy.field, t2.treally.nested.field[0]";
        String filter = "t0.fname = t1.sname and t1.slastname = t2.tlastname and t0.fcolumns[1] + t1.scolumns[1] = 100";
        String firstExpected = "\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],";
        String secondExpected = "\"columns\" : [ \"`sname`\", \"`slastname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ]";
        String thirdExpected = "\"columns\" : [ \"`tlastname`\", \"`tcolumns`[0]\", \"`tmy`.`field`\", \"`treally`.`nested`.`field`[0]\" ],";
        for (String table : this.TABLES) {
            this.testPushDown(new PushDownTestInstance("select %s from cp.`%s` t0, cp.`%s` t1, cp.`%s` t2 where %s", new String[]{"\"columns\" : [ \"`fname`\", \"`fcolumns`[0]\", \"`fmy`.`field`\", \"`freally`.`nested`.`field`[0]\", \"`fcolumns`[1]\" ],", "\"columns\" : [ \"`sname`\", \"`slastname`\", \"`scolumns`[0]\", \"`smy`.`field`\", \"`sreally`.`nested`.`field`[0]\", \"`scolumns`[1]\" ]", "\"columns\" : [ \"`tlastname`\", \"`tcolumns`[0]\", \"`tmy`.`field`\", \"`treally`.`nested`.`field`[0]\" ],"}, "t0.fcolumns[0], t0.fmy.field, t0.freally.nested.field[0], t1.scolumns[0], t1.smy.field, t1.sreally.nested.field[0], t2.tcolumns[0], t2.tmy.field, t2.treally.nested.field[0]", table, table, table, "t0.fname = t1.sname and t1.slastname = t2.tlastname and t0.fcolumns[1] + t1.scolumns[1] = 100"));
        }
    }

    @Test
    public void testSimpleProjectPastJoinPastFilterPastJoinPushDown() throws Exception {
        String firstExpected = "\"columns\" : [ \"`a`\", \"`fa`\", \"`fcolumns`[0]\" ],";
        String secondExpected = "\"columns\" : [ \"`a`\", \"`b`\", \"`c`\", \"`sa`\" ],";
        String thirdExpected = "\"columns\" : [ \"`d`\", \"`ta`\" ],";
        String sql = "select t0.fa, t1.sa, t2.ta  from cp.`%s` t0, cp.`%s` t1, cp.`%s` t2  where t0.a=t1.b and t1.c=t2.d and t0.fcolumns[0] + t1.a = 100";
        for (String table : this.TABLES) {
            this.testPushDown(new PushDownTestInstance(sql, new String[]{"\"columns\" : [ \"`a`\", \"`fa`\", \"`fcolumns`[0]\" ],", "\"columns\" : [ \"`a`\", \"`b`\", \"`c`\", \"`sa`\" ],", "\"columns\" : [ \"`d`\", \"`ta`\" ],"}, table, table, table));
        }
    }

    protected void testPushDown(PushDownTestInstance test) throws Exception {
        TestProjectPushDown.testPhysicalPlan(test.getSql(), test.getExpected());
    }

    private void testPhysicalPlanFromFile(String fileName, String ... expectedSubstrs) throws Exception {
        String[] queries;
        String query = TestProjectPushDown.getFile(fileName);
        for (String q : queries = query.split(";")) {
            if (q.trim().isEmpty()) continue;
            TestProjectPushDown.testPhysicalPlan(q, expectedSubstrs);
        }
    }

    protected static class PushDownTestInstance {
        private final String sqlPattern;
        private final String[] expected;
        private final Object[] params;

        public PushDownTestInstance(String sqlPattern, String expected, Object ... params) {
            this(sqlPattern, new String[]{expected}, params);
        }

        public PushDownTestInstance(String sqlPattern, String[] expected, Object ... params) {
            this.sqlPattern = sqlPattern;
            this.expected = expected;
            this.params = params;
        }

        public String[] getExpected() {
            return this.expected;
        }

        public String getSql() {
            return String.format(this.sqlPattern, this.params);
        }
    }
}

