/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.PlanTestBase;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.common.util.TestTools;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPartitionFilter
extends PlanTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestPartitionFilter.class);
    static final String WORKING_PATH = TestTools.getWorkingPath();
    static final String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";

    private static void testExcludeFilter(String query, int expectedNumFiles, String excludedFilterPattern, int expectedRowCount) throws Exception {
        int actualRowCount = TestPartitionFilter.testSql(query);
        Assert.assertEquals((long)expectedRowCount, (long)actualRowCount);
        String numFilesPattern = "numFiles=" + expectedNumFiles;
        TestPartitionFilter.testPlanMatchingPatterns(query, new String[]{numFilesPattern}, new String[]{excludedFilterPattern});
    }

    private static void testIncludeFilter(String query, int expectedNumFiles, String includedFilterPattern, int expectedRowCount) throws Exception {
        int actualRowCount = TestPartitionFilter.testSql(query);
        Assert.assertEquals((long)expectedRowCount, (long)actualRowCount);
        String numFilesPattern = "numFiles=" + expectedNumFiles;
        TestPartitionFilter.testPlanMatchingPatterns(query, new String[]{numFilesPattern, includedFilterPattern}, new String[0]);
    }

    @BeforeClass
    public static void createParquetTable() throws Exception {
        TestPartitionFilter.test("alter session set `planner.disable_exchanges` = true");
        TestPartitionFilter.test(String.format("create table dfs_test.tmp.parquet partition by (yr, qrtr) as select o_orderkey, o_custkey, o_orderstatus, o_totalprice, o_orderdate, o_orderpriority, o_clerk, o_shippriority, o_comment, cast(dir0 as int) yr, dir1 qrtr from dfs_test.`%s/multilevel/parquet`", TEST_RES_PATH));
        TestPartitionFilter.test("alter session set `planner.disable_exchanges` = false");
    }

    @Test
    public void testPartitionFilter1_Parquet() throws Exception {
        String query = String.format("select dir0, dir1, o_custkey, o_orderdate from dfs_test.`%s/multilevel/parquet` where dir0=1994 and dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 1, "Filter", 10);
    }

    @Test
    public void testPartitionFilter1_Parquet_from_CTAS() throws Exception {
        String query = String.format("select yr, qrtr, o_custkey, o_orderdate from dfs_test.tmp.parquet where yr=1994 and qrtr='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 1, "Filter", 10);
    }

    @Test
    public void testPartitionFilter1_Json() throws Exception {
        String query = String.format("select dir0, dir1, o_custkey, o_orderdate from dfs_test.`%s/multilevel/json` where dir0=1994 and dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 1, "Filter", 10);
    }

    @Test
    public void testPartitionFilter1_Csv() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/csv` where dir0=1994 and dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 1, "Filter", 10);
    }

    @Test
    public void testPartitionFilter2_Parquet() throws Exception {
        String query = String.format("select dir0, dir1, o_custkey, o_orderdate from dfs_test.`%s/multilevel/parquet` where o_custkey < 1000 and dir0=1994 and dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 1, "Filter", 5);
    }

    @Test
    public void testPartitionFilter2_Parquet_from_CTAS() throws Exception {
        String query = String.format("select yr, qrtr, o_custkey, o_orderdate from dfs_test.tmp.parquet where o_custkey < 1000 and yr=1994 and qrtr='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 1, "Filter", 5);
    }

    @Test
    public void testPartitionFilter2_Json() throws Exception {
        String query = String.format("select dir0, dir1, o_custkey, o_orderdate from dfs_test.`%s/multilevel/json` where o_custkey < 1000 and dir0=1994 and dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 1, "Filter", 5);
    }

    @Test
    public void testPartitionFilter2_Csv() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/csv` where columns[1] < 1000 and dir0=1994 and dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 1, "Filter", 5);
    }

    @Test
    public void testPartitionFilter3_Parquet() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/parquet` where (dir0=1994 and dir1='Q1' and o_custkey < 500) or (dir0=1995 and dir1='Q2' and o_custkey > 500)", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 2, "Filter", 8);
    }

    @Test
    public void testPartitionFilter3_Parquet_from_CTAS() throws Exception {
        String query = String.format("select * from dfs_test.tmp.parquet where (yr=1994 and qrtr='Q1' and o_custkey < 500) or (yr=1995 and qrtr='Q2' and o_custkey > 500)", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 2, "Filter", 8);
    }

    @Test
    public void testPartitionFilter3_Json() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/json` where (dir0=1994 and dir1='Q1' and o_custkey < 500) or (dir0=1995 and dir1='Q2' and o_custkey > 500)", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 2, "Filter", 8);
    }

    @Test
    public void testPartitionFilter3_Csv() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/csv` where (dir0=1994 and dir1='Q1' and columns[1] < 500) or (dir0=1995 and dir1='Q2' and columns[1] > 500)", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 2, "Filter", 8);
    }

    @Test
    public void testPartitionFilter4_Parquet() throws Exception {
        String query1 = String.format("select t1.dir0, t1.dir1, t1.o_custkey, t1.o_orderdate, cast(t2.c_name as varchar(10)) from dfs_test.`%s/multilevel/parquet` t1, cp.`tpch/customer.parquet` t2 where t1.o_custkey = t2.c_custkey and t1.dir0=1994 and t1.dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.test(query1);
    }

    @Test
    public void testPartitionFilter4_Parquet_from_CTAS() throws Exception {
        String query1 = String.format("select t1.dir0, t1.dir1, t1.o_custkey, t1.o_orderdate, cast(t2.c_name as varchar(10)) from dfs_test.tmp.parquet t1, cp.`tpch/customer.parquet` t2 where t1.o_custkey = t2.c_custkey and t1.yr=1994 and t1.qrtr='Q1'", TEST_RES_PATH);
        TestPartitionFilter.test(query1);
    }

    @Test
    public void testPartitionFilter4_Json() throws Exception {
        String query1 = String.format("select t1.dir0, t1.dir1, t1.o_custkey, t1.o_orderdate, cast(t2.c_name as varchar(10)) from dfs_test.`%s/multilevel/json` t1, cp.`tpch/customer.parquet` t2 where cast(t1.o_custkey as bigint) = cast(t2.c_custkey as bigint) and t1.dir0=1994 and t1.dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.test(query1);
    }

    @Test
    public void testPartitionFilter4_Csv() throws Exception {
        String query1 = String.format("select t1.dir0, t1.dir1, t1.columns[1] as o_custkey, t1.columns[4] as o_orderdate, cast(t2.c_name as varchar(10)) from dfs_test.`%s/multilevel/csv` t1, cp.`tpch/customer.parquet` t2 where cast(t1.columns[1] as bigint) = cast(t2.c_custkey as bigint) and t1.dir0=1994 and t1.dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.test(query1);
    }

    @Test
    public void testPartitionFilter5_Parquet() throws Exception {
        String query = String.format("select dir0, dir1, o_custkey, o_orderdate from dfs_test.`%s/multilevel/parquet` where dir0 in (1995, 1996)", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 8, "Filter", 80);
    }

    @Test
    public void testPartitionFilter5_Parquet_from_CTAS() throws Exception {
        String query = String.format("select yr, qrtr, o_custkey, o_orderdate from dfs_test.tmp.parquet where yr in (1995, 1996)", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 8, "Filter", 80);
    }

    @Test
    public void testPartitionFilter5_Json() throws Exception {
        String query = String.format("select dir0, dir1, o_custkey, o_orderdate from dfs_test.`%s/multilevel/json` where dir0 in (1995, 1996)", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 8, "Filter", 80);
    }

    @Test
    public void testPartitionFilter5_Csv() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/csv` where dir0 in (1995, 1996)", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 8, "Filter", 80);
    }

    @Test
    public void testPartitionFilter6_Parquet() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/parquet` where (dir0=1995 and o_totalprice < 40000) or dir0=1996", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 8, "Filter", 46);
    }

    @Test
    public void testPartitionFilter6_Parquet_from_CTAS() throws Exception {
        String query = String.format("select * from dfs_test.tmp.parquet where (yr=1995 and o_totalprice < 40000) or yr=1996", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 8, "Filter", 46);
    }

    @Test
    public void testPartitionFilter7_Parquet() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/parquet` where dir0=1995", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 4, "Filter", 40);
    }

    @Test
    public void testPartitionFilter7_Parquet_from_CTAS() throws Exception {
        String query = String.format("select * from dfs_test.tmp.parquet where yr=1995", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 4, "Filter", 40);
    }

    @Test
    public void testPartitionFilter8_Parquet() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/parquet` where dir1 in ('Q1','Q4')", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 6, "Filter", 60);
    }

    @Test
    public void testPartitionFilter8_Parquet_from_CTAS() throws Exception {
        String query = String.format("select * from dfs_test.tmp.parquet where qrtr in ('Q1','Q4')", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 6, "Filter", 60);
    }

    @Test
    public void testPartitionFilter9_Parquet() throws Exception {
        String query = String.format("select * from dfs_test.`%s/multilevel/parquet` where dir1 in ('Q1','Q4') and o_totalprice < 40000", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 6, "Filter", 9);
    }

    @Test
    public void testPartitionFilter9_Parquet_from_CTAS() throws Exception {
        String query = String.format("select * from dfs_test.tmp.parquet where qrtr in ('Q1','Q4') and o_totalprice < 40000", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 6, "Filter", 9);
    }

    @Test
    public void testPartitoinFilter10_Parquet() throws Exception {
        String query = String.format("select max(o_orderprice) from dfs_test.`%s/multilevel/parquet` where dir0=1994 and dir1='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 1, "Filter", 1);
    }

    @Test
    public void testPartitoinFilter10_Parquet_from_CTAS() throws Exception {
        String query = String.format("select max(o_orderprice) from dfs_test.tmp.parquet where yr=1994 and qrtr='Q1'", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 1, "Filter", 1);
    }

    @Test
    public void testMainQueryFalseCondition() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/parquet").toURI().toString();
        String query = String.format("select * from (select dir0, o_custkey from dfs_test.`%s` where dir0='1994') t where 1 = 0", root);
        TestPartitionFilter.testExcludeFilter(query, 4, "Filter", 0);
    }

    @Test
    public void testMainQueryTrueCondition() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/parquet").toURI().toString();
        String query = String.format("select * from (select dir0, o_custkey from dfs_test.`%s` where dir0='1994' ) t where 0 = 0", root);
        TestPartitionFilter.testExcludeFilter(query, 4, "Filter", 40);
    }

    @Test
    public void testMainQueryFilterRegularColumn() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/parquet").toURI().toString();
        String query = String.format("select * from (select dir0, o_custkey from dfs_test.`%s` where dir0='1994' and o_custkey = 10) t limit 0", root);
        TestPartitionFilter.testIncludeFilter(query, 4, "Filter", 0);
    }

    @Test
    public void testPartitionFilterWithCast() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/parquet").toURI().toString();
        String query = String.format("select myyear, myquarter, o_totalprice from (select cast(dir0 as varchar(10)) as myyear,  cast(dir1 as varchar(10)) as myquarter, o_totalprice from dfs_test.`%s`) where myyear = cast('1995' as varchar(10))  and myquarter = cast('Q2' as varchar(10)) and o_totalprice < 40000.0 order by o_totalprice", root);
        TestPartitionFilter.testIncludeFilter(query, 1, "Filter", 3);
    }

    @Test
    public void testPPWithNestedExpression() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/parquet").toURI().toString();
        String query = String.format("select * from dfs_test.`%s` where dir0 not in(1994) and o_orderpriority = '2-HIGH'", root);
        TestPartitionFilter.testIncludeFilter(query, 8, "Filter", 24);
    }

    @Test
    public void testPPWithCase() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/multilevel/parquet").toURI().toString();
        String query = String.format("select 1 from (select  CASE WHEN '07' = '13' THEN '13' ELSE CAST(dir0 as VARCHAR(4)) END as YEAR_FILTER from dfs_test.`%s` where o_orderpriority = '2-HIGH') subq where subq.YEAR_FILTER not in('1994')", root);
        TestPartitionFilter.testIncludeFilter(query, 8, "Filter", 24);
    }

    @Test
    public void testPartitionFilterWithNonNullabeFilterExpr() throws Exception {
        String query = String.format("select dir0, dir1, o_custkey, o_orderdate from dfs_test.`%s/multilevel/parquet` where concat(dir0, '') = '1994' and concat(dir1, '') = 'Q1'", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 1, "Filter", 10);
    }

    @Test
    public void testPartitionFilterAfterPushFilterPastAgg() throws Exception {
        String query = String.format("select dir0, dir1, cnt from (select dir0, dir1, count(*) cnt from dfs_test.`%s/multilevel/parquet` group by dir0, dir1) where dir0 = '1994' and dir1 = 'Q1'", TEST_RES_PATH);
        TestPartitionFilter.testExcludeFilter(query, 1, "Filter", 1);
    }

    @Test
    public void testPartitionWithCoalesceFilter_1() throws Exception {
        String query = String.format("select 1 from dfs_test.`%s/multilevel/parquet` where dir0=1994 and dir1='Q1' and coalesce(o_custkey, 0) = 890", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 1, "Filter", 1);
    }

    @Test
    public void testPartitionWithCoalesceFilter_2() throws Exception {
        String query = String.format("select 1 from dfs_test.`%s/multilevel/parquet` where dir0=1994 and o_custkey = 890 and coalesce(dir1, 'NA') = 'Q1'", TEST_RES_PATH);
        TestPartitionFilter.testIncludeFilter(query, 1, "Filter", 1);
    }
}

