/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.testing.ControlsInjectionUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestOutOfMemoryOutcome
extends BaseTestQuery {
    private static final String SINGLE_MODE = "ALTER SESSION SET `planner.disable_exchanges` = true";

    private void testSingleMode(String fileName) throws Exception {
        TestOutOfMemoryOutcome.test(SINGLE_MODE);
        CoordinationProtos.DrillbitEndpoint endpoint = bits[0].getContext().getEndpoint();
        String controlsString = "{\"injections\":[{\"address\":\"" + endpoint.getAddress() + "\"," + "\"port\":\"" + endpoint.getUserPort() + "\"," + "\"type\":\"exception\"," + "\"siteClass\":\"" + "org.apache.drill.exec.physical.impl.ScanBatch" + "\"," + "\"desc\":\"" + "next-allocate" + "\"," + "\"nSkip\":0," + "\"nFire\":1," + "\"exceptionClass\":\"" + "org.apache.drill.exec.memory.OutOfMemoryException" + "\"" + "}]}";
        ControlsInjectionUtil.setControls(client, controlsString);
        String query = TestOutOfMemoryOutcome.getFile(fileName);
        try {
            TestOutOfMemoryOutcome.test(query);
        }
        catch (UserException uex) {
            UserBitShared.DrillPBError error = uex.getOrCreatePBError(false);
            Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.RESOURCE, (Object)error.getErrorType());
            Assert.assertTrue((String)"Error message isn't related to memory error", (boolean)uex.getMessage().contains("One or more nodes ran out of memory while executing the query."));
        }
    }

    @Test
    public void tpch01() throws Exception {
        this.testSingleMode("queries/tpch/01.sql");
    }

    @Test
    public void tpch03() throws Exception {
        this.testSingleMode("queries/tpch/03.sql");
    }

    @Test
    public void tpch04() throws Exception {
        this.testSingleMode("queries/tpch/04.sql");
    }

    @Test
    public void tpch05() throws Exception {
        this.testSingleMode("queries/tpch/05.sql");
    }

    @Test
    public void tpch06() throws Exception {
        this.testSingleMode("queries/tpch/06.sql");
    }

    @Test
    public void tpch07() throws Exception {
        this.testSingleMode("queries/tpch/07.sql");
    }

    @Test
    public void tpch08() throws Exception {
        this.testSingleMode("queries/tpch/08.sql");
    }

    @Test
    public void tpch09() throws Exception {
        this.testSingleMode("queries/tpch/09.sql");
    }

    @Test
    public void tpch10() throws Exception {
        this.testSingleMode("queries/tpch/10.sql");
    }

    @Test
    public void tpch12() throws Exception {
        this.testSingleMode("queries/tpch/12.sql");
    }

    @Test
    public void tpch13() throws Exception {
        this.testSingleMode("queries/tpch/13.sql");
    }

    @Test
    public void tpch14() throws Exception {
        this.testSingleMode("queries/tpch/14.sql");
    }

    @Test
    public void tpch18() throws Exception {
        this.testSingleMode("queries/tpch/18.sql");
    }

    @Test
    public void tpch20() throws Exception {
        this.testSingleMode("queries/tpch/20.sql");
    }
}

