/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.util.TestTools;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestJoinNullable
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestJoinNullable.class);
    static final String WORKING_PATH = TestTools.getWorkingPath();
    static final String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";

    private static void enableJoin(boolean hj, boolean mj) throws Exception {
        TestJoinNullable.test(String.format("alter session set `planner.enable_hashjoin` = %s", hj ? "true" : "false"));
        TestJoinNullable.test(String.format("alter session set `planner.enable_mergejoin` = %s", mj ? "true" : "false"));
        TestJoinNullable.test("alter session set `planner.slice_target` = 1");
    }

    @Test
    public void testHashInnerJoinOnNullableColumns() throws Exception {
        String query = String.format("select t1.a1, t1.b1, t2.a2, t2.b2 from dfs_test.`%s/jsoninput/nullable1.json` t1,  dfs_test.`%s/jsoninput/nullable2.json` t2 where t1.b1 = t2.b2", TEST_RES_PATH, TEST_RES_PATH);
        boolean expectedRecordCount = true;
        TestJoinNullable.enableJoin(true, false);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)1L, (long)actualRecordCount);
    }

    @Test
    public void testHashLOJOnNullableColumns() throws Exception {
        String query = String.format("select t1.a1, t1.b1, t2.a2, t2.b2 from dfs_test.`%s/jsoninput/nullable1.json` t1  left outer join dfs_test.`%s/jsoninput/nullable2.json` t2  on t1.b1 = t2.b2", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 2;
        TestJoinNullable.enableJoin(true, false);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)2L, (long)actualRecordCount);
    }

    @Test
    public void testHashROJOnNullableColumns() throws Exception {
        String query = String.format("select t1.a1, t1.b1, t2.a2, t2.b2 from dfs_test.`%s/jsoninput/nullable1.json` t1  right outer join dfs_test.`%s/jsoninput/nullable2.json` t2  on t1.b1 = t2.b2", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 4;
        TestJoinNullable.enableJoin(true, false);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)4L, (long)actualRecordCount);
    }

    @Test
    public void testHashFOJOnNullableColumns() throws Exception {
        String query = String.format("select t1.a1, t1.b1, t2.a2, t2.b2 from dfs_test.`%s/jsoninput/nullable1.json` t1  full outer join dfs_test.`%s/jsoninput/nullable2.json` t2  on t1.b1 = t2.b2", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 5;
        TestJoinNullable.enableJoin(true, false);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)5L, (long)actualRecordCount);
    }

    @Test
    public void testMergeInnerJoinOnNullableColumns() throws Exception {
        String query = String.format("select t1.a1, t1.b1, t2.a2, t2.b2   from dfs_test.`%s/jsoninput/nullable1.json` t1,        dfs_test.`%s/jsoninput/nullable2.json` t2  where t1.b1 = t2.b2", TEST_RES_PATH, TEST_RES_PATH);
        boolean expectedRecordCount = true;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)1L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullable() throws Exception {
        String query = String.format("select t1.a1, t1.b1, t2.a2, t2.b2 from dfs_test.`%s/jsoninput/nullable1.json` t1  left outer join dfs_test.`%s/jsoninput/nullable2.json` t2  on t1.b1 = t2.b2", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 2;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)2L, (long)actualRecordCount);
    }

    @Test
    public void testMergeROJOnNullableColumns() throws Exception {
        String query = String.format("select t1.a1, t1.b1, t2.a2, t2.b2 from dfs_test.`%s/jsoninput/nullable1.json` t1  right outer join dfs_test.`%s/jsoninput/nullable2.json` t2  on t1.b1 = t2.b2", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 4;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)4L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableNoOrderedInputs() throws Exception {
        String query = String.format("SELECT * FROM               dfs_test.`%s/jsoninput/nullableOrdered1.json` t1    left outer join dfs_test.`%s/jsoninput/nullableOrdered2.json` t2       using ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableOneOrderedInputAscNullsFirst() throws Exception {
        String query = String.format("SELECT * from         dfs_test.`%s/jsoninput/nullableOrdered1.json` t1   LEFT OUTER JOIN     ( SELECT key, data         FROM dfs_test.`%s/jsoninput/nullableOrdered2.json` t2         ORDER BY 1 ASC NULLS FIRST ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableOneOrderedInputAscNullsLast() throws Exception {
        String query = String.format("SELECT * FROM         dfs_test.`%s/jsoninput/nullableOrdered1.json` t1   LEFT OUTER JOIN     ( SELECT key, data         FROM dfs_test.`%s/jsoninput/nullableOrdered2.json` t2         ORDER BY 1 ASC NULLS LAST ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableOneOrderedInputDescNullsFirst() throws Exception {
        String query = String.format("SELECT * FROM         dfs_test.`%s/jsoninput/nullableOrdered1.json` t1   LEFT OUTER JOIN     ( SELECT key, data         FROM dfs_test.`%s/jsoninput/nullableOrdered2.json` t2         ORDER BY 1 DESC NULLS FIRST ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableOneOrderedInputDescNullsLast() throws Exception {
        String query = String.format("SELECT * FROM         dfs_test.`%s/jsoninput/nullableOrdered1.json` t1   LEFT OUTER JOIN     ( SELECT key, data         FROM dfs_test.`%s/jsoninput/nullableOrdered2.json` t2         ORDER BY 1 DESC NULLS LAST ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableBothInputsOrderedAscNullsFirstVsAscNullsFirst() throws Exception {
        String query = String.format("SELECT * from ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered1.json`          ORDER BY 1 ASC NULLS FIRST ) t1   LEFT OUTER JOIN      ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered2.json`          ORDER BY 1 ASC NULLS FIRST ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableBothInputsOrderedAscNullsLastVsAscNullsFirst() throws Exception {
        String query = String.format("SELECT * from ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered1.json`          ORDER BY 1 ASC NULLS LAST  ) t1   LEFT OUTER JOIN      ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered2.json`          ORDER BY 1 ASC NULLS FIRST ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableBothInputsOrderedAscNullsFirstVsAscNullsLast() throws Exception {
        String query = String.format("SELECT * from ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered1.json`          ORDER BY 1 ASC NULLS FIRST ) t1   LEFT OUTER JOIN      ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered2.json`          ORDER BY 1 ASC NULLS LAST  ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableBothInputsOrderedAscNullsLastVsAscNullsLast() throws Exception {
        String query = String.format("SELECT * from ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered1.json`          ORDER BY 1 ASC NULLS LAST  ) t1   LEFT OUTER JOIN      ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered2.json`          ORDER BY 1 ASC NULLS LAST  ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableBothInputsOrderedDescNullsFirstVsAscNullsFirst() throws Exception {
        String query = String.format("SELECT * from ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered1.json`          ORDER BY 1 DESC NULLS FIRST ) t1   LEFT OUTER JOIN      ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered2.json`          ORDER BY 1 ASC NULLS FIRST ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableBothInputsOrderedDescNullsLastVsAscNullsFirst() throws Exception {
        String query = String.format("SELECT * from ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered1.json`          ORDER BY 1 DESC NULLS LAST  ) t1   LEFT OUTER JOIN      ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered2.json`          ORDER BY 1 ASC NULLS FIRST ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableBothInputsOrderedDescNullsFirstVsAscNullsLast() throws Exception {
        String query = String.format("SELECT * from ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered1.json`          ORDER BY 1 DESC NULLS FIRST ) t1   LEFT OUTER JOIN      ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered2.json`          ORDER BY 1 ASC NULLS LAST  ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }

    @Test
    public void testMergeLOJNullableBothInputsOrderedDescNullsLastVsAscNullsLast() throws Exception {
        String query = String.format("SELECT * from ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered1.json`          ORDER BY 1 DESC NULLS LAST  ) t1   LEFT OUTER JOIN      ( SELECT key, data          FROM dfs_test.`%s/jsoninput/nullableOrdered2.json`          ORDER BY 1 ASC NULLS LAST  ) t2     USING ( key )", TEST_RES_PATH, TEST_RES_PATH);
        int expectedRecordCount = 6;
        TestJoinNullable.enableJoin(false, true);
        int actualRecordCount = TestJoinNullable.testSql(query);
        Assert.assertEquals((String)"Number of output rows", (long)6L, (long)actualRecordCount);
    }
}

