/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestBuilder;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestFrameworkTest
extends BaseTestQuery {
    private static String CSV_COLS = " cast(columns[0] as bigint) employee_id, columns[1] as first_name, columns[2] as last_name ";

    @Test
    public void testCSVVerification() throws Exception {
        TestFrameworkTest.testBuilder().sqlQuery("select employee_id, first_name, last_name from cp.`testframework/small_test_data.json`").ordered().csvBaselineFile("testframework/small_test_data.tsv").baselineTypes(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("employee_id", "first_name", "last_name").build().run();
    }

    @Test
    public void testBaselineValsVerification() throws Exception {
        TestFrameworkTest.testBuilder().sqlQuery("select employee_id, first_name, last_name from cp.`testframework/small_test_data.json` limit 1").ordered().baselineColumns("employee_id", "first_name", "last_name").baselineValues(12L, "Jewel", "Creek").build().run();
        TestFrameworkTest.testBuilder().sqlQuery("select employee_id, first_name, last_name from cp.`testframework/small_test_data.json` limit 1").unOrdered().baselineColumns("employee_id", "first_name", "last_name").baselineValues(12L, "Jewel", "Creek").build().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecimalBaseline() throws Exception {
        try {
            TestFrameworkTest.test(String.format("alter session set `%s` = true", "planner.enable_decimal_data_type"));
            TestFrameworkTest.testBuilder().sqlQuery("select cast(dec_col as decimal(38,2)) dec_col from cp.`testframework/decimal_test.json`").unOrdered().csvBaselineFile("testframework/decimal_test.tsv").baselineTypes(Types.withScaleAndPrecision((TypeProtos.MinorType)TypeProtos.MinorType.DECIMAL38SPARSE, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED, (int)2, (int)38)).baselineColumns("dec_col").build().run();
            TestFrameworkTest.testBuilder().sqlQuery("select cast(dec_col as decimal(38,2)) dec_col from cp.`testframework/decimal_test.json`").unOrdered().csvBaselineFile("testframework/decimal_test.tsv").baselineColumns("dec_col").build().run();
            TestFrameworkTest.testBuilder().sqlQuery("select cast(dec_col as decimal(38,2)) dec_col from cp.`testframework/decimal_test.json`").unOrdered().baselineColumns("dec_col").baselineValues(new BigDecimal("3.70")).build().run();
        }
        catch (Throwable throwable) {
            TestFrameworkTest.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
            throw throwable;
        }
        TestFrameworkTest.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
    }

    @Test
    public void testMapOrdering() throws Exception {
        TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`/testframework/map_reordering.json`").unOrdered().jsonBaselineFile("testframework/map_reordering2.json").build().run();
    }

    @Test
    public void testBaselineValsVerificationWithNulls() throws Exception {
        TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`store/json/json_simple_with_null.json`").ordered().baselineColumns("a", "b").baselineValues(5L, 10L).baselineValues(7L, null).baselineValues(null, null).baselineValues(9L, 11L).build().run();
        TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`store/json/json_simple_with_null.json`").unOrdered().baselineColumns("a", "b").baselineValues(5L, 10L).baselineValues(9L, 11L).baselineValues(7L, null).baselineValues(null, null).build().run();
    }

    @Test
    public void testBaselineValsVerificationWithComplexAndNulls() throws Exception {
        TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`/jsoninput/input2.json` limit 1").ordered().baselineColumns("integer", "float", "x", "z", "l", "rl").baselineValues(2010L, 17.4, TestBuilder.mapOf("y", "kevin", "z", "paul"), TestBuilder.listOf(TestBuilder.mapOf("orange", "yellow", "pink", "red"), TestBuilder.mapOf("pink", "purple")), TestBuilder.listOf(4L, 2L), TestBuilder.listOf(TestBuilder.listOf(2L, 1L), TestBuilder.listOf(4L, 6L))).build().run();
    }

    @Test
    public void testCSVVerification_missing_records_fails() throws Exception {
        try {
            TestFrameworkTest.testBuilder().sqlQuery("select employee_id, first_name, last_name from cp.`testframework/small_test_data.json`").ordered().csvBaselineFile("testframework/small_test_data_extra.tsv").baselineTypes(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("employee_id", "first_name", "last_name").build().run();
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Incorrect number of rows returned by query. expected:<7> but was:<5>", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        throw new Exception("Test framework verification failed, expected failure on missing records.");
    }

    @Test
    public void testCSVVerification_extra_records_fails() throws Exception {
        try {
            TestFrameworkTest.testBuilder().sqlQuery("select " + CSV_COLS + " from cp.`testframework/small_test_data_extra.tsv`").ordered().csvBaselineFile("testframework/small_test_data.tsv").baselineTypes(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("employee_id", "first_name", "last_name").build().run();
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Incorrect number of rows returned by query. expected:<5> but was:<7>", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        throw new Exception("Test framework verification failed, expected failure for extra records.");
    }

    @Test
    public void testCSVVerification_extra_column_fails() throws Exception {
        try {
            TestFrameworkTest.testBuilder().sqlQuery("select " + CSV_COLS + ", columns[3] as address from cp.`testframework/small_test_data_extra_col.tsv`").ordered().csvBaselineFile("testframework/small_test_data.tsv").baselineTypes(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("employee_id", "first_name", "last_name").build().run();
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Unexpected extra column `address` returned by query.", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        throw new Exception("Test framework verification failed, expected failure on extra column.");
    }

    @Test
    public void testCSVVerification_missing_column_fails() throws Exception {
        try {
            TestFrameworkTest.testBuilder().sqlQuery("select employee_id, first_name, last_name from cp.`testframework/small_test_data.json`").ordered().csvBaselineFile("testframework/small_test_data_extra_col.tsv").baselineTypes(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("employee_id", "first_name", "last_name", "address").build().run();
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"Expected column(s) `address`,  not found in result set.", (Object)ex.getMessage());
            return;
        }
        throw new Exception("Test framework verification failed, expected failure on missing column.");
    }

    @Test
    public void testCSVVerificationOfTypes() throws Throwable {
        try {
            TestFrameworkTest.testBuilder().sqlQuery("select employee_id, first_name, last_name from cp.`testframework/small_test_data.json`").ordered().csvBaselineFile("testframework/small_test_data.tsv").baselineTypes(TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("employee_id", "first_name", "last_name").build().run();
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"at position 0 column '`employee_id`' mismatched values, expected: 12(Integer) but received 12(Long)", (Object)ex.getMessage());
            return;
        }
        throw new Exception("Test framework verification failed, expected failure on type check.");
    }

    @Test
    public void testCSVVerificationOfOrder_checkFailure() throws Throwable {
        try {
            TestFrameworkTest.testBuilder().sqlQuery("select columns[0] as employee_id, columns[1] as first_name, columns[2] as last_name from cp.`testframework/small_test_data_reordered.tsv`").ordered().csvBaselineFile("testframework/small_test_data.tsv").baselineColumns("employee_id", "first_name", "last_name").build().run();
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"at position 0 column '`first_name`' mismatched values, expected: Jewel(String) but received Peggy(String)", (Object)ex.getMessage());
            return;
        }
        throw new Exception("Test framework verification failed, expected failure on order check.");
    }

    @Test
    public void testCSVVerificationOfUnorderedComparison() throws Throwable {
        TestFrameworkTest.testBuilder().sqlQuery("select columns[0] as employee_id, columns[1] as first_name, columns[2] as last_name from cp.`testframework/small_test_data_reordered.tsv`").unOrdered().csvBaselineFile("testframework/small_test_data.tsv").baselineColumns("employee_id", "first_name", "last_name").build().run();
    }

    @Test
    public void testBasicJSON() throws Exception {
        TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`scan_json_test_3.json`").ordered().jsonBaselineFile("/scan_json_test_3.json").build().run();
        TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`scan_json_test_3.json`").unOrdered().jsonBaselineFile("/scan_json_test_3.json").build().run();
    }

    @Test
    public void testComplexJSON_all_text() throws Exception {
        TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`store/json/schema_change_int_to_string.json`").optionSettingQueriesForTestQuery("alter system set `store.json.all_text_mode` = true").ordered().jsonBaselineFile("store/json/schema_change_int_to_string.json").optionSettingQueriesForBaseline("alter system set `store.json.all_text_mode` = true").build().run();
        TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`store/json/schema_change_int_to_string.json`").optionSettingQueriesForTestQuery("alter system set `store.json.all_text_mode` = true").unOrdered().jsonBaselineFile("store/json/schema_change_int_to_string.json").optionSettingQueriesForBaseline("alter system set `store.json.all_text_mode` = true").build().run();
        TestFrameworkTest.test("alter system set `store.json.all_text_mode` = false");
    }

    @Test
    public void testRepeatedColumnMatching() throws Exception {
        try {
            TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`store/json/schema_change_int_to_string.json`").optionSettingQueriesForTestQuery("alter system set `store.json.all_text_mode` = true").ordered().jsonBaselineFile("testframework/schema_change_int_to_string_non-matching.json").optionSettingQueriesForBaseline("alter system set `store.json.all_text_mode` = true").build().run();
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"at position 1 column '`field_1`' mismatched values, expected: [\"5\",\"2\",\"3\",\"4\",\"1\",\"2\"](JsonStringArrayList) but received [\"5\"](JsonStringArrayList)", (Object)ex.getMessage());
            return;
        }
        throw new Exception("Test framework verification failed, expected failure on order check.");
    }

    @Test
    public void testEmptyResultSet() throws Exception {
        TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`store/json/json_simple_with_null.json` where 1=0").expectsEmptyResultSet().build().run();
        try {
            TestFrameworkTest.testBuilder().sqlQuery("select * from cp.`store/json/json_simple_with_null.json`").expectsEmptyResultSet().build().run();
        }
        catch (AssertionError ex) {
            Assert.assertEquals((Object)"Different number of records returned expected:<0> but was:<4>", (Object)((Throwable)((Object)ex)).getMessage());
            return;
        }
        throw new Exception("Test framework verification failed, expected failure on unexpected records.");
    }

    @Test
    public void testCSVVerificationTypeMap() throws Throwable {
        HashMap<SchemaPath, TypeProtos.MajorType> typeMap = new HashMap<SchemaPath, TypeProtos.MajorType>();
        typeMap.put(TestBuilder.parsePath("first_name"), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        typeMap.put(TestBuilder.parsePath("employee_id"), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INT));
        typeMap.put(TestBuilder.parsePath("last_name"), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        TestFrameworkTest.testBuilder().sqlQuery("select cast(columns[0] as int) employee_id, columns[1] as first_name, columns[2] as last_name from cp.`testframework/small_test_data_reordered.tsv`").unOrdered().csvBaselineFile("testframework/small_test_data.tsv").baselineColumns("employee_id", "first_name", "last_name").build().run();
        typeMap.clear();
        typeMap.put(TestBuilder.parsePath("first_name"), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        typeMap.put(TestBuilder.parsePath("employee_id"), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        typeMap.put(TestBuilder.parsePath("last_name"), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        try {
            TestFrameworkTest.testBuilder().sqlQuery("select cast(columns[0] as int) employee_id, columns[1] as first_name, columns[2] as last_name from cp.`testframework/small_test_data_reordered.tsv`").unOrdered().csvBaselineFile("testframework/small_test_data.tsv").baselineColumns("employee_id", "first_name", "last_name").baselineTypes(typeMap).build().run();
        }
        catch (Exception ex) {
            return;
        }
        throw new Exception("Test framework verification failed, expected failure on type check.");
    }
}

