/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import java.math.BigDecimal;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestBuilder;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.common.util.TestTools;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestExampleQueries
extends BaseTestQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatOnNull() throws Exception {
        try {
            TestExampleQueries.test("use dfs_test.tmp");
            TestExampleQueries.test("create view concatNull as (select * from cp.`customer.json` where customer_id < 5);");
            TestExampleQueries.testBuilder().sqlQuery("select (mi || lname) as CONCATOperator, mi, lname, concat(mi, lname) as CONCAT from concatNull").ordered().baselineColumns("CONCATOperator", "mi", "lname", "CONCAT").baselineValues("A.Nowmer", "A.", "Nowmer", "A.Nowmer").baselineValues("I.Whelply", "I.", "Whelply", "I.Whelply").baselineValues(null, null, "Derry", "Derry").baselineValues("J.Spence", "J.", "Spence", "J.Spence").build().run();
            TestExampleQueries.testBuilder().sqlQuery("select (lname || mi) as CONCATOperator, lname, mi, concat(lname, mi) as CONCAT from concatNull").ordered().baselineColumns("CONCATOperator", "lname", "mi", "CONCAT").baselineValues("NowmerA.", "Nowmer", "A.", "NowmerA.").baselineValues("WhelplyI.", "Whelply", "I.", "WhelplyI.").baselineValues(null, "Derry", null, "Derry").baselineValues("SpenceJ.", "Spence", "J.", "SpenceJ.").build().run();
            TestExampleQueries.testBuilder().sqlQuery("select (mi || mi) as CONCATOperator, mi, mi, concat(mi, mi) as CONCAT from concatNull").ordered().baselineColumns("CONCATOperator", "mi", "mi0", "CONCAT").baselineValues("A.A.", "A.", "A.", "A.A.").baselineValues("I.I.", "I.", "I.", "I.I.").baselineValues(null, null, null, "").baselineValues("J.J.", "J.", "J.", "J.J.").build().run();
            TestExampleQueries.testBuilder().sqlQuery("select (cast(null as varchar(10)) || lname) as CONCATOperator, cast(null as varchar(10)) as NullColumn, lname, concat(cast(null as varchar(10)), lname) as CONCAT from concatNull").ordered().baselineColumns("CONCATOperator", "NullColumn", "lname", "CONCAT").baselineValues(null, null, "Nowmer", "Nowmer").baselineValues(null, null, "Whelply", "Whelply").baselineValues(null, null, "Derry", "Derry").baselineValues(null, null, "Spence", "Spence").build().run();
        }
        finally {
            TestExampleQueries.test("drop view concatNull;");
        }
    }

    @Test
    public void testConcatOperator() throws Exception {
        TestExampleQueries.testBuilder().sqlQuery("select n_nationkey || '+' || n_name || '=' as CONCAT, n_nationkey, '+' as PLUS, n_name from cp.`tpch/nation.parquet`").ordered().csvBaselineFile("testframework/testExampleQueries/testConcatOperator.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARCHAR).baselineColumns("CONCAT", "n_nationkey", "PLUS", "n_name").build().run();
        TestExampleQueries.testBuilder().sqlQuery("select (n_nationkey || n_name) as CONCAT from cp.`tpch/nation.parquet`").ordered().csvBaselineFile("testframework/testExampleQueries/testConcatOperatorInputTypeCombination.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR).baselineColumns("CONCAT").build().run();
        TestExampleQueries.testBuilder().sqlQuery("select (n_nationkey || cast(n_name as varchar(30))) as CONCAT from cp.`tpch/nation.parquet`").ordered().csvBaselineFile("testframework/testExampleQueries/testConcatOperatorInputTypeCombination.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR).baselineColumns("CONCAT").build().run();
        TestExampleQueries.testBuilder().sqlQuery("select (cast(n_nationkey as varchar(30)) || n_name) as CONCAT from cp.`tpch/nation.parquet`").ordered().csvBaselineFile("testframework/testExampleQueries/testConcatOperatorInputTypeCombination.tsv").baselineTypes(TypeProtos.MinorType.VARCHAR).baselineColumns("CONCAT").build().run();
    }

    @Test
    public void testViewFileName() throws Exception {
        TestExampleQueries.test("use dfs_test.tmp");
        TestExampleQueries.test("create view nation_view_testexamplequeries as select * from cp.`tpch/nation.parquet`;");
        TestExampleQueries.test("select * from dfs_test.tmp.`nation_view_testexamplequeries.view.drill`");
        TestExampleQueries.test("drop view nation_view_testexamplequeries");
    }

    @Test
    public void testTextInClasspathStorage() throws Exception {
        TestExampleQueries.test("select * from cp.`/store/text/classpath_storage_csv_test.csv`");
    }

    @Test
    public void testParquetComplex() throws Exception {
        TestExampleQueries.test("select recipe from cp.`parquet/complex.parquet`");
        TestExampleQueries.test("select * from cp.`parquet/complex.parquet`");
        TestExampleQueries.test("select recipe, c.inventor.name as name, c.inventor.age as age from cp.`parquet/complex.parquet` c");
    }

    @Test
    public void testQueryWithNullValues() throws Exception {
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
        TestExampleQueries.test("select count(*) from cp.`customer.json` limit 1");
    }

    @Test
    public void testJoinMerge() throws Exception {
        TestExampleQueries.test("alter session set `planner.enable_hashjoin` = false");
        TestExampleQueries.test("select count(*) \n  from (select l.l_orderkey as x, c.c_custkey as y \n  from cp.`tpch/lineitem.parquet` l \n    left outer join cp.`tpch/customer.parquet` c \n      on l.l_orderkey = c.c_custkey) as foo\n  where x < 10000\n");
        TestExampleQueries.test("alter session set `planner.enable_hashjoin` = true");
    }

    @Test
    public void testJoinExpOn() throws Exception {
        TestExampleQueries.test("select a.n_nationkey from cp.`tpch/nation.parquet` a join cp.`tpch/region.parquet` b on a.n_regionkey + 1 = b.r_regionkey and a.n_regionkey + 1 = b.r_regionkey;");
    }

    @Test
    public void testJoinExpWhere() throws Exception {
        TestExampleQueries.test("select a.n_nationkey from cp.`tpch/nation.parquet` a , cp.`tpch/region.parquet` b where a.n_regionkey + 1 = b.r_regionkey and a.n_regionkey + 1 = b.r_regionkey;");
    }

    @Test
    public void testPushExpInJoinConditionInnerJoin() throws Exception {
        TestExampleQueries.test("select a.n_nationkey from cp.`tpch/nation.parquet` a join cp.`tpch/region.parquet` b  on a.n_regionkey + 100  = b.r_regionkey + 200   and (substr(a.n_name,1,3)= 'L1' or substr(a.n_name,2,2) = 'L2')    and (substr(b.r_name,1,3)= 'R1' or substr(b.r_name,2,2) = 'R2')    and (substr(a.n_name,2,3)= 'L3' or substr(b.r_name,3,2) = 'R3');");
    }

    @Test
    public void testPushExpInJoinConditionWhere() throws Exception {
        TestExampleQueries.test("select a.n_nationkey from cp.`tpch/nation.parquet` a , cp.`tpch/region.parquet` b  where a.n_regionkey + 100  = b.r_regionkey + 200   and (substr(a.n_name,1,3)= 'L1' or substr(a.n_name,2,2) = 'L2')    and (substr(b.r_name,1,3)= 'R1' or substr(b.r_name,2,2) = 'R2')    and (substr(a.n_name,2,3)= 'L3' or substr(b.r_name,3,2) = 'R3');");
    }

    @Test
    public void testPushExpInJoinConditionLeftJoin() throws Exception {
        TestExampleQueries.test("select a.n_nationkey, b.r_regionkey from cp.`tpch/nation.parquet` a left join cp.`tpch/region.parquet` b  on a.n_regionkey +100 = b.r_regionkey +200    and (substr(b.r_name,1,3)= 'R1' or substr(b.r_name,2,2) = 'R2') ");
    }

    @Test
    public void testPushExpInJoinConditionRightJoin() throws Exception {
        TestExampleQueries.test("select a.n_nationkey, b.r_regionkey from cp.`tpch/nation.parquet` a right join cp.`tpch/region.parquet` b  on a.n_regionkey +100 = b.r_regionkey +200    and (substr(a.n_name,1,3)= 'L1' or substr(a.n_name,2,2) = 'L2') ");
    }

    @Test
    public void testCaseReturnValueVarChar() throws Exception {
        TestExampleQueries.test("select case when employee_id < 1000 then 'ABC' else 'DEF' end from cp.`employee.json` limit 5");
    }

    @Test
    public void testCaseReturnValueBigInt() throws Exception {
        TestExampleQueries.test("select case when employee_id < 1000 then 1000 else 2000 end from cp.`employee.json` limit 5");
    }

    @Test
    public void testHashPartitionSV2() throws Exception {
        TestExampleQueries.test("select count(n_nationkey) from cp.`tpch/nation.parquet` where n_nationkey > 8 group by n_regionkey");
    }

    @Test
    public void testHashPartitionSV4() throws Exception {
        TestExampleQueries.test("select count(n_nationkey) as cnt from cp.`tpch/nation.parquet` group by n_regionkey order by cnt");
    }

    @Test
    public void testSelectWithLimit() throws Exception {
        TestExampleQueries.test("select employee_id,  first_name, last_name from cp.`employee.json` limit 5 ");
    }

    @Test
    public void testSelectWithLimit2() throws Exception {
        TestExampleQueries.test("select l_comment, l_orderkey from cp.`tpch/lineitem.parquet` limit 10000 ");
    }

    @Test
    public void testSVRV4() throws Exception {
        TestExampleQueries.test("select employee_id,  first_name from cp.`employee.json` order by employee_id ");
    }

    @Test
    public void testSVRV4MultBatch() throws Exception {
        TestExampleQueries.test("select l_orderkey from cp.`tpch/lineitem.parquet` order by l_orderkey limit 10000 ");
    }

    @Test
    public void testSVRV4Join() throws Exception {
        TestExampleQueries.test("select count(*) from cp.`tpch/lineitem.parquet` l, cp.`tpch/partsupp.parquet` ps \n where l.l_partkey = ps.ps_partkey and l.l_suppkey = ps.ps_suppkey ;");
    }

    @Test
    public void testText() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/regions.csv").toURI().toString();
        String query = String.format("select * from dfs_test.`%s`", root);
        TestExampleQueries.test(query);
    }

    @Test
    public void testFilterOnArrayTypes() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/regions.csv").toURI().toString();
        String query = String.format("select columns[0] from dfs_test.`%s`  where cast(columns[0] as int) > 1 and cast(columns[1] as varchar(20))='ASIA'", root);
        TestExampleQueries.test(query);
    }

    @Test
    @Ignore(value="DRILL-3774")
    public void testTextPartitions() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/").toURI().toString();
        String query = String.format("select * from dfs_test.`%s`", root);
        TestExampleQueries.test(query);
    }

    @Test
    @Ignore(value="DRILL-3004")
    public void testJoin() throws Exception {
        TestExampleQueries.test("alter session set `planner.enable_hashjoin` = false");
        TestExampleQueries.test("SELECT\n  nations.N_NAME,\n  regions.R_NAME\nFROM\n  cp.`tpch/nation.parquet` nations\nJOIN\n  cp.`tpch/region.parquet` regions\n  on nations.N_REGIONKEY = regions.R_REGIONKEY where 1 = 0");
    }

    @Test
    public void countDistinct() throws Exception {
        TestExampleQueries.test("EXPLAIN PLAN FOR SELECT * FROM (SELECT COUNT(employee_id), SUM(employee_id), COUNT(DISTINCT employee_id) FROM cp.`employee.json`) T LIMIT 0");
    }

    @Test
    public void testWhere() throws Exception {
        TestExampleQueries.test("select * from cp.`employee.json` ");
    }

    @Test
    public void testGroupBy() throws Exception {
        TestExampleQueries.test("select marital_status, COUNT(1) as cnt from cp.`employee.json` group by marital_status");
    }

    @Test
    public void testExplainPhysical() throws Exception {
        TestExampleQueries.test("explain plan for select marital_status, COUNT(1) as cnt from cp.`employee.json` group by marital_status");
    }

    @Test
    public void testExplainLogical() throws Exception {
        TestExampleQueries.test("explain plan without implementation for select marital_status, COUNT(1) as cnt from cp.`employee.json` group by marital_status");
    }

    @Test
    public void testGroupScanRowCountExp1() throws Exception {
        TestExampleQueries.test("EXPLAIN plan for select count(n_nationkey) as mycnt, count(*) + 2 * count(*) as mycnt2 from cp.`tpch/nation.parquet` ");
    }

    @Test
    public void testGroupScanRowCount1() throws Exception {
        TestExampleQueries.test("select count(n_nationkey) as mycnt, count(*) + 2 * count(*) as mycnt2 from cp.`tpch/nation.parquet` ");
    }

    @Test
    public void testColunValueCnt() throws Exception {
        TestExampleQueries.test("select count( 1 + 2) from cp.`tpch/nation.parquet` ");
    }

    @Test
    public void testGroupScanRowCountExp2() throws Exception {
        TestExampleQueries.test("EXPLAIN plan for select count(*) as mycnt, count(*) + 2 * count(*) as mycnt2 from cp.`tpch/nation.parquet` ");
    }

    @Test
    public void testGroupScanRowCount2() throws Exception {
        TestExampleQueries.test("select count(*) as mycnt, count(*) + 2 * count(*) as mycnt2 from cp.`tpch/nation.parquet` where 1 < 2");
    }

    @Test
    public void testDrill428() throws Exception {
        TestExampleQueries.test("select cast(NON_EXIST_COL as varchar(10)) from cp.`employee.json` limit 2; ");
    }

    @Test
    public void testOrderByDiffColumn() throws Exception {
        TestExampleQueries.test("select r_name from cp.`tpch/region.parquet` order by r_regionkey");
        TestExampleQueries.test("select r_name from cp.`tpch/region.parquet` order by r_name, r_regionkey");
        TestExampleQueries.test("select cast(r_name as varchar(20)) from cp.`tpch/region.parquet` order by r_name");
    }

    @Test
    @Ignore(value="DRILL-1866")
    public void testLimit0_1() throws Exception {
        TestExampleQueries.test("select n_nationkey, n_name from cp.`tpch/nation.parquet` limit 0");
        TestExampleQueries.test("select n_nationkey, n_name from cp.`tpch/nation.parquet` limit 0 offset 5");
        TestExampleQueries.test("select n_nationkey, n_name from cp.`tpch/nation.parquet` order by n_nationkey limit 0");
        TestExampleQueries.test("select * from cp.`tpch/nation.parquet` limit 0");
        TestExampleQueries.test("select n.n_nationkey from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r where n.n_regionkey = r.r_regionkey limit 0");
        TestExampleQueries.test("select n_regionkey, count(*) from cp.`tpch/nation.parquet` group by n_regionkey limit 0");
    }

    @Test
    public void testTextJoin() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/nations.csv").toURI().toString();
        String root1 = FileUtils.getResourceAsFile((String)"/store/text/data/regions.csv").toURI().toString();
        String query = String.format("select t1.columns[1] from dfs_test.`%s` t1,  dfs_test.`%s` t2 where t1.columns[0] = t2.columns[0]", root, root1);
        TestExampleQueries.test(query);
    }

    @Test
    public void testDRILL_811View() throws Exception {
        TestExampleQueries.test("use dfs_test.tmp");
        TestExampleQueries.test("create view nation_view_testexamplequeries as select * from cp.`tpch/nation.parquet`;");
        TestExampleQueries.test("select n.n_nationkey, n.n_name, n.n_regionkey from nation_view_testexamplequeries n where n.n_nationkey > 8 order by n.n_regionkey");
        TestExampleQueries.test("select n.n_regionkey, count(*) as cnt from nation_view_testexamplequeries n where n.n_nationkey > 8 group by n.n_regionkey order by n.n_regionkey");
        TestExampleQueries.test("drop view nation_view_testexamplequeries ");
    }

    @Test
    public void testDRILL_811ViewJoin() throws Exception {
        TestExampleQueries.test("use dfs_test.tmp");
        TestExampleQueries.test("create view nation_view_testexamplequeries as select * from cp.`tpch/nation.parquet`;");
        TestExampleQueries.test("create view region_view_testexamplequeries as select * from cp.`tpch/region.parquet`;");
        TestExampleQueries.test("select n.n_nationkey, n.n_regionkey, r.r_name from region_view_testexamplequeries r , nation_view_testexamplequeries n where r.r_regionkey = n.n_regionkey ");
        TestExampleQueries.test("select n.n_regionkey, count(*) as cnt from region_view_testexamplequeries r , nation_view_testexamplequeries n where r.r_regionkey = n.n_regionkey and n.n_nationkey > 8 group by n.n_regionkey order by n.n_regionkey");
        TestExampleQueries.test("select n.n_regionkey, count(*) as cnt from region_view_testexamplequeries r join nation_view_testexamplequeries n on r.r_regionkey = n.n_regionkey and n.n_nationkey > 8 group by n.n_regionkey order by n.n_regionkey");
        TestExampleQueries.test("drop view region_view_testexamplequeries ");
        TestExampleQueries.test("drop view nation_view_testexamplequeries ");
    }

    @Test
    public void testDRILL_811Json() throws Exception {
        TestExampleQueries.test("use dfs_test.tmp");
        TestExampleQueries.test("create view region_view_testexamplequeries as select * from cp.`region.json`;");
        TestExampleQueries.test("select sales_city, sales_region from region_view_testexamplequeries where region_id > 50 order by sales_country; ");
        TestExampleQueries.test("drop view region_view_testexamplequeries ");
    }

    @Test
    public void testCase() throws Exception {
        TestExampleQueries.test("select case when n_nationkey > 0 and n_nationkey < 2 then concat(n_name, '_abc') when n_nationkey >=2 and n_nationkey < 4 then '_EFG' else concat(n_name,'_XYZ') end from cp.`tpch/nation.parquet` ;");
    }

    @Test
    public void testJoinCondWithDifferentTypes() throws Exception {
        TestExampleQueries.test("select t1.department_description from cp.`department.json` t1, cp.`employee.json` t2 where (cast(t1.department_id as double)) = t2.department_id");
        TestExampleQueries.test("select t1.full_name from cp.`employee.json` t1, cp.`department.json` t2 where cast(t1.department_id as double) = t2.department_id and cast(t1.position_id as bigint) = t2.department_id");
        TestExampleQueries.test("select t1.full_name from cp.`employee.json` t1, cp.`department.json` t2 where t1.department_id = t2.department_id and t1.position_id = t2.department_id");
    }

    @Test
    public void testTopNWithSV2() throws Exception {
        int actualRecordCount = TestExampleQueries.testSql("select N_NATIONKEY from cp.`tpch/nation.parquet` where N_NATIONKEY < 10 order by N_NATIONKEY limit 5");
        int expectedRecordCount = 5;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }

    @Test
    public void testTextQueries() throws Exception {
        TestExampleQueries.test("select cast('285572516' as int) from cp.`tpch/nation.parquet` limit 1");
    }

    @Test
    public void testLikeEscape() throws Exception {
        int actualRecordCount = TestExampleQueries.testSql("select id, name from cp.`jsoninput/specialchar.json` where name like '%#_%' ESCAPE '#'");
        int expectedRecordCount = 1;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }

    @Test
    public void testSimilarEscape() throws Exception {
        int actualRecordCount = TestExampleQueries.testSql("select id, name from cp.`jsoninput/specialchar.json` where name similar to '(N|S)%#_%' ESCAPE '#'");
        int expectedRecordCount = 1;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }

    @Test
    public void testImplicitDownwardCast() throws Exception {
        int actualRecordCount = TestExampleQueries.testSql("select o_totalprice from cp.`tpch/orders.parquet` where o_orderkey=60000 and o_totalprice=299402");
        int expectedRecordCount = 0;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }

    @Test
    public void testCastToVarcharWithLength() throws Exception {
        int actualRecordCount = TestExampleQueries.testSql("select first_name from cp.`employee.json` where cast(first_name as varchar(2)) = 'Sh'");
        int expectedRecordCount = 27;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        actualRecordCount = TestExampleQueries.testSql("select first_name from cp.`employee.json` where cast(cast(cast(first_name as varchar(5)) as varchar(10)) as varchar(2)) = 'Sh'");
        expectedRecordCount = 27;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        actualRecordCount = TestExampleQueries.testSql("select first_name from cp.`employee.json` where cast(cast(cast(first_name as varchar(5)) as varchar(10)) as varchar(2)) = substr(first_name, 1, 2)");
        expectedRecordCount = 1155;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        actualRecordCount = TestExampleQueries.testSql("select n_name from cp.`tpch/nation.parquet` where cast(n_name as varchar(2)) = 'UN'");
        expectedRecordCount = 2;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }

    @Test
    public void testIdentifierMaxLength() throws Exception {
        TestExampleQueries.test("select employee_id as  aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa from cp.`employee.json` limit 1");
        TestExampleQueries.test("select employee_id from cp.`employee.json` as aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa limit 1");
    }

    @Test
    public void testOrderByDiffColumnsInSubqAndOuter() throws Exception {
        String query = "select n.n_nationkey from  (select n_nationkey, n_regionkey from cp.`tpch/nation.parquet` order by n_regionkey) n  order by n.n_nationkey";
        TestExampleQueries.test("alter session set `planner.slice_target` = 1; " + query);
    }

    @Test
    @Ignore(value="DRILL-1866")
    public void testLimitInSubqAndOrderByOuter() throws Exception {
        String query = "select t2.n_nationkey from (select n_nationkey, n_regionkey from cp.`tpch/nation.parquet` t1 group by n_nationkey, n_regionkey limit 10) t2 order by t2.n_nationkey";
        TestExampleQueries.test("alter session set `planner.slice_target` = 1; " + query);
    }

    @Test
    public void testCaseInsensitiveJoin() throws Exception {
        TestExampleQueries.test("select n3.n_name from (select n2.n_name from cp.`tpch/nation.parquet` n1, cp.`tpch/nation.parquet` n2 where n1.N_name = n2.n_name) n3  join cp.`tpch/nation.parquet` n4 on n3.n_name = n4.n_name");
    }

    @Test
    public void test2PhaseAggAfterOrderBy() throws Exception {
        String query = "select count(*) from (select o_custkey from cp.`tpch/orders.parquet` order by o_custkey)";
        TestExampleQueries.test("alter session set `planner.slice_target` = 1; " + query);
    }

    @Test
    public void testCaseInsensitiveSubQuery() throws Exception {
        int actualRecordCount = 0;
        int expectedRecordCount = 0;
        actualRecordCount = TestExampleQueries.testSql("select EMPID from ( select employee_id as empid from cp.`employee.json` limit 2)");
        expectedRecordCount = 2;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        actualRecordCount = TestExampleQueries.testSql("select EMPLOYEE_ID from ( select employee_id from cp.`employee.json` where Employee_id is not null limit 2)");
        expectedRecordCount = 2;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        actualRecordCount = TestExampleQueries.testSql("select x.EMPLOYEE_ID from ( select employee_id from cp.`employee.json` limit 2) X");
        expectedRecordCount = 2;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        actualRecordCount = TestExampleQueries.testSql("select NID from ( select n_nationkey as nid from cp.`tpch/nation.parquet`) where NID = 3");
        expectedRecordCount = 1;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        actualRecordCount = TestExampleQueries.testSql("select x.N_nationkey from ( select n_nationkey from cp.`tpch/nation.parquet`) X where N_NATIONKEY = 3");
        expectedRecordCount = 1;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/regions.csv").toURI().toString();
        String query = String.format("select rid, x.name from (select columns[0] as RID, columns[1] as NAME from dfs_test.`%s`) X where X.rid = 2", root);
        actualRecordCount = TestExampleQueries.testSql(query);
        expectedRecordCount = 1;
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }

    @Test
    public void testMultipleCountDistinctWithGroupBy() throws Exception {
        String query = "select n_regionkey, count(distinct n_nationkey), count(distinct n_name) from cp.`tpch/nation.parquet` group by n_regionkey;";
        String hashagg_only = "alter session set `planner.enable_hashagg` = true; alter session set `planner.enable_streamagg` = false;";
        String streamagg_only = "alter session set `planner.enable_hashagg` = false; alter session set `planner.enable_streamagg` = true;";
        TestExampleQueries.test(hashagg_only + query);
        TestExampleQueries.test(streamagg_only + query);
        TestExampleQueries.test("alter session set `planner.slice_target` = 1; " + hashagg_only + query);
        TestExampleQueries.test("alter session set `planner.slice_target` = 1; " + streamagg_only + query);
    }

    @Test
    public void testFilterInSubqueryAndOutside() throws Exception {
        String query1 = "select r_regionkey from (select r_regionkey from cp.`tpch/region.parquet` o where r_regionkey < 2) where r_regionkey > 2";
        String query2 = "select r_regionkey from (select r_regionkey from cp.`tpch/region.parquet` o where r_regionkey < 4) where r_regionkey > 1";
        int actualRecordCount = 0;
        int expectedRecordCount = 0;
        actualRecordCount = TestExampleQueries.testSql(query1);
        Assert.assertEquals((long)expectedRecordCount, (long)actualRecordCount);
        expectedRecordCount = 2;
        actualRecordCount = TestExampleQueries.testSql(query2);
        Assert.assertEquals((long)expectedRecordCount, (long)actualRecordCount);
    }

    @Test
    public void testLimit0SubqueryWithFilter() throws Exception {
        String query1 = "select * from (select sum(1) as x from  cp.`tpch/region.parquet` limit 0) WHERE x < 10";
        String query2 = "select * from (select sum(1) as x from  cp.`tpch/region.parquet` limit 0) WHERE (0 = 1)";
        int actualRecordCount = 0;
        int expectedRecordCount = 0;
        actualRecordCount = TestExampleQueries.testSql(query1);
        Assert.assertEquals((long)expectedRecordCount, (long)actualRecordCount);
        actualRecordCount = TestExampleQueries.testSql(query2);
        Assert.assertEquals((long)expectedRecordCount, (long)actualRecordCount);
    }

    @Test
    public void testAggExpressionWithGroupBy() throws Exception {
        String query = "select l_suppkey, sum(l_extendedprice)/sum(l_quantity) as avg_price \n from cp.`tpch/lineitem.parquet` where l_orderkey in \n (select o_orderkey from cp.`tpch/orders.parquet` where o_custkey = 2) \n and l_suppkey = 4 group by l_suppkey";
        TestExampleQueries.testBuilder().sqlQuery(query).ordered().baselineColumns("l_suppkey", "avg_price").baselineValues(4, 1374.47).build().run();
    }

    @Test
    public void testAggExpressionWithGroupByHaving() throws Exception {
        String query = "select l_suppkey, sum(l_extendedprice)/sum(l_quantity) as avg_price \n from cp.`tpch/lineitem.parquet` where l_orderkey in \n (select o_orderkey from cp.`tpch/orders.parquet` where o_custkey = 2) \n group by l_suppkey having sum(l_extendedprice)/sum(l_quantity) > 1850.0";
        TestExampleQueries.testBuilder().sqlQuery(query).ordered().baselineColumns("l_suppkey", "avg_price").baselineValues(98, 1854.95).build().run();
    }

    @Test
    public void testExchangeRemoveForJoinPlan() throws Exception {
        String WORKING_PATH = TestTools.getWorkingPath();
        String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";
        String sql = String.format("select t2.n_nationkey from dfs_test.`%s/tpchmulti/region` t1 join dfs_test.`%s/tpchmulti/nation` t2 on t2.n_regionkey = t1.r_regionkey", TEST_RES_PATH, TEST_RES_PATH);
        TestExampleQueries.testBuilder().unOrdered().optionSettingQueriesForTestQuery("alter session set `planner.slice_target` = 10; alter session set `planner.join.row_count_estimate_factor` = 0.1").sqlQuery(sql).optionSettingQueriesForBaseline("alter session set `planner.slice_target` = 100000; alter session set `planner.join.row_count_estimate_factor` = 1.0").sqlBaselineQuery(sql).build().run();
    }

    @Test
    public void testNestedTypesPastJoinReportsValidResult() throws Exception {
        String query = "select t1.uid, t1.events, t1.events[0].evnt_id as event_id, t2.transactions, t2.transactions[0] as trans, t1.odd, t2.even from cp.`project/complex/a.json` t1, cp.`project/complex/b.json` t2 where t1.uid = t2.uid";
        TestExampleQueries.testBuilder().sqlQuery("select t1.uid, t1.events, t1.events[0].evnt_id as event_id, t2.transactions, t2.transactions[0] as trans, t1.odd, t2.even from cp.`project/complex/a.json` t1, cp.`project/complex/b.json` t2 where t1.uid = t2.uid").ordered().jsonBaselineFile("project/complex/drill-2163-result.json").build().run();
    }

    @Test
    public void testSimilar() throws Exception {
        String query = "select n_nationkey from cp.`tpch/nation.parquet` where n_name similar to 'CHINA' order by n_regionkey";
        TestExampleQueries.testBuilder().sqlQuery(query).unOrdered().optionSettingQueriesForTestQuery("alter session set `planner.slice_target` = 1").baselineColumns("n_nationkey").baselineValues(18).go();
        TestExampleQueries.test("alter session set `planner.slice_target` = 100000");
    }

    @Test
    @Ignore(value="Move to TestParquetWriter. Have to ensure same file name does not exist on filesystem.")
    public void testCreateTableSameColumnNames() throws Exception {
        String creatTable = "CREATE TABLE CaseInsensitiveColumnNames as select cast(r_regionkey as BIGINT) BIGINT_col, cast(r_regionkey as DECIMAL) bigint_col \nFROM cp.`tpch/region.parquet`;\n";
        TestExampleQueries.test("USE dfs_test.tmp");
        TestExampleQueries.test(creatTable);
        TestExampleQueries.testBuilder().sqlQuery("select * from `CaseInsensitiveColumnNames`").unOrdered().baselineColumns("BIGINT_col", "bigint_col0\n").baselineValues(0L, new BigDecimal(0)).baselineValues(1L, new BigDecimal(1)).baselineValues(2L, new BigDecimal(2)).baselineValues(3L, new BigDecimal(3)).baselineValues(4L, new BigDecimal(4)).build().run();
    }

    @Test
    public void testColumnNamesDifferInCaseOnly() throws Exception {
        TestExampleQueries.testBuilder().sqlQuery("select r_regionkey a, r_regionkey A FROM cp.`tpch/region.parquet`").unOrdered().baselineColumns("a", "A0").baselineValues(0, 0).baselineValues(1, 1).baselineValues(2, 2).baselineValues(3, 3).baselineValues(4, 4).build().run();
        TestExampleQueries.testBuilder().sqlQuery("select employee_id, Employee_id from cp.`employee.json` limit 2").unOrdered().baselineColumns("employee_id", "Employee_id0").baselineValues(1L, 1L).baselineValues(2L, 2L).build().run();
    }

    @Test
    public void testOrderbyArrayElement() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/json/orderByArrayElement.json").toURI().toString();
        String query = String.format("select t.id, t.list[0] as SortingElem from dfs_test.`%s` t order by t.list[0]", root);
        TestExampleQueries.testBuilder().sqlQuery(query).ordered().baselineColumns("id", "SortingElem").baselineValues(1L, 1L).baselineValues(5L, 2L).baselineValues(4L, 3L).baselineValues(2L, 5L).baselineValues(3L, 6L).build().run();
    }

    @Test
    public void testCorrelatedExistsWithInSubq() throws Exception {
        String query = "select count(*) as cnt from cp.`tpch/lineitem.parquet` l where exists  (select ps.ps_suppkey from cp.`tpch/partsupp.parquet` ps where ps.ps_suppkey = l.l_suppkey and ps.ps_partkey  in (select p.p_partkey from cp.`tpch/part.parquet` p where p.p_type like '%NICKEL'))";
        TestExampleQueries.testBuilder().sqlQuery(query).unOrdered().baselineColumns("cnt").baselineValues(60175L).go();
    }

    @Test
    public void testOrderbyArrayElementInSubquery() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/json/orderByArrayElement.json").toURI().toString();
        String query = String.format("select s.id from \n(select id \nfrom dfs_test.`%s` \norder by list[0]) s", root);
        TestExampleQueries.testBuilder().sqlQuery(query).ordered().baselineColumns("id").baselineValues(1L).baselineValues(5L).baselineValues(4L).baselineValues(2L).baselineValues(3L).build().run();
    }

    @Test
    public void testCTASOrderByCoumnNotInSelectClause() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/regions.csv").toURI().toString();
        String queryCTAS1 = "CREATE TABLE TestExampleQueries_testCTASOrderByCoumnNotInSelectClause1 as select r_name from cp.`tpch/region.parquet` order by r_regionkey;";
        String queryCTAS2 = String.format("CREATE TABLE TestExampleQueries_testCTASOrderByCoumnNotInSelectClause2 as SELECT columns[1] as col FROM dfs_test.`%s` ORDER BY cast(columns[0] as double)", root);
        String query1 = "select * from TestExampleQueries_testCTASOrderByCoumnNotInSelectClause1";
        String query2 = "select * from TestExampleQueries_testCTASOrderByCoumnNotInSelectClause2";
        TestExampleQueries.test("use dfs_test.tmp");
        TestExampleQueries.test(queryCTAS1);
        TestExampleQueries.test(queryCTAS2);
        TestExampleQueries.testBuilder().sqlQuery(query1).ordered().baselineColumns("r_name").baselineValues("AFRICA").baselineValues("AMERICA").baselineValues("ASIA").baselineValues("EUROPE").baselineValues("MIDDLE EAST").build().run();
        TestExampleQueries.testBuilder().sqlQuery(query2).ordered().baselineColumns("col").baselineValues("AFRICA").baselineValues("AMERICA").baselineValues("ASIA").baselineValues("EUROPE").baselineValues("MIDDLE EAST").build().run();
    }

    @Test
    public void createJsonWithEmptyList() throws Exception {
        String file = FileUtils.getResourceAsFile((String)"/store/json/record_with_empty_list.json").toURI().toString();
        String tableName = "jsonWithEmptyList";
        TestExampleQueries.test("USE dfs_test.tmp");
        TestExampleQueries.test("ALTER SESSION SET `store.format`='json'");
        TestExampleQueries.test(String.format("CREATE TABLE %s AS SELECT * FROM `%s`", "jsonWithEmptyList", file));
        TestExampleQueries.test(String.format("SELECT COUNT(*) FROM %s", "jsonWithEmptyList"));
        TestExampleQueries.test("ALTER SESSION SET `store.format`='parquet'");
    }

    @Test
    public void testGroupByStarSchemaless() throws Exception {
        String query = "SELECT n.n_nationkey AS col \nFROM (SELECT * FROM cp.`tpch/nation.parquet`) AS n \nGROUP BY n.n_nationkey \nORDER BY n.n_nationkey";
        TestExampleQueries.testBuilder().sqlQuery(query).ordered().csvBaselineFile("testframework/testExampleQueries/testGroupByStarSchemaless.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("col").build().run();
    }

    @Test
    public void testGroupByCaseInSubquery() throws Exception {
        String query1 = "select (case when t.r_regionkey in (3) then 0 else 1 end) as col \nfrom cp.`tpch/region.parquet` t \ngroup by (case when t.r_regionkey in (3) then 0 else 1 end)";
        String query2 = "select sum(case when t.r_regionkey in (3) then 0 else 1 end) as col \nfrom cp.`tpch/region.parquet` t";
        String query3 = "select (case when (r_regionkey IN (0, 2, 3, 4)) then 0 else r_regionkey end) as col1, min(r_regionkey) as col2 \nfrom cp.`tpch/region.parquet` \ngroup by (case when (r_regionkey IN (0, 2, 3, 4)) then 0 else r_regionkey end)";
        TestExampleQueries.testBuilder().sqlQuery(query1).unOrdered().baselineColumns("col").baselineValues(0).baselineValues(1).build().run();
        TestExampleQueries.testBuilder().sqlQuery(query2).unOrdered().baselineColumns("col").baselineValues(4L).build().run();
        TestExampleQueries.testBuilder().sqlQuery(query3).unOrdered().baselineColumns("col1", "col2").baselineValues(0, 0).baselineValues(1, 1).build().run();
    }

    @Test
    public void testHavingAggFunction() throws Exception {
        String query1 = "select n_nationkey as col \nfrom cp.`tpch/nation.parquet` \ngroup by n_nationkey \nhaving sum(case when n_regionkey in (1, 2) then 1 else 0 end) + \nsum(case when n_regionkey in (2, 3) then 1 else 0 end) > 1";
        String query2 = "select n_nationkey as col \nfrom cp.`tpch/nation.parquet` \ngroup by n_nationkey \nhaving n_nationkey in \n(select r_regionkey \nfrom cp.`tpch/region.parquet` \ngroup by r_regionkey \nhaving sum(r_regionkey) > 0)";
        String query3 = "select n_nationkey as col \nfrom cp.`tpch/nation.parquet` \ngroup by n_nationkey \nhaving max(n_regionkey) > ((select min(r_regionkey) from cp.`tpch/region.parquet`) + 3)";
        TestExampleQueries.testBuilder().sqlQuery(query1).unOrdered().csvBaselineFile("testframework/testExampleQueries/testHavingAggFunction/q1.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("col").build().run();
        TestExampleQueries.testBuilder().sqlQuery(query2).unOrdered().csvBaselineFile("testframework/testExampleQueries/testHavingAggFunction/q2.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("col").build().run();
        TestExampleQueries.testBuilder().sqlQuery(query3).unOrdered().csvBaselineFile("testframework/testExampleQueries/testHavingAggFunction/q3.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("col").build().run();
    }

    @Test
    public void testNestLoopJoinScalarSubQ() throws Exception {
        TestExampleQueries.testBuilder().sqlQuery("select n_nationkey from cp.`tpch/nation.parquet` where n_nationkey >= (select min(c_nationkey) from cp.`tpch/customer.parquet`)").unOrdered().sqlBaselineQuery("select n_nationkey from cp.`tpch/nation.parquet`").build().run();
    }

    @Test
    public void testGbAndObDifferentExp() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/data/nations.csv").toURI().toString();
        String query = String.format("select cast(columns[0] as int) as nation_key  from dfs_test.`%s`  group by columns[0]  order by cast(columns[0] as int)", root);
        TestExampleQueries.testBuilder().sqlQuery(query).ordered().csvBaselineFile("testframework/testExampleQueries/testGroupByStarSchemaless.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("nation_key").build().run();
        String query2 = String.format("select cast(columns[0] as int) as nation_key  from dfs_test.`%s`  group by cast(columns[0] as int)  order by cast(columns[0] as int)", root);
        TestExampleQueries.testBuilder().sqlQuery(query2).ordered().csvBaselineFile("testframework/testExampleQueries/testGroupByStarSchemaless.tsv").baselineTypes(TypeProtos.MinorType.INT).baselineColumns("nation_key").build().run();
    }

    @Test
    public void testDRILL_3004() throws Exception {
        String query = "SELECT\n  nations.N_NAME,\n  regions.R_NAME\nFROM\n  cp.`tpch/nation.parquet` nations\nJOIN\n  cp.`tpch/region.parquet` regions\non nations.N_REGIONKEY = regions.R_REGIONKEY where 1 = 0";
        TestExampleQueries.testBuilder().sqlQuery("SELECT\n  nations.N_NAME,\n  regions.R_NAME\nFROM\n  cp.`tpch/nation.parquet` nations\nJOIN\n  cp.`tpch/region.parquet` regions\non nations.N_REGIONKEY = regions.R_REGIONKEY where 1 = 0").expectsEmptyResultSet().optionSettingQueriesForTestQuery("ALTER SESSION SET `planner.enable_hashjoin` = false; ALTER SESSION SET `planner.disable_exchanges` = true").build().run();
    }

    @Test
    public void testRepeatedListProjectionPastJoin() throws Exception {
        String query = "select * from cp.`join/join-left-drill-3032.json` f1 inner join cp.`join/join-right-drill-3032.json` f2 on f1.id = f2.id";
        TestExampleQueries.testBuilder().sqlQuery("select * from cp.`join/join-left-drill-3032.json` f1 inner join cp.`join/join-right-drill-3032.json` f2 on f1.id = f2.id").unOrdered().baselineColumns("id", "id0", "aaa").baselineValues(1L, 1L, TestBuilder.listOf(TestBuilder.listOf(TestBuilder.listOf("val1"), TestBuilder.listOf("val2")))).go();
    }

    @Test
    @Ignore
    public void testPartitionCTAS() throws Exception {
        TestExampleQueries.test("use dfs_test.tmp; create table mytable1  partition by (r_regionkey, r_comment) as select r_regionkey, r_name, r_comment from cp.`tpch/region.parquet`");
        TestExampleQueries.test("use dfs_test.tmp; create table mytable2  partition by (r_regionkey, r_comment) as select * from cp.`tpch/region.parquet` where r_name = 'abc' ");
        TestExampleQueries.test("use dfs_test.tmp; create table mytable3  partition by (r_regionkey, n_nationkey) as   select r.r_regionkey, r.r_name, n.n_nationkey, n.n_name from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r   where n.n_regionkey = r.r_regionkey");
        TestExampleQueries.test("use dfs_test.tmp; create table mytable4  partition by (r_regionkey, r_comment) as   select  r.* from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r   where n.n_regionkey = r.r_regionkey");
    }

    @Test
    public void testWindowFunAndStarCol() throws Exception {
        String query = " select * , sum(n_nationkey) over (partition by n_regionkey) as sumwin  from cp.`tpch/nation.parquet`";
        String baseQuery = " select n_nationkey, n_name, n_regionkey, n_comment,    sum(n_nationkey) over (partition by n_regionkey) as sumwin  from cp.`tpch/nation.parquet`";
        TestExampleQueries.testBuilder().sqlQuery(" select * , sum(n_nationkey) over (partition by n_regionkey) as sumwin  from cp.`tpch/nation.parquet`").unOrdered().sqlBaselineQuery(" select n_nationkey, n_name, n_regionkey, n_comment,    sum(n_nationkey) over (partition by n_regionkey) as sumwin  from cp.`tpch/nation.parquet`").build().run();
        String joinQuery = " select *, sum(n.n_nationkey) over (partition by r.r_regionkey order by r.r_name) as sumwin from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r  where n.n_regionkey = r.r_regionkey";
        String joinBaseQuery = " select n.n_nationkey, n.n_name, n.n_regionkey, n.n_comment, r.r_regionkey, r.r_name, r.r_comment,    sum(n.n_nationkey) over (partition by r.r_regionkey order by r.r_name) as sumwin  from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r  where n.n_regionkey = r.r_regionkey";
        TestExampleQueries.testBuilder().sqlQuery(" select *, sum(n.n_nationkey) over (partition by r.r_regionkey order by r.r_name) as sumwin from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r  where n.n_regionkey = r.r_regionkey").unOrdered().sqlBaselineQuery(" select n.n_nationkey, n.n_name, n.n_regionkey, n.n_comment, r.r_regionkey, r.r_name, r.r_comment,    sum(n.n_nationkey) over (partition by r.r_regionkey order by r.r_name) as sumwin  from cp.`tpch/nation.parquet` n, cp.`tpch/region.parquet` r  where n.n_regionkey = r.r_regionkey").build().run();
    }

    @Test
    public void testEmptyCSVinDirectory() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/directoryWithEmpyCSV").toURI().toString();
        String toFile = FileUtils.getResourceAsFile((String)"/store/text/directoryWithEmpyCSV/empty.csv").toURI().toString();
        String query1 = String.format("explain plan for select * from dfs_test.`%s`", root);
        String query2 = String.format("explain plan for select * from dfs_test.`%s`", toFile);
        TestExampleQueries.test(query1);
        TestExampleQueries.test(query2);
    }

    @Test
    public void testNegativeExtractOperator() throws Exception {
        String query = "select -EXTRACT(DAY FROM birth_date) as col \nfrom cp.`employee.json` \norder by col \nlimit 5";
        TestExampleQueries.testBuilder().sqlQuery(query).ordered().baselineColumns("col").baselineValues(-27L).baselineValues(-27L).baselineValues(-27L).baselineValues(-26L).baselineValues(-26L).build().run();
    }

    @Test
    public void testDistinctOverAggFunctionWithGroupBy() throws Exception {
        String query1 = "select distinct count(distinct n_nationkey) as col from cp.`tpch/nation.parquet` group by n_regionkey order by 1";
        String query2 = "select distinct count(distinct n_nationkey) as col from cp.`tpch/nation.parquet` group by n_regionkey order by count(distinct n_nationkey)";
        String query3 = "select distinct sum(n_nationkey) as col from cp.`tpch/nation.parquet` group by n_regionkey order by 1";
        String query4 = "select distinct sum(n_nationkey) as col from cp.`tpch/nation.parquet` group by n_regionkey order by col";
        TestExampleQueries.testBuilder().sqlQuery(query1).unOrdered().baselineColumns("col").baselineValues(5L).build().run();
        TestExampleQueries.testBuilder().sqlQuery(query2).unOrdered().baselineColumns("col").baselineValues(5L).build().run();
        TestExampleQueries.testBuilder().sqlQuery(query3).ordered().baselineColumns("col").baselineValues(47L).baselineValues(50L).baselineValues(58L).baselineValues(68L).baselineValues(77L).build().run();
        TestExampleQueries.testBuilder().sqlQuery(query4).ordered().baselineColumns("col").baselineValues(47L).baselineValues(50L).baselineValues(58L).baselineValues(68L).baselineValues(77L).build().run();
    }

    @Test
    public void testDateImplicitCasting() throws Exception {
        String query = "SELECT birth_date \nFROM cp.`employee.json` \nWHERE birth_date BETWEEN '1920-01-01' AND cast('1931-01-01' AS DATE) \norder by birth_date";
        TestExampleQueries.testBuilder().sqlQuery(query).unOrdered().baselineColumns("birth_date").baselineValues("1920-04-17").baselineValues("1921-12-04").baselineValues("1922-08-10").baselineValues("1926-10-27").baselineValues("1928-03-20").baselineValues("1930-01-08").build().run();
    }
}

