/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.PlanTestBase;
import org.apache.drill.common.exceptions.UserException;
import org.junit.Assert;
import org.junit.Test;

public class TestDropTable
extends PlanTestBase {
    private static final String CREATE_SIMPLE_TABLE = "create table %s as select 1 from cp.`employee.json`";
    private static final String DROP_TABLE = "drop table %s";
    private static final String BACK_TICK = "`";

    @Test
    public void testDropJsonTable() throws Exception {
        TestDropTable.test("use dfs_test.tmp");
        TestDropTable.test("alter session set `store.format` = 'json'");
        String tableName = "simple_json";
        TestDropTable.test(String.format(CREATE_SIMPLE_TABLE, "simple_json"));
        String dropSql = String.format(DROP_TABLE, "simple_json");
        TestDropTable.testBuilder().sqlQuery(dropSql).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("Table [%s] dropped", "simple_json")).go();
    }

    @Test
    public void testDropParquetTable() throws Exception {
        TestDropTable.test("use dfs_test.tmp");
        String tableName = "simple_json";
        TestDropTable.test(String.format(CREATE_SIMPLE_TABLE, "simple_json"));
        String dropSql = String.format(DROP_TABLE, "simple_json");
        TestDropTable.testBuilder().sqlQuery(dropSql).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("Table [%s] dropped", "simple_json")).go();
    }

    @Test
    public void testDropTextTable() throws Exception {
        TestDropTable.test("use dfs_test.tmp");
        TestDropTable.test("alter session set `store.format` = 'csv'");
        String csvTable = "simple_csv";
        TestDropTable.test(String.format(CREATE_SIMPLE_TABLE, "simple_csv"));
        String dropSql = String.format(DROP_TABLE, "simple_csv");
        TestDropTable.testBuilder().sqlQuery(dropSql).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("Table [%s] dropped", "simple_csv")).go();
        TestDropTable.test("alter session set `store.format` = 'psv'");
        String psvTable = "simple_psv";
        TestDropTable.test(String.format(CREATE_SIMPLE_TABLE, "simple_psv"));
        dropSql = String.format(DROP_TABLE, "simple_psv");
        TestDropTable.testBuilder().sqlQuery(dropSql).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("Table [%s] dropped", "simple_psv")).go();
        TestDropTable.test("alter session set `store.format` = 'tsv'");
        String tsvTable = "simple_tsv";
        TestDropTable.test(String.format(CREATE_SIMPLE_TABLE, "simple_tsv"));
        dropSql = String.format(DROP_TABLE, "simple_tsv");
        TestDropTable.testBuilder().sqlQuery(dropSql).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("Table [%s] dropped", "simple_tsv")).go();
    }

    @Test
    public void testNonHomogenousDrop() throws Exception {
        TestDropTable.test("use dfs_test.tmp");
        String tableName = "homogenous_table";
        TestDropTable.test(String.format(CREATE_SIMPLE_TABLE, "homogenous_table"));
        TestDropTable.test("alter session set `store.format` = 'json'");
        String nestedJsonTable = "homogenous_table/json_table";
        TestDropTable.test(String.format(CREATE_SIMPLE_TABLE, "`homogenous_table/json_table`"));
        TestDropTable.test("show files from homogenous_table");
        boolean dropFailed = false;
        try {
            TestDropTable.test(String.format(DROP_TABLE, "homogenous_table"));
        }
        catch (UserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR"));
            dropFailed = true;
        }
        Assert.assertTrue((String)"Dropping of non-homogeneous table should have failed", (boolean)dropFailed);
        TestDropTable.testBuilder().sqlQuery(String.format(DROP_TABLE, "`homogenous_table/json_table`")).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("Table [%s] dropped", "homogenous_table/json_table")).go();
        TestDropTable.testBuilder().sqlQuery(String.format(DROP_TABLE, "homogenous_table")).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("Table [%s] dropped", "homogenous_table")).go();
    }

    @Test
    public void testDropOnImmutableSchema() throws Exception {
        boolean dropFailed = false;
        try {
            TestDropTable.test("drop table dfs.`/tmp`");
        }
        catch (UserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("PARSE ERROR"));
            dropFailed = true;
        }
        Assert.assertTrue((String)"Dropping table on immutable schema failed", (boolean)dropFailed);
    }
}

