/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestExampleQueries;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.work.ExecErrorConstants;
import org.apache.drill.exec.work.foreman.SqlUnsupportedException;
import org.apache.drill.exec.work.foreman.UnsupportedDataTypeException;
import org.apache.drill.exec.work.foreman.UnsupportedFunctionException;
import org.apache.drill.exec.work.foreman.UnsupportedRelOperatorException;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDisabledFunctionality
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestExampleQueries.class);

    @Test(expected=UserException.class)
    public void testBooleanORExpression() throws Exception {
        TestDisabledFunctionality.test("select (1 = 1) || (1 > 0) from cp.`tpch/nation.parquet` ");
    }

    @Test(expected=UserException.class)
    public void testBooleanORSelectClause() throws Exception {
        TestDisabledFunctionality.test("select true || true from cp.`tpch/nation.parquet` ");
    }

    @Test(expected=UserException.class)
    public void testBooleanORWhereClause() throws Exception {
        TestDisabledFunctionality.test("select * from cp.`tpch/nation.parquet` where (true || true) ");
    }

    @Test(expected=UserException.class)
    public void testBooleanAND() throws Exception {
        TestDisabledFunctionality.test("select true && true from cp.`tpch/nation.parquet` ");
    }

    private static void throwAsUnsupportedException(UserException ex) throws Exception {
        SqlUnsupportedException.errorClassNameToException((String)ex.getOrCreatePBError(false).getException().getExceptionClass());
        throw ex;
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testDisabledExplainplanForComparisonWithNonscalarSubquery() throws Exception {
        try {
            TestDisabledFunctionality.test("explain plan for select n_name from cp.`tpch/nation.parquet` where n_nationkey = (select r_regionkey from cp.`tpch/region.parquet` where r_regionkey = 1)");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testDisabledComparisonWithNonscalarSubquery() throws Exception {
        try {
            TestDisabledFunctionality.test("select n_name from cp.`tpch/nation.parquet` where n_nationkey = (select r_regionkey from cp.`tpch/region.parquet` where r_regionkey = 1)");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testDisabledIntersect() throws Exception {
        try {
            TestDisabledFunctionality.test("(select n_name as name from cp.`tpch/nation.parquet`) INTERSECT (select r_name as name from cp.`tpch/region.parquet`)");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testDisabledIntersectALL() throws Exception {
        try {
            TestDisabledFunctionality.test("(select n_name as name from cp.`tpch/nation.parquet`) INTERSECT ALL (select r_name as name from cp.`tpch/region.parquet`)");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testDisabledExceptALL() throws Exception {
        try {
            TestDisabledFunctionality.test("(select n_name as name from cp.`tpch/nation.parquet`) EXCEPT ALL (select r_name as name from cp.`tpch/region.parquet`)");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testDisabledExcept() throws Exception {
        try {
            TestDisabledFunctionality.test("(select n_name as name from cp.`tpch/nation.parquet`) EXCEPT (select r_name as name from cp.`tpch/region.parquet`)");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testDisabledNaturalJoin() throws Exception {
        try {
            TestDisabledFunctionality.test("select * from cp.`tpch/nation.parquet` NATURAL JOIN cp.`tpch/region.parquet`");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testDisabledCrossJoin() throws Exception {
        try {
            TestDisabledFunctionality.test("select * from cp.`tpch/nation.parquet` CROSS JOIN cp.`tpch/region.parquet`");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedDataTypeException.class)
    public void testDisabledCastTINYINT() throws Exception {
        try {
            TestDisabledFunctionality.test("select cast(n_name as tinyint) from cp.`tpch/nation.parquet`;");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedDataTypeException.class)
    public void testDisabledCastSMALLINT() throws Exception {
        try {
            TestDisabledFunctionality.test("select cast(n_name as smallint) from cp.`tpch/nation.parquet`;");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedDataTypeException.class)
    public void testDisabledCastREAL() throws Exception {
        try {
            TestDisabledFunctionality.test("select cast(n_name as real) from cp.`tpch/nation.parquet`;");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testDisabledCardinality() throws Exception {
        try {
            TestDisabledFunctionality.test("select cardinality(employee_id) from cp.`employee.json`;");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testImplicitCartesianJoin() throws Exception {
        try {
            TestDisabledFunctionality.test("select a.*, b.user_port from cp.`employee.json` a, sys.drillbits b;");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testNonEqualJoin() throws Exception {
        try {
            TestDisabledFunctionality.test("select a.*, b.user_port from cp.`employee.json` a, sys.drillbits b where a.position_id <> b.user_port;");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testMultipleJoinsWithOneNonEqualJoin() throws Exception {
        try {
            TestDisabledFunctionality.test("select a.last_name, b.n_name, c.r_name from cp.`employee.json` a, cp.`tpch/nation.parquet` b, cp.`tpch/region.parquet` c where a.position_id > b.n_nationKey and b.n_nationKey = c.r_regionkey;");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testLeftOuterJoin() throws Exception {
        try {
            TestDisabledFunctionality.test("select a.lastname, b.n_name from cp.`employee.json` a LEFT JOIN cp.`tpch/nation.parquet` b ON a.position_id > b.n_nationKey;");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testInnerJoin() throws Exception {
        try {
            TestDisabledFunctionality.test("select a.lastname, b.n_name from cp.`employee.json` a INNER JOIN cp.`tpch/nation.parquet` b ON a.position_id > b.n_nationKey;");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testMultipleUnsupportedOperatorations() throws Exception {
        try {
            TestDisabledFunctionality.test("select a.lastname, b.n_name from cp.`employee.json` a, cp.`tpch/nation.parquet` b where b.n_nationkey = (select r_regionkey from cp.`tpch/region.parquet` where r_regionkey = 1)");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testExplainPlanForCartesianJoin() throws Exception {
        try {
            TestDisabledFunctionality.test("explain plan for (select a.lastname, b.n_name from cp.`employee.json` a INNER JOIN cp.`tpch/nation.parquet` b ON a.position_id > b.n_nationKey);");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testExplainPlanOuterJoinWithInequality() throws Exception {
        try {
            TestDisabledFunctionality.test("explain plan for (select a.lastname, b.n_name from cp.`employee.json` a LEFT OUTER JOIN cp.`tpch/nation.parquet` b ON (a.position_id > b.n_nationKey AND a.employee_id = b.n_regionkey));");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedRelOperatorException.class)
    public void testOuterJoinWithInequality() throws Exception {
        try {
            TestDisabledFunctionality.test("select a.lastname, b.n_name from cp.`employee.json` a RIGHT OUTER JOIN cp.`tpch/nation.parquet` b ON (a.position_id > b.n_nationKey AND a.employee_id = b.n_regionkey);");
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testFlattenWithinGroupBy() throws Exception {
        try {
            String root = FileUtils.getResourceAsFile((String)"/store/text/sample.json").toURI().toString();
            String query = String.format("select flatten(j.topping) tt from dfs_test.`%s` j group by flatten(j.topping)", root);
            TestDisabledFunctionality.test(query);
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testFlattenWithinOrderBy() throws Exception {
        try {
            String root = FileUtils.getResourceAsFile((String)"/store/text/sample.json").toURI().toString();
            String query = String.format("select flatten(j.topping) tt from dfs_test.`%s` j order by flatten(j.topping)", root);
            TestDisabledFunctionality.test(query);
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testFlattenWithinAggFunction() throws Exception {
        try {
            String root = FileUtils.getResourceAsFile((String)"/store/text/sample.json").toURI().toString();
            String query = String.format("select count(flatten(j.topping)) tt from dfs_test.`%s` j", root);
            TestDisabledFunctionality.test(query);
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test(expected=UnsupportedFunctionException.class)
    public void testFlattenWithinDistinct() throws Exception {
        try {
            String root = FileUtils.getResourceAsFile((String)"/store/text/sample.json").toURI().toString();
            String query = String.format("select Distinct (flatten(j.topping)) tt from dfs_test.`%s` j", root);
            TestDisabledFunctionality.test(query);
        }
        catch (UserException ex) {
            TestDisabledFunctionality.throwAsUnsupportedException(ex);
            throw ex;
        }
    }

    @Test
    public void testDisableDecimalCasts() throws Exception {
        String query = "select cast('1.2' as decimal(9, 2)) from cp.`employee.json` limit 1";
        TestDisabledFunctionality.errorMsgTestHelper("select cast('1.2' as decimal(9, 2)) from cp.`employee.json` limit 1", ExecErrorConstants.DECIMAL_DISABLE_ERR_MSG);
    }

    @Test
    public void testDisableDecimalFromParquet() throws Exception {
        String query = "select * from cp.`parquet/decimal_dictionary.parquet`";
        TestDisabledFunctionality.errorMsgTestHelper("select * from cp.`parquet/decimal_dictionary.parquet`", ExecErrorConstants.DECIMAL_DISABLE_ERR_MSG);
    }
}

