/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.PlanTestBase;
import org.apache.drill.common.util.TestTools;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCTASPartitionFilter
extends PlanTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestCTASPartitionFilter.class);
    static final String WORKING_PATH = TestTools.getWorkingPath();
    static final String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";

    private static void testExcludeFilter(String query, int expectedNumFiles, String excludedFilterPattern, int expectedRowCount) throws Exception {
        int actualRowCount = TestCTASPartitionFilter.testSql(query);
        Assert.assertEquals((long)expectedRowCount, (long)actualRowCount);
        String numFilesPattern = "numFiles=" + expectedNumFiles;
        TestCTASPartitionFilter.testPlanMatchingPatterns(query, new String[]{numFilesPattern}, new String[]{excludedFilterPattern});
    }

    private static void testIncludeFilter(String query, int expectedNumFiles, String includedFilterPattern, int expectedRowCount) throws Exception {
        int actualRowCount = TestCTASPartitionFilter.testSql(query);
        Assert.assertEquals((long)expectedRowCount, (long)actualRowCount);
        String numFilesPattern = "numFiles=" + expectedNumFiles;
        TestCTASPartitionFilter.testPlanMatchingPatterns(query, new String[]{numFilesPattern, includedFilterPattern}, new String[0]);
    }

    @Test
    public void testDrill3965() throws Exception {
        TestCTASPartitionFilter.test("use dfs_test.tmp");
        TestCTASPartitionFilter.test("create table orders_auto_partition partition by(o_orderpriority) as select * from cp.`tpch/orders.parquet`");
        TestCTASPartitionFilter.test("explain plan for select count(*) from `orders_auto_partition/1_0_1.parquet` where o_orderpriority = '5-LOW'");
    }

    @Test
    public void withDistribution() throws Exception {
        TestCTASPartitionFilter.test("alter session set `planner.slice_target` = 1");
        TestCTASPartitionFilter.test("alter session set `store.partition.hash_distribute` = true");
        TestCTASPartitionFilter.test("use dfs_test.tmp");
        TestCTASPartitionFilter.test(String.format("create table orders_distribution partition by (o_orderpriority) as select * from dfs_test.`%s/multilevel/parquet`", TEST_RES_PATH));
        String query = "select * from orders_distribution where o_orderpriority = '1-URGENT'";
        TestCTASPartitionFilter.testExcludeFilter(query, 1, "Filter", 24);
    }

    @Test
    public void withoutDistribution() throws Exception {
        TestCTASPartitionFilter.test("alter session set `planner.slice_target` = 1");
        TestCTASPartitionFilter.test("alter session set `store.partition.hash_distribute` = false");
        TestCTASPartitionFilter.test("use dfs_test.tmp");
        TestCTASPartitionFilter.test(String.format("create table orders_no_distribution partition by (o_orderpriority) as select * from dfs_test.`%s/multilevel/parquet`", TEST_RES_PATH));
        String query = "select * from orders_no_distribution where o_orderpriority = '1-URGENT'";
        TestCTASPartitionFilter.testExcludeFilter(query, 2, "Filter", 24);
    }

    @Test
    public void testDRILL3410() throws Exception {
        TestCTASPartitionFilter.test("alter session set `planner.slice_target` = 1");
        TestCTASPartitionFilter.test("alter session set `store.partition.hash_distribute` = true");
        TestCTASPartitionFilter.test("use dfs_test.tmp");
        TestCTASPartitionFilter.test(String.format("create table drill_3410 partition by (o_orderpriority) as select * from dfs_test.`%s/multilevel/parquet`", TEST_RES_PATH));
        String query = "select * from drill_3410 where (o_orderpriority = '1-URGENT' and o_orderkey = 10) or (o_orderpriority = '2-HIGH' or o_orderkey = 11)";
        TestCTASPartitionFilter.testIncludeFilter(query, 1, "Filter", 34);
    }

    @Test
    public void testDRILL3414() throws Exception {
        TestCTASPartitionFilter.test("alter session set `planner.slice_target` = 1");
        TestCTASPartitionFilter.test("alter session set `store.partition.hash_distribute` = true");
        TestCTASPartitionFilter.test("use dfs_test.tmp");
        TestCTASPartitionFilter.test(String.format("create table drill_3414 partition by (dir0, dir1) as select * from dfs_test.`%s/multilevel/csv`", TEST_RES_PATH));
        String query = "select * from drill_3414 where (dir0=1994 or dir1='Q1') and (dir0=1995 or dir1='Q2' or columns[0] > 5000)";
        TestCTASPartitionFilter.testIncludeFilter(query, 6, "Filter", 20);
    }

    @Test
    public void testDRILL3414_2() throws Exception {
        TestCTASPartitionFilter.test("alter session set `planner.slice_target` = 1");
        TestCTASPartitionFilter.test("alter session set `store.partition.hash_distribute` = true");
        TestCTASPartitionFilter.test("use dfs_test.tmp");
        TestCTASPartitionFilter.test(String.format("create table drill_3414_2 partition by (dir0, dir1) as select * from dfs_test.`%s/multilevel/csv`", TEST_RES_PATH));
        String query = "select * from drill_3414_2 where (dir0=1994 or dir1='Q1') and (dir0=1995 or dir1='Q2' or columns[0] > 5000) or columns[0] < 3000";
        TestCTASPartitionFilter.testIncludeFilter(query, 1, "Filter", 120);
    }
}

