/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.DrillTestWrapper;
import org.apache.drill.QueryTestUtil;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.parser.ExprLexer;
import org.apache.drill.common.expression.parser.ExprParser;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.util.JsonStringHashMap;
import org.apache.hadoop.io.Text;
import org.junit.Assert;

public class TestBuilder {
    private String query;
    private UserBitShared.QueryType queryType;
    private Boolean ordered;
    private boolean approximateEquality;
    private BufferAllocator allocator;
    protected Map<SchemaPath, TypeProtos.MajorType> baselineTypeMap;
    private String baselineOptionSettingQueries;
    private String testOptionSettingQueries;
    private boolean highPerformanceComparison;
    private Object[] baselineValues;
    protected String[] baselineColumns;
    private List<Map> baselineRecords;
    private int expectedNumBatches = -1;

    public TestBuilder(BufferAllocator allocator) {
        this.allocator = allocator;
        this.reset();
    }

    public TestBuilder(BufferAllocator allocator, String query, UserBitShared.QueryType queryType, Boolean ordered, boolean approximateEquality, Map<SchemaPath, TypeProtos.MajorType> baselineTypeMap, String baselineOptionSettingQueries, String testOptionSettingQueries, boolean highPerformanceComparison, int expectedNumBatches) {
        this(allocator);
        if (ordered == null) {
            throw new RuntimeException("Ordering not set, when using a baseline file or query you must explicitly call the ordered() or unOrdered() method on the " + this.getClass().getSimpleName());
        }
        this.query = query;
        this.queryType = queryType;
        this.ordered = ordered;
        this.approximateEquality = approximateEquality;
        this.baselineTypeMap = baselineTypeMap;
        this.baselineOptionSettingQueries = baselineOptionSettingQueries;
        this.testOptionSettingQueries = testOptionSettingQueries;
        this.highPerformanceComparison = highPerformanceComparison;
        this.expectedNumBatches = expectedNumBatches;
    }

    protected TestBuilder reset() {
        this.query = "";
        this.ordered = null;
        this.approximateEquality = false;
        this.highPerformanceComparison = false;
        this.testOptionSettingQueries = "";
        this.baselineOptionSettingQueries = "";
        this.baselineRecords = null;
        return this;
    }

    public DrillTestWrapper build() throws Exception {
        if (!this.ordered.booleanValue() && this.highPerformanceComparison) {
            throw new Exception("High performance comparison only available for ordered checks, to enforce this restriction, ordered() must be called first.");
        }
        return new DrillTestWrapper(this, this.allocator, this.query, this.queryType, this.baselineOptionSettingQueries, this.testOptionSettingQueries, this.getValidationQueryType(), this.ordered, this.approximateEquality, this.highPerformanceComparison, this.baselineRecords, this.expectedNumBatches);
    }

    public void go() throws Exception {
        this.build().run();
    }

    public TestBuilder sqlQuery(String query) {
        this.query = QueryTestUtil.normalizeQuery(query);
        this.queryType = UserBitShared.QueryType.SQL;
        return this;
    }

    public TestBuilder sqlQuery(String query, Object ... replacements) {
        return this.sqlQuery(String.format(query, replacements));
    }

    public TestBuilder sqlQueryFromFile(String queryFile) throws IOException {
        String query;
        this.query = query = BaseTestQuery.getFile(queryFile);
        this.queryType = UserBitShared.QueryType.SQL;
        return this;
    }

    public TestBuilder physicalPlanFromFile(String queryFile) throws IOException {
        String query;
        this.query = query = BaseTestQuery.getFile(queryFile);
        this.queryType = UserBitShared.QueryType.PHYSICAL;
        return this;
    }

    public TestBuilder ordered() {
        this.ordered = true;
        return this;
    }

    public TestBuilder unOrdered() {
        this.ordered = false;
        return this;
    }

    public TestBuilder highPerformanceComparison() throws Exception {
        this.highPerformanceComparison = true;
        return this;
    }

    public TestBuilder optionSettingQueriesForBaseline(String queries) {
        this.baselineOptionSettingQueries = queries;
        return this;
    }

    public TestBuilder optionSettingQueriesForTestQuery(String queries) {
        this.testOptionSettingQueries = queries;
        return this;
    }

    public TestBuilder approximateEquality() {
        this.approximateEquality = true;
        return this;
    }

    public static SchemaPath parsePath(String path) {
        try {
            ExprLexer lexer = new ExprLexer((CharStream)new ANTLRStringStream(path));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            ExprParser parser = new ExprParser((TokenStream)tokens);
            ExprParser.parse_return ret = parser.parse();
            if (ret.e instanceof SchemaPath) {
                return (SchemaPath)ret.e;
            }
            throw new IllegalStateException("Schema path is not a valid format.");
        }
        catch (RecognitionException e) {
            throw new RuntimeException(e);
        }
    }

    String getValidationQuery() throws Exception {
        throw new RuntimeException("Must provide some kind of baseline, either a baseline file or another query");
    }

    protected UserBitShared.QueryType getValidationQueryType() throws Exception {
        if (this.singleExplicitBaselineRecord()) {
            return null;
        }
        throw new RuntimeException("Must provide some kind of baseline, either a baseline file or another query");
    }

    public JSONTestBuilder jsonBaselineFile(String filePath) {
        return new JSONTestBuilder(filePath, this.allocator, this.query, this.queryType, this.ordered, this.approximateEquality, this.baselineTypeMap, this.baselineOptionSettingQueries, this.testOptionSettingQueries, this.highPerformanceComparison, this.expectedNumBatches);
    }

    public CSVTestBuilder csvBaselineFile(String filePath) {
        return new CSVTestBuilder(filePath, this.allocator, this.query, this.queryType, this.ordered, this.approximateEquality, this.baselineTypeMap, this.baselineOptionSettingQueries, this.testOptionSettingQueries, this.highPerformanceComparison, this.expectedNumBatches);
    }

    public TestBuilder baselineTypes(Map<SchemaPath, TypeProtos.MajorType> baselineTypeMap) {
        this.baselineTypeMap = baselineTypeMap;
        return this;
    }

    boolean typeInfoSet() {
        return this.baselineTypeMap != null;
    }

    public TestBuilder expectsEmptyResultSet() {
        this.unOrdered();
        this.baselineRecords = new ArrayList<Map>();
        return this;
    }

    public TestBuilder expectsNumBatches(int expectedNumBatches) {
        this.expectedNumBatches = expectedNumBatches;
        return this;
    }

    public TestBuilder baselineValues(Object ... baselineValues) {
        if (this.ordered == null) {
            throw new RuntimeException("Ordering not set, before specifying baseline data you must explicitly call the ordered() or unOrdered() method on the " + this.getClass().getSimpleName());
        }
        if (this.baselineRecords == null) {
            this.baselineRecords = new ArrayList<Map>();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int i = 0;
        Assert.assertEquals((String)"Must supply the same number of baseline values as columns.", (long)baselineValues.length, (long)this.baselineColumns.length);
        for (String s : this.baselineColumns) {
            ret.put(s, baselineValues[i]);
            ++i;
        }
        this.baselineRecords.add(ret);
        return this;
    }

    public TestBuilder baselineRecords(List<Map> materializedRecords) {
        this.baselineRecords = materializedRecords;
        return this;
    }

    public TestBuilder baselineColumns(String ... columns) {
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = TestBuilder.parsePath(columns[i]).toExpr();
        }
        this.baselineColumns = columns;
        return this;
    }

    private boolean singleExplicitBaselineRecord() {
        return this.baselineRecords != null;
    }

    public BaselineQueryTestBuilder sqlBaselineQuery(String baselineQuery) {
        return new BaselineQueryTestBuilder(baselineQuery, UserBitShared.QueryType.SQL, this.allocator, this.query, this.queryType, this.ordered, this.approximateEquality, this.baselineTypeMap, this.baselineOptionSettingQueries, this.testOptionSettingQueries, this.highPerformanceComparison, this.expectedNumBatches);
    }

    public BaselineQueryTestBuilder sqlBaselineQueryFromFile(String baselineQueryFilename) throws IOException {
        String baselineQuery = BaseTestQuery.getFile(baselineQueryFilename);
        return new BaselineQueryTestBuilder(baselineQuery, UserBitShared.QueryType.SQL, this.allocator, this.query, this.queryType, this.ordered, this.approximateEquality, this.baselineTypeMap, this.baselineOptionSettingQueries, this.testOptionSettingQueries, this.highPerformanceComparison, this.expectedNumBatches);
    }

    public BaselineQueryTestBuilder physicalPlanBaselineQueryFromFile(String baselinePhysicalPlanPath) throws IOException {
        String baselineQuery = BaseTestQuery.getFile(baselinePhysicalPlanPath);
        return new BaselineQueryTestBuilder(baselineQuery, UserBitShared.QueryType.PHYSICAL, this.allocator, this.query, this.queryType, this.ordered, this.approximateEquality, this.baselineTypeMap, this.baselineOptionSettingQueries, this.testOptionSettingQueries, this.highPerformanceComparison, this.expectedNumBatches);
    }

    private String getDecimalPrecisionScaleInfo(TypeProtos.MajorType type) {
        String precision = "";
        switch (type.getMinorType()) {
            case DECIMAL18: 
            case DECIMAL28SPARSE: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28DENSE: 
            case DECIMAL9: {
                precision = String.format("(%d,%d)", type.getPrecision(), type.getScale());
                break;
            }
        }
        return precision;
    }

    public static JsonStringArrayList listOf(Object ... values) {
        JsonStringArrayList list = new JsonStringArrayList();
        for (Object value : values) {
            if (value instanceof CharSequence) {
                list.add((Object)new Text(value.toString()));
                continue;
            }
            list.add(value);
        }
        return list;
    }

    public static JsonStringHashMap<String, Object> mapOf(Object ... keyValueSequence) {
        Preconditions.checkArgument((keyValueSequence.length % 2 == 0 ? 1 : 0) != 0, (Object)"Length of key value sequence must be even");
        JsonStringHashMap map = new JsonStringHashMap();
        for (int i = 0; i < keyValueSequence.length; i += 2) {
            Object value = keyValueSequence[i + 1];
            if (value instanceof CharSequence) {
                value = new Text(value.toString());
            }
            map.put(String.class.cast(keyValueSequence[i]), value);
        }
        return map;
    }

    public class BaselineQueryTestBuilder
    extends TestBuilder {
        private String baselineQuery;
        private UserBitShared.QueryType baselineQueryType;

        BaselineQueryTestBuilder(String baselineQuery, UserBitShared.QueryType baselineQueryType, BufferAllocator allocator, String query, UserBitShared.QueryType queryType, Boolean ordered, boolean approximateEquality, Map<SchemaPath, TypeProtos.MajorType> baselineTypeMap, String baselineOptionSettingQueries, String testOptionSettingQueries, boolean highPerformanceComparison, int expectedNumBatches) {
            super(allocator, query, queryType, ordered, approximateEquality, baselineTypeMap, baselineOptionSettingQueries, testOptionSettingQueries, highPerformanceComparison, expectedNumBatches);
            this.baselineQuery = baselineQuery;
            this.baselineQueryType = baselineQueryType;
        }

        @Override
        String getValidationQuery() {
            return this.baselineQuery;
        }

        @Override
        protected UserBitShared.QueryType getValidationQueryType() throws Exception {
            return this.baselineQueryType;
        }

        @Override
        boolean typeInfoSet() {
            return true;
        }
    }

    public class JSONTestBuilder
    extends TestBuilder {
        private String baselineFilePath;

        JSONTestBuilder(String baselineFile, BufferAllocator allocator, String query, UserBitShared.QueryType queryType, Boolean ordered, boolean approximateEquality, Map<SchemaPath, TypeProtos.MajorType> baselineTypeMap, String baselineOptionSettingQueries, String testOptionSettingQueries, boolean highPerformanceComparison, int expectedNumBatches) {
            super(allocator, query, queryType, ordered, approximateEquality, baselineTypeMap, baselineOptionSettingQueries, testOptionSettingQueries, highPerformanceComparison, expectedNumBatches);
            this.baselineFilePath = baselineFile;
            this.baselineColumns = new String[]{"*"};
        }

        @Override
        String getValidationQuery() {
            return "select " + Joiner.on((String)", ").join((Object[])this.baselineColumns) + " from cp.`" + this.baselineFilePath + "`";
        }

        @Override
        protected UserBitShared.QueryType getValidationQueryType() throws Exception {
            return UserBitShared.QueryType.SQL;
        }
    }

    public class CSVTestBuilder
    extends TestBuilder {
        private String baselineFilePath;
        private TypeProtos.MajorType[] baselineTypes;

        CSVTestBuilder(String baselineFile, BufferAllocator allocator, String query, UserBitShared.QueryType queryType, Boolean ordered, boolean approximateEquality, Map<SchemaPath, TypeProtos.MajorType> baselineTypeMap, String baselineOptionSettingQueries, String testOptionSettingQueries, boolean highPerformanceComparison, int expectedNumBatches) {
            super(allocator, query, queryType, ordered, approximateEquality, baselineTypeMap, baselineOptionSettingQueries, testOptionSettingQueries, highPerformanceComparison, expectedNumBatches);
            this.baselineFilePath = baselineFile;
        }

        public CSVTestBuilder baselineTypes(TypeProtos.MajorType ... baselineTypes) {
            this.baselineTypes = baselineTypes;
            this.baselineTypeMap = null;
            return this;
        }

        public CSVTestBuilder baselineTypes(TypeProtos.MinorType ... baselineTypes) {
            TypeProtos.MajorType[] majorTypes = new TypeProtos.MajorType[baselineTypes.length];
            int i = 0;
            for (TypeProtos.MinorType minorType : baselineTypes) {
                majorTypes[i] = Types.required((TypeProtos.MinorType)minorType);
                ++i;
            }
            this.baselineTypes = majorTypes;
            this.baselineTypeMap = null;
            return this;
        }

        @Override
        protected TestBuilder reset() {
            super.reset();
            this.baselineTypeMap = null;
            this.baselineTypes = null;
            this.baselineFilePath = null;
            return this;
        }

        @Override
        boolean typeInfoSet() {
            return super.typeInfoSet() || this.baselineTypes != null;
        }

        @Override
        String getValidationQuery() throws Exception {
            if (this.baselineColumns.length == 0) {
                throw new Exception("Baseline CSV files require passing column names, please call the baselineColumns() method on the test builder.");
            }
            if (this.baselineTypes != null) {
                Assert.assertEquals((String)"Must pass the same number of types as column names if types are provided.", (long)this.baselineTypes.length, (long)this.baselineColumns.length);
            }
            Object[] aliasedExpectedColumns = new String[this.baselineColumns.length];
            for (int i = 0; i < this.baselineColumns.length; ++i) {
                TypeProtos.MajorType majorType;
                aliasedExpectedColumns[i] = "columns[" + i + "] ";
                if (this.baselineTypes != null) {
                    majorType = this.baselineTypes[i];
                } else if (this.baselineTypeMap != null) {
                    majorType = (TypeProtos.MajorType)this.baselineTypeMap.get(CSVTestBuilder.parsePath(this.baselineColumns[i]));
                } else {
                    throw new Exception("Type information not set for interpreting csv baseline file.");
                }
                String precision = TestBuilder.this.getDecimalPrecisionScaleInfo(majorType);
                if (majorType.getMinorType() == TypeProtos.MinorType.VARCHAR || majorType.getMinorType() == TypeProtos.MinorType.VARBINARY) {
                    precision = "(65000)";
                }
                aliasedExpectedColumns[i] = "cast(" + (String)aliasedExpectedColumns[i] + " as " + Types.getNameOfMinorType((TypeProtos.MinorType)majorType.getMinorType()) + precision + " ) " + this.baselineColumns[i];
            }
            String query = "select " + Joiner.on((String)", ").join(aliasedExpectedColumns) + " from cp.`" + this.baselineFilePath + "`";
            return query;
        }

        @Override
        protected UserBitShared.QueryType getValidationQueryType() throws Exception {
            return UserBitShared.QueryType.SQL;
        }
    }
}

