/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.exceptions.UserException;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBugFixes
extends BaseTestQuery {
    private static final Logger logger = LoggerFactory.getLogger(TestBugFixes.class);

    @Test
    public void leak1() throws Exception {
        String select = "select count(*) \n    from cp.`tpch/part.parquet` p1, cp.`tpch/part.parquet` p2 \n    where p1.p_name = p2.p_name \n  and p1.p_mfgr = p2.p_mfgr";
        TestBugFixes.test(select);
    }

    @Ignore
    @Test
    public void failingSmoke() throws Exception {
        String select = "select count(*) \n  from (select l.l_orderkey as x, c.c_custkey as y \n  from cp.`tpch/lineitem.parquet` l \n    left outer join cp.`tpch/customer.parquet` c \n      on l.l_orderkey = c.c_custkey) as foo\n  where x < 10000";
        TestBugFixes.test(select);
    }

    @Test
    public void testSysDrillbits() throws Exception {
        TestBugFixes.test("select * from sys.drillbits");
    }

    @Test
    public void testVersionTable() throws Exception {
        TestBugFixes.test("select * from sys.version");
    }

    @Test
    public void DRILL883() throws Exception {
        TestBugFixes.test("select n1.n_regionkey from cp.`tpch/nation.parquet` n1, (select n_nationkey from cp.`tpch/nation.parquet`) as n2 where n1.n_nationkey = n2.n_nationkey");
    }

    @Test
    public void DRILL1061() throws Exception {
        String query = "select foo.mycol.x as COMPLEX_COL from (select convert_from('{ x : [1,2], y : 100 }', 'JSON') as mycol from cp.`tpch/nation.parquet`) as foo(mycol) limit 1";
        TestBugFixes.test(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void DRILL1126() throws Exception {
        try {
            TestBugFixes.test(String.format("alter session set `%s` = true", "planner.enable_decimal_data_type"));
            String query = "select sum(cast(employee_id as decimal(38, 18))), avg(cast(employee_id as decimal(38, 18))) from cp.`employee.json` group by (department_id)";
            TestBugFixes.test(query);
        }
        catch (Throwable throwable) {
            TestBugFixes.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
            throw throwable;
        }
        TestBugFixes.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void Drill3484() throws Exception {
        try {
            TestBugFixes.test("alter SYSTEM set `drill.exec.functions.cast_empty_string_to_null` = true;");
            TestBugFixes.test("select random() from sys.drillbits");
        }
        finally {
            TestBugFixes.test("alter SYSTEM set `drill.exec.functions.cast_empty_string_to_null` = false;");
        }
    }

    @Test(expected=UserException.class)
    public void testDRILL1337_LocalLeftFilterLeftOutJoin() throws Exception {
        try {
            TestBugFixes.test("select count(*) from cp.`tpch/nation.parquet` n left outer join cp.`tpch/region.parquet` r on n.n_regionkey = r.r_regionkey and n.n_nationkey > 10;");
        }
        catch (UserException e) {
            logger.info("***** Test resulted in expected failure: " + e.getMessage());
            throw e;
        }
    }

    @Test
    public void testDRILL1337_LocalRightFilterLeftOutJoin() throws Exception {
        TestBugFixes.test("select * from cp.`tpch/nation.parquet` n left outer join cp.`tpch/region.parquet` r on n.n_regionkey = r.r_regionkey and r.r_name not like '%ASIA' order by r.r_name;");
    }
}

