/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.BaseTestQuery;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAltSortQueries
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestAltSortQueries.class);

    @Test
    public void testOrderBy() throws Exception {
        TestAltSortQueries.test("select R_REGIONKEY from dfs_test.`[WORKING_PATH]/../../sample-data/region.parquet` order by R_REGIONKEY");
    }

    @Test
    public void testOrderBySingleFile() throws Exception {
        TestAltSortQueries.test("select R_REGIONKEY from dfs_test.`[WORKING_PATH]/../../sample-data/regionsSF/` order by R_REGIONKEY");
    }

    @Test
    public void testSelectWithLimit() throws Exception {
        TestAltSortQueries.test("select employee_id,  first_name, last_name from cp.`employee.json` order by employee_id limit 5 ");
    }

    @Test
    public void testSelectWithLimitOffset() throws Exception {
        TestAltSortQueries.testBuilder().sqlQuery("select employee_id,  first_name, last_name from cp.`employee.json` order by employee_id limit 5 offset 10 ").ordered().csvBaselineFile("sort/testSelectWithLimitOffset.tsv").baselineColumns("employee_id", "first_name", "last_name").build().run();
    }

    @Test
    public void testJoinWithLimit() throws Exception {
        TestAltSortQueries.test("SELECT\n  nations.N_NAME,\n  regions.R_NAME\nFROM\n  dfs_test.`[WORKING_PATH]/../../sample-data/nation.parquet` nations\nJOIN\n  dfs_test.`[WORKING_PATH]/../../sample-data/region.parquet` regions\n  on nations.N_REGIONKEY = regions.R_REGIONKEY order by regions.R_NAME, nations.N_NAME  limit 5");
    }
}

