/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.memory.TopLevelAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.testing.Controls;
import org.apache.drill.exec.testing.ControlsInjectionUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestAllocationException
extends BaseTestQuery {
    private static final String SINGLE_MODE = "ALTER SESSION SET `planner.disable_exchanges` = true";

    private void testWithException(String fileName) throws Exception {
        TestAllocationException.test(SINGLE_MODE);
        String controls = Controls.newBuilder().addException(TopLevelAllocator.class, "child.buffer", OutOfMemoryRuntimeException.class, 200, 1).build();
        ControlsInjectionUtil.setControls(client, controls);
        String query = TestAllocationException.getFile(fileName);
        try {
            TestAllocationException.test(query);
            Assert.fail((String)"The query should have failed!");
        }
        catch (UserException uex) {
            UserBitShared.DrillPBError error = uex.getOrCreatePBError(false);
            Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.RESOURCE, (Object)error.getErrorType());
            Assert.assertTrue((String)"Error message isn't related to memory error", (boolean)uex.getMessage().contains("One or more nodes ran out of memory while executing the query."));
        }
    }

    @Test
    public void testWithOOM() throws Exception {
        this.testWithException("queries/tpch/01.sql");
    }
}

