/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.util.TestTools;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAggNullable
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestAggNullable.class);
    static final String WORKING_PATH = TestTools.getWorkingPath();
    static final String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";

    private static void enableAggr(boolean ha, boolean sa) throws Exception {
        TestAggNullable.test(String.format("alter session set `planner.enable_hashagg` = %s", ha ? "true" : "false"));
        TestAggNullable.test(String.format("alter session set `planner.enable_streamagg` = %s", sa ? "true" : "false"));
        TestAggNullable.test("alter session set `planner.slice_target` = 1");
    }

    @Test
    public void testHashAggNullableColumns() throws Exception {
        String query1 = String.format("select t2.b2 from dfs_test.`%s/jsoninput/nullable2.json` t2  group by t2.b2", TEST_RES_PATH);
        String query2 = String.format("select t2.a2, t2.b2 from dfs_test.`%s/jsoninput/nullable2.json` t2  group by t2.a2, t2.b2", TEST_RES_PATH);
        int expectedRecordCount = 2;
        TestAggNullable.enableAggr(true, false);
        int actualRecordCount = TestAggNullable.testSql(query1);
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        expectedRecordCount = 4;
        actualRecordCount = TestAggNullable.testSql(query2);
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }

    @Test
    public void testStreamAggNullableColumns() throws Exception {
        String query1 = String.format("select t2.b2 from dfs_test.`%s/jsoninput/nullable2.json` t2  group by t2.b2", TEST_RES_PATH);
        String query2 = String.format("select t2.a2, t2.b2 from dfs_test.`%s/jsoninput/nullable2.json` t2  group by t2.a2, t2.b2", TEST_RES_PATH);
        int expectedRecordCount = 2;
        TestAggNullable.enableAggr(false, true);
        int actualRecordCount = TestAggNullable.testSql(query1);
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
        expectedRecordCount = 4;
        actualRecordCount = TestAggNullable.testSql(query2);
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }
}

