/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;

public abstract class SingleRowListener
implements UserResultsListener {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicInteger nRows = new AtomicInteger(0);
    private UserBitShared.QueryResult.QueryState queryState = null;
    private final List<UserBitShared.DrillPBError> errorList = new LinkedList<UserBitShared.DrillPBError>();
    private Exception exception = null;

    public void queryIdArrived(UserBitShared.QueryId queryId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submissionFailed(UserException ex) {
        this.exception = ex;
        List<UserBitShared.DrillPBError> list = this.errorList;
        synchronized (list) {
            this.errorList.add(ex.getOrCreatePBError(false));
        }
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
        this.queryState = state;
        try {
            this.cleanup();
        }
        finally {
            this.latch.countDown();
        }
    }

    public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
        UserBitShared.QueryData queryData = result.getHeader();
        if (result.hasData()) {
            int nRows = this.nRows.addAndGet(queryData.getRowCount());
            if (nRows > 1) {
                throw new IllegalStateException("Expected exactly one row, but got " + nRows);
            }
            this.rowArrived(result);
        }
        result.release();
    }

    public UserBitShared.QueryResult.QueryState getQueryState() {
        return this.queryState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserBitShared.DrillPBError> getErrorList() {
        List<UserBitShared.DrillPBError> list = this.errorList;
        synchronized (list) {
            return Collections.unmodifiableList(this.errorList);
        }
    }

    protected abstract void rowArrived(QueryDataBatch var1);

    public void waitForCompletion() throws Exception {
        this.latch.await();
        if (this.exception != null) {
            throw new RuntimeException("Query submission failed", this.exception);
        }
    }

    public void cleanup() {
    }
}

