/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.client.PrintingResultsListener;
import org.apache.drill.exec.client.QuerySubmitter;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.server.RemoteServiceSet;

public class QueryTestUtil {
    private QueryTestUtil() {
    }

    public static DrillClient createClient(DrillConfig drillConfig, RemoteServiceSet remoteServiceSet, int maxWidth, Properties props) throws RpcException {
        DrillClient drillClient = new DrillClient(drillConfig, remoteServiceSet.getCoordinator());
        drillClient.connect(props);
        List results = drillClient.runQuery(UserBitShared.QueryType.SQL, String.format("alter session set `%s` = %d", "planner.width.max_per_node", maxWidth));
        for (QueryDataBatch queryDataBatch : results) {
            queryDataBatch.release();
        }
        return drillClient;
    }

    public static String normalizeQuery(String query) {
        if (query.contains("${WORKING_PATH}")) {
            return query.replaceAll(Pattern.quote("${WORKING_PATH}"), Matcher.quoteReplacement(TestTools.getWorkingPath()));
        }
        if (query.contains("[WORKING_PATH]")) {
            return query.replaceAll(Pattern.quote("[WORKING_PATH]"), Matcher.quoteReplacement(TestTools.getWorkingPath()));
        }
        return query;
    }

    public static int testRunAndPrint(DrillClient drillClient, UserBitShared.QueryType type, String queryString) throws Exception {
        String query = QueryTestUtil.normalizeQuery(queryString);
        PrintingResultsListener resultListener = new PrintingResultsListener(drillClient.getConfig(), QuerySubmitter.Format.TSV, 15);
        drillClient.runQuery(type, query, (UserResultsListener)resultListener);
        return resultListener.await();
    }

    public static void test(DrillClient drillClient, String queryString) throws Exception {
        String[] queries;
        String query = QueryTestUtil.normalizeQuery(queryString);
        for (String q : queries = query.split(";")) {
            String trimmedQuery = q.trim();
            if (trimmedQuery.isEmpty()) continue;
            QueryTestUtil.testRunAndPrint(drillClient, UserBitShared.QueryType.SQL, trimmedQuery);
        }
    }

    public static void test(DrillClient drillClient, String query, Object ... args) throws Exception {
        QueryTestUtil.test(drillClient, String.format(query, args));
    }

    public static void testWithListener(DrillClient drillClient, UserBitShared.QueryType type, String queryString, UserResultsListener resultListener) {
        String query = QueryTestUtil.normalizeQuery(queryString);
        drillClient.runQuery(type, query, resultListener);
    }
}

