/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.apache.calcite.jdbc.SimpleCalciteSchema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.planner.sql.DrillSqlWorker;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.QueryOptionManager;
import org.apache.drill.exec.server.options.SessionOptionManager;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.local.LocalPStoreProvider;
import org.apache.drill.exec.testing.ExecutionControls;
import org.junit.Rule;
import org.junit.rules.TestRule;

public class PlanningBase
extends ExecTest {
    @Rule
    public final TestRule TIMEOUT = TestTools.getTimeoutRule((int)10000);
    @Mocked
    DrillbitContext dbContext;
    private final DrillConfig config = DrillConfig.create();
    @Mocked
    QueryContext context;
    BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.config);

    protected void testSqlPlanFromFile(String file) throws Exception {
        this.testSqlPlan(PlanningBase.getFile(file));
    }

    protected void testSqlPlan(String sqlCommands) throws Exception {
        String[] sqlStrings = sqlCommands.split(";");
        final LocalPStoreProvider provider = new LocalPStoreProvider(this.config);
        provider.start();
        final SystemOptionManager systemOptions = new SystemOptionManager(this.config, (PStoreProvider)provider);
        systemOptions.init();
        UserSession userSession = UserSession.Builder.newBuilder().withOptionManager((OptionManager)systemOptions).build();
        SessionOptionManager sessionOptions = (SessionOptionManager)userSession.getOptions();
        final QueryOptionManager queryOptions = new QueryOptionManager((OptionManager)sessionOptions);
        final ExecutionControls executionControls = new ExecutionControls((OptionManager)queryOptions, CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        new NonStrictExpectations(){
            {
                PlanningBase.this.dbContext.getMetrics();
                result = new MetricRegistry();
                PlanningBase.this.dbContext.getAllocator();
                result = PlanningBase.this.allocator;
                PlanningBase.this.dbContext.getConfig();
                result = PlanningBase.this.config;
                PlanningBase.this.dbContext.getOptionManager();
                result = systemOptions;
                PlanningBase.this.dbContext.getPersistentStoreProvider();
                result = provider;
            }
        };
        final StoragePluginRegistry registry = new StoragePluginRegistry(this.dbContext);
        registry.init();
        final FunctionImplementationRegistry functionRegistry = new FunctionImplementationRegistry(this.config);
        final DrillOperatorTable table = new DrillOperatorTable(functionRegistry);
        final SchemaPlus root = SimpleCalciteSchema.createRootSchema((boolean)false);
        registry.getSchemaFactory().registerSchemas(SchemaConfig.newBuilder((String)"foo", (QueryContext)this.context).build(), root);
        new NonStrictExpectations(){
            {
                PlanningBase.this.context.getNewDefaultSchema();
                result = root;
                PlanningBase.this.context.getStorage();
                result = registry;
                PlanningBase.this.context.getFunctionRegistry();
                result = functionRegistry;
                PlanningBase.this.context.getSession();
                result = UserSession.Builder.newBuilder().setSupportComplexTypes(true).build();
                PlanningBase.this.context.getCurrentEndpoint();
                result = CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
                PlanningBase.this.context.getActiveEndpoints();
                result = ImmutableList.of((Object)CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
                PlanningBase.this.context.getPlannerSettings();
                result = new PlannerSettings((OptionManager)queryOptions, functionRegistry);
                PlanningBase.this.context.getOptions();
                result = queryOptions;
                PlanningBase.this.context.getConfig();
                result = PlanningBase.this.config;
                PlanningBase.this.context.getDrillOperatorTable();
                result = table;
                PlanningBase.this.context.getAllocator();
                result = PlanningBase.this.allocator;
                PlanningBase.this.context.getExecutionControls();
                result = executionControls;
            }
        };
        for (String sql : sqlStrings) {
            if (sql.trim().isEmpty()) continue;
            DrillSqlWorker worker = new DrillSqlWorker(this.context);
            PhysicalPlan physicalPlan = worker.getPlan(sql);
        }
    }

    protected static String getFile(String resource) throws IOException {
        URL url = Resources.getResource((String)resource);
        if (url == null) {
            throw new IOException(String.format("Unable to find path %s.", resource));
        }
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }
}

