/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.QueryTestUtil;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;

public class PlanTestBase
extends BaseTestQuery {
    protected static final String OPTIQ_FORMAT = "text";
    protected static final String JSON_FORMAT = "json";
    protected static final String EXPECTED_NOT_FOUND = "Did not find expected pattern in plan: ";
    protected static final String UNEXPECTED_FOUND = "Found unwanted pattern in plan: ";

    public static void testPhysicalPlan(String sql, String ... expectedSubstrs) throws Exception {
        sql = "EXPLAIN PLAN for " + QueryTestUtil.normalizeQuery(sql);
        String planStr = PlanTestBase.getPlanInString(sql, JSON_FORMAT);
        for (String colNames : expectedSubstrs) {
            Assert.assertTrue((String)String.format("Unable to find expected string %s in plan: %s!", colNames, planStr), (boolean)planStr.contains(colNames));
        }
    }

    public static void testPlanMatchingPatterns(String query, String[] expectedPatterns, String[] excludedPatterns) throws Exception {
        Matcher m;
        Pattern p;
        String plan = PlanTestBase.getPlanInString("EXPLAIN PLAN for " + QueryTestUtil.normalizeQuery(query), OPTIQ_FORMAT);
        if (expectedPatterns != null) {
            for (String s : expectedPatterns) {
                p = Pattern.compile(s);
                m = p.matcher(plan);
                Assert.assertTrue((String)(EXPECTED_NOT_FOUND + s), (boolean)m.find());
            }
        }
        if (excludedPatterns != null) {
            for (String s : excludedPatterns) {
                p = Pattern.compile(s);
                m = p.matcher(plan);
                Assert.assertFalse((String)(UNEXPECTED_FOUND + s), (boolean)m.find());
            }
        }
    }

    public static void testPlanSubstrPatterns(String query, String[] expectedPatterns, String[] excludedPatterns) throws Exception {
        String plan = PlanTestBase.getPlanInString("EXPLAIN PLAN for " + QueryTestUtil.normalizeQuery(query), OPTIQ_FORMAT);
        if (expectedPatterns != null) {
            for (String s : expectedPatterns) {
                Assert.assertTrue((String)(EXPECTED_NOT_FOUND + s), (boolean)plan.contains(s));
            }
        }
        if (excludedPatterns != null) {
            for (String s : excludedPatterns) {
                Assert.assertFalse((String)(UNEXPECTED_FOUND + s), (boolean)plan.contains(s));
            }
        }
    }

    public static void testPlanOneExpectedPatternOneExcluded(String query, String expectedPattern, String excludedPattern) throws Exception {
        PlanTestBase.testPlanMatchingPatterns(query, new String[]{expectedPattern}, new String[]{excludedPattern});
    }

    public static void testPlanOneExpectedPattern(String query, String expectedPattern) throws Exception {
        PlanTestBase.testPlanMatchingPatterns(query, new String[]{expectedPattern}, new String[0]);
    }

    public static void testPlanOneExcludedPattern(String query, String excludedPattern) throws Exception {
        PlanTestBase.testPlanMatchingPatterns(query, new String[0], new String[]{excludedPattern});
    }

    public static void testRelLogicalJoinOrder(String sql, String ... expectedSubstrs) throws Exception {
        String planStr = PlanTestBase.getDrillRelPlanInString(sql, SqlExplainLevel.EXPPLAN_ATTRIBUTES, SqlExplain.Depth.LOGICAL);
        String prefixJoinOrder = PlanTestBase.getLogicalPrefixJoinOrderFromPlan(planStr);
        System.out.println(" prefix Join order = \n" + prefixJoinOrder);
        for (String substr : expectedSubstrs) {
            Assert.assertTrue((String)String.format("Expected string %s is not in the prefixJoinOrder %s!", substr, prefixJoinOrder), (boolean)prefixJoinOrder.contains(substr));
        }
    }

    public static void testRelPhysicalJoinOrder(String sql, String ... expectedSubstrs) throws Exception {
        String planStr = PlanTestBase.getDrillRelPlanInString(sql, SqlExplainLevel.EXPPLAN_ATTRIBUTES, SqlExplain.Depth.PHYSICAL);
        String prefixJoinOrder = PlanTestBase.getPhysicalPrefixJoinOrderFromPlan(planStr);
        System.out.println(" prefix Join order = \n" + prefixJoinOrder);
        for (String substr : expectedSubstrs) {
            Assert.assertTrue((String)String.format("Expected string %s is not in the prefixJoinOrder %s!", substr, prefixJoinOrder), (boolean)prefixJoinOrder.contains(substr));
        }
    }

    public static void testRelPhysicalPlanLevDigest(String sql, String ... expectedSubstrs) throws Exception {
        String planStr = PlanTestBase.getDrillRelPlanInString(sql, SqlExplainLevel.DIGEST_ATTRIBUTES, SqlExplain.Depth.PHYSICAL);
        for (String substr : expectedSubstrs) {
            Assert.assertTrue((boolean)planStr.contains(substr));
        }
    }

    public static void testRelLogicalPlanLevDigest(String sql, String ... expectedSubstrs) throws Exception {
        String planStr = PlanTestBase.getDrillRelPlanInString(sql, SqlExplainLevel.DIGEST_ATTRIBUTES, SqlExplain.Depth.LOGICAL);
        for (String substr : expectedSubstrs) {
            Assert.assertTrue((boolean)planStr.contains(substr));
        }
    }

    public static void testRelPhysicalPlanLevExplain(String sql, String ... expectedSubstrs) throws Exception {
        String planStr = PlanTestBase.getDrillRelPlanInString(sql, SqlExplainLevel.EXPPLAN_ATTRIBUTES, SqlExplain.Depth.PHYSICAL);
        for (String substr : expectedSubstrs) {
            Assert.assertTrue((boolean)planStr.contains(substr));
        }
    }

    public static void testRelLogicalPlanLevExplain(String sql, String ... expectedSubstrs) throws Exception {
        String planStr = PlanTestBase.getDrillRelPlanInString(sql, SqlExplainLevel.EXPPLAN_ATTRIBUTES, SqlExplain.Depth.LOGICAL);
        for (String substr : expectedSubstrs) {
            Assert.assertTrue((boolean)planStr.contains(substr));
        }
    }

    private static String getDrillRelPlanInString(String sql, SqlExplainLevel level, SqlExplain.Depth depth) throws Exception {
        String levelStr = " ";
        String depthStr = " ";
        switch (level) {
            case NO_ATTRIBUTES: {
                levelStr = "EXCLUDING ATTRIBUTES";
                break;
            }
            case EXPPLAN_ATTRIBUTES: {
                levelStr = "INCLUDING ATTRIBUTES";
                break;
            }
            case ALL_ATTRIBUTES: {
                levelStr = "INCLUDING ALL ATTRIBUTES";
                break;
            }
        }
        switch (depth) {
            case TYPE: {
                depthStr = "WITH TYPE";
                break;
            }
            case LOGICAL: {
                depthStr = "WITHOUT IMPLEMENTATION";
                break;
            }
            case PHYSICAL: {
                depthStr = "WITH IMPLEMENTATION";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        sql = "EXPLAIN PLAN " + levelStr + " " + depthStr + "  for " + QueryTestUtil.normalizeQuery(sql);
        return PlanTestBase.getPlanInString(sql, OPTIQ_FORMAT);
    }

    protected static String getPlanInString(String sql, String columnName) throws Exception {
        List<QueryDataBatch> results = PlanTestBase.testSqlWithResults(sql);
        RecordBatchLoader loader = new RecordBatchLoader(PlanTestBase.getDrillbitContext().getAllocator());
        StringBuilder builder = new StringBuilder();
        for (QueryDataBatch b : results) {
            VectorWrapper vw;
            if (!b.hasData()) continue;
            loader.load(b.getHeader().getDef(), b.getData());
            try {
                vw = loader.getValueAccessorById(NullableVarCharVector.class, loader.getValueVectorId(SchemaPath.getSimplePath((String)columnName)).getFieldIds());
            }
            catch (Throwable t) {
                throw new Exception("Looks like you did not provide an explain plan query, please add EXPLAIN PLAN FOR to the beginning of your query.");
            }
            System.out.println(vw.getValueVector().getField().toExpr());
            ValueVector vv = vw.getValueVector();
            for (int i = 0; i < vv.getAccessor().getValueCount(); ++i) {
                Object o = vv.getAccessor().getObject(i);
                builder.append(o);
                System.out.println(vv.getAccessor().getObject(i));
            }
            loader.clear();
            b.release();
        }
        return builder.toString();
    }

    private static String getLogicalPrefixJoinOrderFromPlan(String plan) {
        return PlanTestBase.getPrefixJoinOrderFromPlan(plan, "DrillJoinRel", "DrillScanRel");
    }

    private static String getPhysicalPrefixJoinOrderFromPlan(String plan) {
        return PlanTestBase.getPrefixJoinOrderFromPlan(plan, "JoinPrel", "ScanPrel");
    }

    private static String getPrefixJoinOrderFromPlan(String plan, String joinKeyWord, String scanKeyWord) {
        StringBuilder builder = new StringBuilder();
        String[] planLines = plan.split("\n");
        int cnt = 0;
        Stack<Integer> s = new Stack<Integer>();
        for (String line : planLines) {
            if (line.trim().isEmpty()) continue;
            if (line.contains(joinKeyWord)) {
                builder.append(Strings.repeat((String)" ", (int)(2 * s.size())));
                builder.append(joinKeyWord + "\n");
                s.push(++cnt);
                cnt = 0;
                continue;
            }
            if (!line.contains(scanKeyWord)) continue;
            builder.append(Strings.repeat((String)" ", (int)(2 * s.size())));
            builder.append(line.trim() + "\n");
            if (++cnt != 2) continue;
            cnt = (Integer)s.pop();
        }
        return builder.toString();
    }
}

