/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestBuilder;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.HyperVectorValueIterator;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.HyperVectorWrapper;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.hadoop.io.Text;
import org.codehaus.jackson.node.BinaryNode;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillTestWrapper {
    static final Logger logger = LoggerFactory.getLogger(BaseTestQuery.class);
    private static boolean VERBOSE_DEBUG = false;
    public static final int EXPECTED_BATCH_COUNT_NOT_SET = -1;
    private TestBuilder testBuilder;
    private String query;
    private UserBitShared.QueryType queryType;
    private UserBitShared.QueryType baselineQueryType;
    private boolean ordered;
    private boolean approximateEquality;
    private BufferAllocator allocator;
    private String baselineOptionSettingQueries;
    private String testOptionSettingQueries;
    private boolean highPerformanceComparison;
    private List<Map> baselineRecords;
    private int expectedNumBatches;

    public DrillTestWrapper(TestBuilder testBuilder, BufferAllocator allocator, String query, UserBitShared.QueryType queryType, String baselineOptionSettingQueries, String testOptionSettingQueries, UserBitShared.QueryType baselineQueryType, boolean ordered, boolean approximateEquality, boolean highPerformanceComparison, List<Map> baselineRecords, int expectedNumBatches) {
        this.testBuilder = testBuilder;
        this.allocator = allocator;
        this.query = query;
        this.queryType = queryType;
        this.baselineQueryType = baselineQueryType;
        this.ordered = ordered;
        this.approximateEquality = approximateEquality;
        this.baselineOptionSettingQueries = baselineOptionSettingQueries;
        this.testOptionSettingQueries = testOptionSettingQueries;
        this.highPerformanceComparison = highPerformanceComparison;
        this.baselineRecords = baselineRecords;
        this.expectedNumBatches = expectedNumBatches;
    }

    public void run() throws Exception {
        if (this.ordered) {
            this.compareOrderedResults();
        } else {
            this.compareUnorderedResults();
        }
    }

    private BufferAllocator getAllocator() {
        return this.allocator;
    }

    private void compareHyperVectors(Map<String, HyperVectorValueIterator> expectedRecords, Map<String, HyperVectorValueIterator> actualRecords) throws Exception {
        for (String s : expectedRecords.keySet()) {
            Assert.assertNotNull((String)("Expected column '" + s + "' not found."), (Object)actualRecords.get(s));
            Assert.assertEquals((long)expectedRecords.get(s).getTotalRecords(), (long)actualRecords.get(s).getTotalRecords());
            HyperVectorValueIterator expectedValues = expectedRecords.get(s);
            HyperVectorValueIterator actualValues = actualRecords.get(s);
            int i = 0;
            while (expectedValues.hasNext()) {
                this.compareValuesErrorOnMismatch(expectedValues.next(), actualValues.next(), i, s);
                ++i;
            }
        }
        for (HyperVectorValueIterator hvi : expectedRecords.values()) {
            for (ValueVector vv : hvi.getHyperVector().getValueVectors()) {
                vv.clear();
            }
        }
        for (HyperVectorValueIterator hvi : actualRecords.values()) {
            for (ValueVector vv : hvi.getHyperVector().getValueVectors()) {
                vv.clear();
            }
        }
    }

    private void compareMergedVectors(Map<String, List> expectedRecords, Map<String, List> actualRecords) throws Exception {
        for (String s : actualRecords.keySet()) {
            Assert.assertNotNull((String)("Unexpected extra column " + s + " returned by query."), (Object)expectedRecords.get(s));
            Assert.assertEquals((String)"Incorrect number of rows returned by query.", (long)expectedRecords.get(s).size(), (long)actualRecords.get(s).size());
            List expectedValues = expectedRecords.get(s);
            List actualValues = actualRecords.get(s);
            Assert.assertEquals((String)"Different number of records returned", (long)expectedValues.size(), (long)actualValues.size());
            for (int i = 0; i < expectedValues.size(); ++i) {
                this.compareValuesErrorOnMismatch(expectedValues.get(i), actualValues.get(i), i, s);
            }
        }
        if (actualRecords.size() < expectedRecords.size()) {
            throw new Exception(this.findMissingColumns(expectedRecords.keySet(), actualRecords.keySet()));
        }
    }

    private Map<String, HyperVectorValueIterator> addToHyperVectorMap(List<QueryDataBatch> records, RecordBatchLoader loader, BatchSchema schema) throws SchemaChangeException, UnsupportedEncodingException {
        HashMap<String, HyperVectorValueIterator> combinedVectors = new HashMap<String, HyperVectorValueIterator>();
        long totalRecords = 0L;
        int size = records.size();
        for (int i = 0; i < size; ++i) {
            QueryDataBatch batch = records.get(i);
            loader = new RecordBatchLoader(this.getAllocator());
            loader.load(batch.getHeader().getDef(), batch.getData());
            logger.debug("reading batch with " + loader.getRecordCount() + " rows, total read so far " + totalRecords);
            totalRecords += (long)loader.getRecordCount();
            for (VectorWrapper w : loader) {
                String field = w.getField().toExpr();
                if (!combinedVectors.containsKey(field)) {
                    MaterializedField mf = w.getField();
                    ValueVector[] vvList = (ValueVector[])Array.newInstance(mf.getValueClass(), 1);
                    vvList[0] = w.getValueVector();
                    combinedVectors.put(mf.getPath().toExpr(), new HyperVectorValueIterator(mf, new HyperVectorWrapper(mf, vvList)));
                    continue;
                }
                ((HyperVectorValueIterator)combinedVectors.get(field)).getHyperVector().addVector(w.getValueVector());
            }
        }
        for (HyperVectorValueIterator hvi : combinedVectors.values()) {
            hvi.determineTotalSize();
        }
        return combinedVectors;
    }

    private Map<String, List> addToCombinedVectorResults(List<QueryDataBatch> records, RecordBatchLoader loader, BatchSchema schema) throws SchemaChangeException, UnsupportedEncodingException {
        HashMap<String, List> combinedVectors = new HashMap<String, List>();
        long totalRecords = 0L;
        int size = records.size();
        for (int i = 0; i < size; ++i) {
            QueryDataBatch batch = records.get(0);
            loader.load(batch.getHeader().getDef(), batch.getData());
            if (schema == null) {
                schema = loader.getSchema();
                for (MaterializedField mf : schema) {
                    combinedVectors.put(mf.getPath().toExpr(), new ArrayList());
                }
            }
            logger.debug("reading batch with " + loader.getRecordCount() + " rows, total read so far " + totalRecords);
            totalRecords += (long)loader.getRecordCount();
            for (VectorWrapper w : loader) {
                String field = w.getField().toExpr();
                for (int j = 0; j < loader.getRecordCount(); ++j) {
                    Object obj = w.getValueVector().getAccessor().getObject(j);
                    if (obj != null) {
                        if (obj instanceof Text) {
                            if ((obj = obj.toString()).equals("")) {
                                System.out.println(w.getField());
                            }
                        } else if (obj instanceof byte[]) {
                            obj = new BinaryNode((byte[])obj).asText();
                        }
                    }
                    ((List)combinedVectors.get(field)).add(obj);
                }
            }
            records.remove(0);
            batch.release();
            loader.clear();
        }
        return combinedVectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compareUnorderedResults() throws Exception {
        RecordBatchLoader loader = new RecordBatchLoader(this.getAllocator());
        BatchSchema schema = null;
        List<QueryDataBatch> actual = Collections.EMPTY_LIST;
        List<QueryDataBatch> expected = Collections.EMPTY_LIST;
        ArrayList<Map> expectedRecords = new ArrayList();
        ArrayList<Map> actualRecords = new ArrayList<Map>();
        try {
            BaseTestQuery.test(this.testOptionSettingQueries);
            actual = BaseTestQuery.testRunAndReturn(this.queryType, this.query);
            this.checkNumBatches(actual);
            this.addTypeInfoIfMissing(actual.get(0), this.testBuilder);
            this.addToMaterializedResults(actualRecords, actual, loader, schema);
            if (this.baselineRecords == null) {
                BaseTestQuery.test(this.baselineOptionSettingQueries);
                expected = BaseTestQuery.testRunAndReturn(this.baselineQueryType, this.testBuilder.getValidationQuery());
                this.addToMaterializedResults(expectedRecords, expected, loader, schema);
            } else {
                expectedRecords = this.baselineRecords;
            }
            this.compareResults(expectedRecords, actualRecords);
        }
        catch (Throwable throwable) {
            this.cleanupBatches(actual, expected);
            throw throwable;
        }
        this.cleanupBatches(actual, expected);
    }

    protected void compareOrderedResults() throws Exception {
        if (this.highPerformanceComparison) {
            if (this.baselineQueryType == null) {
                throw new Exception("Cannot do a high performance comparison without using a baseline file");
            }
            this.compareResultsHyperVector();
        } else {
            this.compareMergedOnHeapVectors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compareMergedOnHeapVectors() throws Exception {
        RecordBatchLoader loader = new RecordBatchLoader(this.getAllocator());
        BatchSchema schema = null;
        List<QueryDataBatch> actual = Collections.EMPTY_LIST;
        ArrayList<QueryDataBatch> expected = Collections.EMPTY_LIST;
        try {
            HashMap<String, List> expectedSuperVectors;
            BaseTestQuery.test(this.testOptionSettingQueries);
            actual = BaseTestQuery.testRunAndReturn(this.queryType, this.query);
            this.checkNumBatches(actual);
            this.addTypeInfoIfMissing(actual.get(0), this.testBuilder);
            Map<String, List> actualSuperVectors = this.addToCombinedVectorResults(actual, loader, schema);
            if (this.baselineRecords == null) {
                BaseTestQuery.test(this.baselineOptionSettingQueries);
                expected = BaseTestQuery.testRunAndReturn(this.baselineQueryType, this.testBuilder.getValidationQuery());
                expectedSuperVectors = this.addToCombinedVectorResults(expected, loader, schema);
            } else {
                expectedSuperVectors = new HashMap();
                expected = new ArrayList();
                for (String s : this.baselineRecords.get(0).keySet()) {
                    expectedSuperVectors.put(s, new ArrayList());
                }
                for (Map m : this.baselineRecords) {
                    for (String s : m.keySet()) {
                        ((List)expectedSuperVectors.get(s)).add(m.get(s));
                    }
                }
            }
            this.compareMergedVectors(expectedSuperVectors, actualSuperVectors);
        }
        catch (Throwable throwable) {
            this.cleanupBatches(expected, actual);
            throw throwable;
        }
        this.cleanupBatches(expected, actual);
    }

    public void compareResultsHyperVector() throws Exception {
        RecordBatchLoader loader = new RecordBatchLoader(this.getAllocator());
        BatchSchema schema = null;
        BaseTestQuery.test(this.testOptionSettingQueries);
        List<QueryDataBatch> results = BaseTestQuery.testRunAndReturn(this.queryType, this.query);
        this.checkNumBatches(results);
        this.addTypeInfoIfMissing(results.get(0), this.testBuilder);
        Map<String, HyperVectorValueIterator> actualSuperVectors = this.addToHyperVectorMap(results, loader, schema);
        BaseTestQuery.test(this.baselineOptionSettingQueries);
        List<QueryDataBatch> expected = BaseTestQuery.testRunAndReturn(this.baselineQueryType, this.testBuilder.getValidationQuery());
        Map<String, HyperVectorValueIterator> expectedSuperVectors = this.addToHyperVectorMap(expected, loader, schema);
        this.compareHyperVectors(expectedSuperVectors, actualSuperVectors);
        this.cleanupBatches(results, expected);
    }

    private void checkNumBatches(List<QueryDataBatch> results) {
        if (this.expectedNumBatches != -1) {
            int actualNumBatches = results.size();
            Assert.assertEquals((String)String.format("Expected %d batches but query returned %d non empty batch(es)%n", this.expectedNumBatches, actualNumBatches), (long)this.expectedNumBatches, (long)actualNumBatches);
        }
    }

    private void addTypeInfoIfMissing(QueryDataBatch batch, TestBuilder testBuilder) {
        if (!testBuilder.typeInfoSet()) {
            Map<SchemaPath, TypeProtos.MajorType> typeMap = this.getTypeMapFromBatch(batch);
            testBuilder.baselineTypes(typeMap);
        }
    }

    private Map<SchemaPath, TypeProtos.MajorType> getTypeMapFromBatch(QueryDataBatch batch) {
        HashMap<SchemaPath, TypeProtos.MajorType> typeMap = new HashMap<SchemaPath, TypeProtos.MajorType>();
        for (int i = 0; i < batch.getHeader().getDef().getFieldCount(); ++i) {
            typeMap.put(MaterializedField.create((UserBitShared.SerializedField)batch.getHeader().getDef().getField(i)).getPath(), batch.getHeader().getDef().getField(i).getMajorType());
        }
        return typeMap;
    }

    private void cleanupBatches(List<QueryDataBatch> ... results) {
        for (List<QueryDataBatch> resultList : results) {
            for (QueryDataBatch result : resultList) {
                result.release();
            }
        }
    }

    protected void addToMaterializedResults(List<Map> materializedRecords, List<QueryDataBatch> records, RecordBatchLoader loader, BatchSchema schema) throws SchemaChangeException, UnsupportedEncodingException {
        long totalRecords = 0L;
        int size = records.size();
        for (int i = 0; i < size; ++i) {
            QueryDataBatch batch = records.get(0);
            loader.load(batch.getHeader().getDef(), batch.getData());
            if (schema == null) {
                schema = loader.getSchema();
            }
            logger.debug("reading batch with " + loader.getRecordCount() + " rows, total read so far " + totalRecords);
            totalRecords += (long)loader.getRecordCount();
            for (int j = 0; j < loader.getRecordCount(); ++j) {
                HashMap<String, Object> record = new HashMap<String, Object>();
                for (VectorWrapper w : loader) {
                    Object obj = w.getValueVector().getAccessor().getObject(j);
                    if (obj != null) {
                        if (obj instanceof Text) {
                            if ((obj = obj.toString()).equals("")) {
                                System.out.println(w.getField());
                            }
                        } else if (obj instanceof byte[]) {
                            obj = new String((byte[])obj, "UTF-8");
                        }
                        record.put(w.getField().toExpr(), obj);
                    }
                    record.put(w.getField().toExpr(), obj);
                }
                materializedRecords.add(record);
            }
            records.remove(0);
            batch.release();
            loader.clear();
        }
    }

    public boolean compareValuesErrorOnMismatch(Object expected, Object actual, int counter, String column) throws Exception {
        if (this.compareValues(expected, actual, counter, column)) {
            return true;
        }
        if (expected == null) {
            throw new Exception("at position " + counter + " column '" + column + "' mismatched values, expected: null " + "but received " + actual + "(" + actual.getClass().getSimpleName() + ")");
        }
        if (actual == null) {
            throw new Exception("unexpected null at position " + counter + " column '" + column + "' should have been:  " + expected);
        }
        if (actual instanceof byte[]) {
            throw new Exception("at position " + counter + " column '" + column + "' mismatched values, expected: " + new String((byte[])expected, "UTF-8") + " but received " + new String((byte[])actual, "UTF-8"));
        }
        if (!expected.equals(actual)) {
            throw new Exception("at position " + counter + " column '" + column + "' mismatched values, expected: " + expected + "(" + expected.getClass().getSimpleName() + ") but received " + actual + "(" + actual.getClass().getSimpleName() + ")");
        }
        return true;
    }

    public boolean compareValues(Object expected, Object actual, int counter, String column) throws Exception {
        if (expected == null) {
            if (actual == null) {
                if (VERBOSE_DEBUG) {
                    logger.debug("(1) at position " + counter + " column '" + column + "' matched value:  " + expected);
                }
                return true;
            }
            return false;
        }
        if (actual == null) {
            return false;
        }
        if (actual instanceof byte[]) {
            if (!Arrays.equals((byte[])expected, (byte[])actual)) {
                return false;
            }
            if (VERBOSE_DEBUG) {
                logger.debug("at position " + counter + " column '" + column + "' matched value " + new String((byte[])expected, "UTF-8"));
            }
            return true;
        }
        if (!expected.equals(actual)) {
            return false;
        }
        if (VERBOSE_DEBUG) {
            logger.debug("at position " + counter + " column '" + column + "' matched value:  " + expected);
        }
        return true;
    }

    private void compareResults(List<Map> expectedRecords, List<Map> actualRecords) throws Exception {
        Assert.assertEquals((String)"Different number of records returned", (long)expectedRecords.size(), (long)actualRecords.size());
        String missing = "";
        int i = 0;
        int counter = 0;
        for (Map expectedRecord : expectedRecords) {
            i = 0;
            boolean found = false;
            block1: for (Map actualRecord : actualRecords) {
                for (String s : actualRecord.keySet()) {
                    if (!expectedRecord.containsKey(s)) {
                        throw new Exception("Unexpected column '" + s + "' returned by query.");
                    }
                    if (this.compareValues(expectedRecord.get(s), actualRecord.get(s), counter, s)) continue;
                    ++i;
                    continue block1;
                }
                if (actualRecord.size() < expectedRecord.size()) {
                    throw new Exception(this.findMissingColumns(expectedRecord.keySet(), actualRecord.keySet()));
                }
                found = true;
                break;
            }
            if (!found) {
                StringBuilder sb = new StringBuilder();
                for (int expectedRecordDisplayCount = 0; expectedRecordDisplayCount < 10 && expectedRecordDisplayCount < expectedRecords.size(); ++expectedRecordDisplayCount) {
                    sb.append(this.printRecord(expectedRecords.get(expectedRecordDisplayCount)));
                }
                String expectedRecordExamples = sb.toString();
                sb.setLength(0);
                for (int actualRecordDisplayCount = 0; actualRecordDisplayCount < 10 && actualRecordDisplayCount < actualRecords.size(); ++actualRecordDisplayCount) {
                    sb.append(this.printRecord(actualRecords.get(actualRecordDisplayCount)));
                }
                String actualRecordExamples = sb.toString();
                throw new Exception(String.format("After matching %d records, did not find expected record in result set: %s\n\nSome examples of expected records:%s\n\n Some examples of records returned by the test query:%s", counter, this.printRecord(expectedRecord), expectedRecordExamples, actualRecordExamples));
            }
            actualRecords.remove(i);
            ++counter;
        }
        logger.debug(missing);
        System.out.println(missing);
        Assert.assertEquals((long)0L, (long)actualRecords.size());
    }

    private String findMissingColumns(Set<String> expected, Set<String> actual) {
        String missingCols = "";
        for (String colName : expected) {
            if (actual.contains(colName)) continue;
            missingCols = missingCols + colName + ", ";
        }
        return "Expected column(s) " + missingCols + " not found in result set.";
    }

    private String printRecord(Map<String, Object> record) {
        String ret = "";
        for (String s : record.keySet()) {
            ret = ret + s + " : " + record.get(s) + ", ";
        }
        return ret + "\n";
    }
}

