/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.QueryTestUtil;
import org.apache.drill.TestBuilder;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.rpc.user.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.util.TestUtilities;
import org.apache.drill.exec.util.VectorUtil;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTestQuery
extends ExecTest {
    private static final Logger logger = LoggerFactory.getLogger(BaseTestQuery.class);
    protected static final String TEMP_SCHEMA = "dfs_test.tmp";
    private static final String ENABLE_FULL_CACHE = "drill.exec.test.use-full-cache";
    private static final int MAX_WIDTH_PER_NODE = 2;
    private static final Properties TEST_CONFIGURATIONS = new Properties(){
        {
            this.put("drill.exec.sys.store.provider.local.write", "false");
            this.put("drill.exec.http.enabled", "false");
        }
    };
    public final TestRule resetWatcher = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            try {
                BaseTestQuery.resetClientAndBit();
            }
            catch (Exception e1) {
                throw new RuntimeException("Failure while resetting client.", e1);
            }
        }
    };
    protected static DrillClient client;
    protected static Drillbit[] bits;
    protected static RemoteServiceSet serviceSet;
    protected static DrillConfig config;
    protected static BufferAllocator allocator;
    private static int drillbitCount;
    private static String dfsTestTmpSchemaLocation;
    private int[] columnWidths = new int[]{8};

    @BeforeClass
    public static void setupDefaultTestCluster() throws Exception {
        config = DrillConfig.create((Properties)TEST_CONFIGURATIONS);
        BaseTestQuery.openClient();
    }

    protected static void updateTestCluster(int newDrillbitCount, DrillConfig newConfig) {
        Preconditions.checkArgument((newDrillbitCount > 0 ? 1 : 0) != 0, (Object)"Number of Drillbits must be at least one");
        if (drillbitCount != newDrillbitCount || config != null) {
            try {
                BaseTestQuery.closeClient();
                drillbitCount = newDrillbitCount;
                if (newConfig != null) {
                    config = newConfig;
                }
                BaseTestQuery.openClient();
            }
            catch (Exception e) {
                throw new RuntimeException("Failure while updating the test Drillbit cluster.", e);
            }
        }
    }

    protected static DrillbitContext getDrillbitContext() {
        Preconditions.checkState((bits != null && bits[0] != null ? 1 : 0) != 0, (Object)"Drillbits are not setup.");
        return bits[0].getContext();
    }

    protected static Properties cloneDefaultTestConfigProperties() {
        Properties props = new Properties();
        for (String propName : TEST_CONFIGURATIONS.stringPropertyNames()) {
            props.put(propName, TEST_CONFIGURATIONS.getProperty(propName));
        }
        return props;
    }

    protected static String getDfsTestTmpSchemaLocation() {
        return dfsTestTmpSchemaLocation;
    }

    private static void resetClientAndBit() throws Exception {
        BaseTestQuery.closeClient();
        BaseTestQuery.openClient();
    }

    private static void openClient() throws Exception {
        allocator = RootAllocatorFactory.newRoot((DrillConfig)config);
        serviceSet = config.hasPath(ENABLE_FULL_CACHE) && config.getBoolean(ENABLE_FULL_CACHE) ? RemoteServiceSet.getServiceSetWithFullCache((DrillConfig)config, (BufferAllocator)allocator) : RemoteServiceSet.getLocalServiceSet();
        dfsTestTmpSchemaLocation = TestUtilities.createTempDir();
        bits = new Drillbit[drillbitCount];
        for (int i = 0; i < drillbitCount; ++i) {
            BaseTestQuery.bits[i] = new Drillbit(config, serviceSet);
            bits[i].run();
            StoragePluginRegistry pluginRegistry = bits[i].getContext().getStorage();
            TestUtilities.updateDfsTestTmpSchemaLocation((StoragePluginRegistry)pluginRegistry, (String)dfsTestTmpSchemaLocation);
            TestUtilities.makeDfsTmpSchemaImmutable((StoragePluginRegistry)pluginRegistry);
        }
        client = QueryTestUtil.createClient(config, serviceSet, 2, null);
    }

    public static void updateClient(Properties properties) throws Exception {
        Preconditions.checkState((bits != null && bits[0] != null ? 1 : 0) != 0, (Object)"Drillbits are not setup.");
        if (client != null) {
            client.close();
            client = null;
        }
        client = QueryTestUtil.createClient(config, serviceSet, 2, properties);
    }

    public static void updateClient(String user) throws Exception {
        BaseTestQuery.updateClient(user, null);
    }

    public static void updateClient(String user, String password) throws Exception {
        Properties props = new Properties();
        props.setProperty("user", user);
        if (password != null) {
            props.setProperty("password", password);
        }
        BaseTestQuery.updateClient(props);
    }

    protected static BufferAllocator getAllocator() {
        return allocator;
    }

    public static TestBuilder newTest() {
        return BaseTestQuery.testBuilder();
    }

    public static TestBuilder testBuilder() {
        return new TestBuilder(allocator);
    }

    @AfterClass
    public static void closeClient() throws IOException {
        if (client != null) {
            client.close();
        }
        if (bits != null) {
            for (Drillbit bit : bits) {
                if (bit == null) continue;
                bit.close();
            }
        }
        if (serviceSet != null) {
            serviceSet.close();
        }
        if (allocator != null) {
            allocator.close();
        }
    }

    @AfterClass
    public static void resetDrillbitCount() {
        drillbitCount = 1;
    }

    protected static void runSQL(String sql) throws Exception {
        SilentListener listener = new SilentListener();
        BaseTestQuery.testWithListener(UserBitShared.QueryType.SQL, sql, listener);
        listener.waitForCompletion();
    }

    protected static List<QueryDataBatch> testSqlWithResults(String sql) throws Exception {
        return BaseTestQuery.testRunAndReturn(UserBitShared.QueryType.SQL, sql);
    }

    protected static List<QueryDataBatch> testLogicalWithResults(String logical) throws Exception {
        return BaseTestQuery.testRunAndReturn(UserBitShared.QueryType.LOGICAL, logical);
    }

    protected static List<QueryDataBatch> testPhysicalWithResults(String physical) throws Exception {
        return BaseTestQuery.testRunAndReturn(UserBitShared.QueryType.PHYSICAL, physical);
    }

    public static List<QueryDataBatch> testRunAndReturn(UserBitShared.QueryType type, String query) throws Exception {
        query = QueryTestUtil.normalizeQuery(query);
        return client.runQuery(type, query);
    }

    public static int testRunAndPrint(UserBitShared.QueryType type, String query) throws Exception {
        return QueryTestUtil.testRunAndPrint(client, type, query);
    }

    protected static void testWithListener(UserBitShared.QueryType type, String query, UserResultsListener resultListener) {
        QueryTestUtil.testWithListener(client, type, query, resultListener);
    }

    public static void testNoResult(String query, Object ... args) throws Exception {
        BaseTestQuery.testNoResult(1, query, args);
    }

    protected static void testNoResult(int interation, String query, Object ... args) throws Exception {
        query = String.format(query, args);
        logger.debug("Running query:\n--------------\n" + query);
        for (int i = 0; i < interation; ++i) {
            List results = client.runQuery(UserBitShared.QueryType.SQL, query);
            for (QueryDataBatch queryDataBatch : results) {
                queryDataBatch.release();
            }
        }
    }

    public static void test(String query, Object ... args) throws Exception {
        QueryTestUtil.test(client, String.format(query, args));
    }

    public static void test(String query) throws Exception {
        QueryTestUtil.test(client, query);
    }

    protected static int testLogical(String query) throws Exception {
        return BaseTestQuery.testRunAndPrint(UserBitShared.QueryType.LOGICAL, query);
    }

    protected static int testPhysical(String query) throws Exception {
        return BaseTestQuery.testRunAndPrint(UserBitShared.QueryType.PHYSICAL, query);
    }

    protected static int testSql(String query) throws Exception {
        return BaseTestQuery.testRunAndPrint(UserBitShared.QueryType.SQL, query);
    }

    protected static void testPhysicalFromFile(String file) throws Exception {
        BaseTestQuery.testPhysical(BaseTestQuery.getFile(file));
    }

    protected static List<QueryDataBatch> testPhysicalFromFileWithResults(String file) throws Exception {
        return BaseTestQuery.testRunAndReturn(UserBitShared.QueryType.PHYSICAL, BaseTestQuery.getFile(file));
    }

    protected static void testLogicalFromFile(String file) throws Exception {
        BaseTestQuery.testLogical(BaseTestQuery.getFile(file));
    }

    protected static void testSqlFromFile(String file) throws Exception {
        BaseTestQuery.test(BaseTestQuery.getFile(file));
    }

    protected static void errorMsgTestHelper(String testSqlQuery, String expectedErrorMsg) throws Exception {
        UserException expException = null;
        try {
            BaseTestQuery.test(testSqlQuery);
        }
        catch (UserException ex) {
            expException = ex;
        }
        Assert.assertNotNull((String)"Expected a UserException", (Object)((Object)expException));
        Assert.assertThat((Object)expException.getMessage(), (Matcher)StringContains.containsString((String)expectedErrorMsg));
    }

    protected static void parseErrorHelper(String testSqlQuery) throws Exception {
        BaseTestQuery.errorMsgTestHelper(testSqlQuery, UserBitShared.DrillPBError.ErrorType.PARSE.name());
    }

    public static String getFile(String resource) throws IOException {
        URL url = Resources.getResource((String)resource);
        if (url == null) {
            throw new IOException(String.format("Unable to find path %s.", resource));
        }
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public static String getPhysicalFileFromResource(String resource) throws IOException {
        File file = File.createTempFile("tempfile", ".txt");
        file.deleteOnExit();
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.write(BaseTestQuery.getFile(resource));
        printWriter.close();
        return file.getPath();
    }

    public static String getTempDir(String dirName) {
        File dir = Files.createTempDir();
        dir.deleteOnExit();
        return dir.getAbsolutePath() + File.separator + dirName;
    }

    protected static void setSessionOption(String option, String value) {
        try {
            BaseTestQuery.runSQL(String.format("alter session set `%s` = %s", option, value));
        }
        catch (Exception e) {
            Assert.fail((String)String.format("Failed to set session option `%s` = %s, Error: %s", option, value, e.toString()));
        }
    }

    protected void setColumnWidth(int columnWidth) {
        this.columnWidths = new int[]{columnWidth};
    }

    protected void setColumnWidths(int[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    protected int printResult(List<QueryDataBatch> results) throws SchemaChangeException {
        int rowCount = 0;
        RecordBatchLoader loader = new RecordBatchLoader(BaseTestQuery.getAllocator());
        for (QueryDataBatch result : results) {
            rowCount += result.getHeader().getRowCount();
            loader.load(result.getHeader().getDef(), result.getData());
            if (loader.getRecordCount() <= 0) continue;
            VectorUtil.showVectorAccessibleContent((VectorAccessible)loader, (int[])this.columnWidths);
            loader.clear();
            result.release();
        }
        System.out.println("Total record count: " + rowCount);
        return rowCount;
    }

    protected static String getResultString(List<QueryDataBatch> results, String delimiter) throws SchemaChangeException {
        StringBuilder formattedResults = new StringBuilder();
        boolean includeHeader = true;
        RecordBatchLoader loader = new RecordBatchLoader(BaseTestQuery.getAllocator());
        for (QueryDataBatch result : results) {
            loader.load(result.getHeader().getDef(), result.getData());
            if (loader.getRecordCount() <= 0) continue;
            VectorUtil.appendVectorAccessibleContent((VectorAccessible)loader, (StringBuilder)formattedResults, (String)delimiter, (boolean)includeHeader);
            if (!includeHeader) {
                includeHeader = false;
            }
            loader.clear();
            result.release();
        }
        return formattedResults.toString();
    }

    static {
        drillbitCount = 1;
    }

    public static class SilentListener
    implements UserResultsListener {
        private volatile UserException exception;
        private final AtomicInteger count = new AtomicInteger();
        private final CountDownLatch latch = new CountDownLatch(1);

        public void submissionFailed(UserException ex) {
            this.exception = ex;
            System.out.println("Query failed: " + ex.getMessage());
            this.latch.countDown();
        }

        public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
            System.out.println("Query completed successfully with row count: " + this.count.get());
            this.latch.countDown();
        }

        public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
            int rows = result.getHeader().getRowCount();
            if (result.getData() != null) {
                this.count.addAndGet(rows);
            }
            result.release();
        }

        public void queryIdArrived(UserBitShared.QueryId queryId) {
        }

        public int waitForCompletion() throws Exception {
            this.latch.await();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.count.get();
        }
    }
}

