/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression.parser;

import java.io.IOException;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.drill.common.expression.ExpressionStringBuilder;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.parser.ExprLexer;
import org.apache.drill.common.expression.parser.ExprParser;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.test.DrillTest;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTest
extends DrillTest {
    private static final Logger logger = LoggerFactory.getLogger(TreeTest.class);

    @Test
    public void escapeStringLiteral() throws Exception {
        String expr = "func(`identifier`, '\\\\d+', 0, 'fjds')";
        this.testExpressionParsing(expr);
    }

    @Test
    public void escapeQuotedIdentifier() throws Exception {
        String expr = "`a\\\\b` + `c'd`";
        this.testExpressionParsing(expr);
    }

    @Test
    public void testIfWithCase() throws Exception {
        this.testExpressionParsing("if ($F1) then case when (_MAP.R_NAME = 'AFRICA') then 2 else 4 end else if(4==3) then 1 else if(x==3) then 7 else (if(2==1) then 6 else 4 end) end");
    }

    @Test
    public void testAdd() throws Exception {
        this.testExpressionParsing("2+2");
    }

    @Test
    public void testIf() throws Exception {
        this.testExpressionParsing("if ('blue.red') then 'orange' else if (false) then 1 else 0 end");
    }

    @Test
    public void testQuotedIdentifier() throws Exception {
        this.testExpressionParsing("`hello friend`.`goodbye`");
    }

    @Test
    public void testSpecialQuoted() throws Exception {
        this.testExpressionParsing("`*0` + `*` ");
    }

    @Test
    public void testQuotedIdentifier2() throws Exception {
        this.testExpressionParsing("`hello friend`.goodbye");
    }

    @Test
    public void testComplexIdentifier() throws Exception {
        this.testExpressionParsing("goodbye[4].`hello`");
    }

    @Test
    public void testCastToBooleanExpr() throws Exception {
        this.testExpressionParsing("cast( (cast( (`bool_col` ) as VARCHAR(100) ) ) as BIT )");
    }

    private LogicalExpression parseExpression(String expr) throws RecognitionException, IOException {
        ExprLexer lexer = new ExprLexer((CharStream)new ANTLRStringStream(expr));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExprParser parser = new ExprParser((TokenStream)tokens);
        ExprParser.parse_return ret = parser.parse();
        return ret.e;
    }

    private String serializeExpression(LogicalExpression expr) {
        ExpressionStringBuilder b = new ExpressionStringBuilder();
        StringBuilder sb = new StringBuilder();
        expr.accept((ExprVisitor)b, (Object)sb);
        return sb.toString();
    }

    private void testExpressionParsing(String expr) throws RecognitionException, IOException {
        logger.debug("-----" + expr + "-----");
        LogicalExpression e = this.parseExpression(expr);
        String newStringExpr = this.serializeExpression(e);
        logger.debug(newStringExpr);
        LogicalExpression e2 = this.parseExpression(newStringExpr);
    }
}

