/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.scanner;

import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.scanner.RunTimeScan;
import org.apache.drill.common.scanner.persistence.AnnotatedClassDescriptor;
import org.apache.drill.common.scanner.persistence.AnnotationDescriptor;
import org.apache.drill.common.scanner.persistence.AttributeDescriptor;
import org.apache.drill.common.scanner.persistence.ChildClassDescriptor;
import org.apache.drill.common.scanner.persistence.FieldDescriptor;
import org.apache.drill.common.scanner.persistence.ParentClassDescriptor;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.adapters.JavassistAdapter;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.AbstractScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassPathScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathScanner.class);
    private static final JavassistAdapter METADATA_ADAPTER = new JavassistAdapter();
    private static final String IMPLEMENTATIONS_SCAN_PACKAGES = "drill.classpath.scanning.packages";
    private static final String IMPLEMENTATIONS_SCAN_CLASSES = "drill.classpath.scanning.base.classes";
    private static final String IMPLEMENTATIONS_SCAN_ANNOTATIONS = "drill.classpath.scanning.annotations";
    private static final String IMPLEMENTATIONS_SCAN_CACHE = "drill.classpath.scanning.cache.enabled";

    static Set<URL> getMarkedPaths() {
        return ClassPathScanner.forResource("drill-module.conf", true);
    }

    public static Collection<URL> getConfigURLs() {
        return ClassPathScanner.forResource("drill-module.conf", false);
    }

    public static Set<URL> forResource(String resourcePathname, boolean returnRootPathname) {
        logger.debug("Scanning classpath for resources with pathname \"{}\".", (Object)resourcePathname);
        HashSet resultUrlSet = Sets.newHashSet();
        ClassLoader classLoader = ClassPathScanner.class.getClassLoader();
        try {
            Enumeration<URL> resourceUrls = classLoader.getResources(resourcePathname);
            while (resourceUrls.hasMoreElements()) {
                URL resourceUrl = resourceUrls.nextElement();
                logger.trace("- found a(n) {} at {}.", (Object)resourcePathname, (Object)resourceUrl);
                int index = resourceUrl.toExternalForm().lastIndexOf(resourcePathname);
                if (index != -1 && returnRootPathname) {
                    URL classpathRootUrl = new URL(resourceUrl.toExternalForm().substring(0, index));
                    resultUrlSet.add(classpathRootUrl);
                    logger.debug("- collected resource's classpath root URL {}.", (Object)classpathRootUrl);
                    continue;
                }
                resultUrlSet.add(resourceUrl);
                logger.debug("- collected resource URL {}.", (Object)resourceUrl);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error scanning for resources named " + resourcePathname, e);
        }
        return resultUrlSet;
    }

    static List<String> getPackagePrefixes(DrillConfig config) {
        return config.getStringList(IMPLEMENTATIONS_SCAN_PACKAGES);
    }

    static List<String> getScannedBaseClasses(DrillConfig config) {
        return config.getStringList(IMPLEMENTATIONS_SCAN_CLASSES);
    }

    static List<String> getScannedAnnotations(DrillConfig config) {
        if (config.hasPath(IMPLEMENTATIONS_SCAN_ANNOTATIONS)) {
            return config.getStringList(IMPLEMENTATIONS_SCAN_ANNOTATIONS);
        }
        return Collections.emptyList();
    }

    static boolean isScanBuildTimeCacheEnabled(DrillConfig config) {
        if (config.hasPath(IMPLEMENTATIONS_SCAN_CACHE)) {
            return config.getBoolean(IMPLEMENTATIONS_SCAN_CACHE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScanResult scan(Collection<URL> pathsToScan, Collection<String> packagePrefixes, Collection<String> scannedClasses, Collection<String> scannedAnnotations, ScanResult parentResult) {
        ScanResult scanResult;
        Stopwatch watch = new Stopwatch().start();
        try {
            AnnotationScanner annotationScanner = new AnnotationScanner(scannedAnnotations);
            SubTypesScanner subTypesScanner = new SubTypesScanner(parentResult.getImplementations());
            if (packagePrefixes.size() > 0) {
                FilterBuilder filter = new FilterBuilder();
                for (String prefix : packagePrefixes) {
                    filter.include(FilterBuilder.prefix((String)prefix));
                }
                ConfigurationBuilder conf = new ConfigurationBuilder().setUrls(pathsToScan).setMetadataAdapter((MetadataAdapter)METADATA_ADAPTER).filterInputsBy((Predicate)filter).setScanners(new Scanner[]{annotationScanner, subTypesScanner});
                new Reflections((Configuration)conf);
            }
            ArrayList<ParentClassDescriptor> implementations = new ArrayList<ParentClassDescriptor>();
            for (String baseTypeName : scannedClasses) {
                implementations.add(new ParentClassDescriptor(baseTypeName, new ArrayList<ChildClassDescriptor>(subTypesScanner.getChildrenOf(baseTypeName))));
            }
            List<AnnotatedClassDescriptor> annotated = annotationScanner.getAnnotatedClasses();
            ClassPathScanner.verifyClassUnicity(annotated);
            scanResult = new ScanResult(packagePrefixes, scannedClasses, scannedAnnotations, annotated, implementations);
        }
        catch (Throwable throwable) {
            logger.info(String.format("Scanning packages %s in locations %s took %dms", packagePrefixes, pathsToScan, watch.elapsed(TimeUnit.MILLISECONDS)));
            throw throwable;
        }
        logger.info(String.format("Scanning packages %s in locations %s took %dms", packagePrefixes, pathsToScan, watch.elapsed(TimeUnit.MILLISECONDS)));
        return scanResult;
    }

    private static void verifyClassUnicity(List<AnnotatedClassDescriptor> annotatedClasses) {
        HashSet<String> scanned = new HashSet<String>();
        for (AnnotatedClassDescriptor annotated : annotatedClasses) {
            if (scanned.add(annotated.getClassName())) continue;
            throw new RuntimeException("BUG: " + annotated.getClassName() + " scanned twice");
        }
    }

    static ScanResult emptyResult() {
        return new ScanResult(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static ScanResult fromPrescan(DrillConfig config) {
        return RunTimeScan.fromPrescan(config);
    }

    private static final class AnnotationScanner
    extends AbstractScanner {
        private final List<AnnotatedClassDescriptor> functions = new ArrayList<AnnotatedClassDescriptor>();
        private final Set<String> annotationsToScan;

        AnnotationScanner(Collection<String> annotationsToScan) {
            this.annotationsToScan = Collections.unmodifiableSet(new HashSet<String>(annotationsToScan));
        }

        public List<AnnotatedClassDescriptor> getAnnotatedClasses() {
            return Collections.unmodifiableList(this.functions);
        }

        public void scan(Object cls) {
            ClassFile classFile = (ClassFile)cls;
            AnnotationsAttribute annotations = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
            if (annotations != null) {
                boolean isAnnotated = false;
                for (Annotation a : annotations.getAnnotations()) {
                    if (!this.annotationsToScan.contains(a.getTypeName())) continue;
                    isAnnotated = true;
                }
                if (isAnnotated) {
                    List<AnnotationDescriptor> classAnnotations = this.getAnnotationDescriptors(annotations);
                    List classFields = classFile.getFields();
                    ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>(classFields.size());
                    for (FieldInfo field : classFields) {
                        String fieldName = field.getName();
                        AnnotationsAttribute fieldAnnotations = (AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations");
                        fieldDescriptors.add(new FieldDescriptor(fieldName, field.getDescriptor(), this.getAnnotationDescriptors(fieldAnnotations)));
                    }
                    this.functions.add(new AnnotatedClassDescriptor(classFile.getName(), classAnnotations, fieldDescriptors));
                }
            }
        }

        private List<AnnotationDescriptor> getAnnotationDescriptors(AnnotationsAttribute annotationsAttr) {
            ArrayList<AnnotationDescriptor> annotationDescriptors = new ArrayList<AnnotationDescriptor>(annotationsAttr.numAnnotations());
            for (Annotation annotation : annotationsAttr.getAnnotations()) {
                Set memberNames = annotation.getMemberNames();
                ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
                if (memberNames != null) {
                    for (String name : memberNames) {
                        MemberValue memberValue = annotation.getMemberValue(name);
                        ArrayList<String> values = new ArrayList<String>();
                        memberValue.accept((MemberValueVisitor)new ListingMemberValueVisitor(values));
                        attributes.add(new AttributeDescriptor(name, values));
                    }
                }
                annotationDescriptors.add(new AnnotationDescriptor(annotation.getTypeName(), attributes));
            }
            return annotationDescriptors;
        }
    }

    private static class ListingMemberValueVisitor
    implements MemberValueVisitor {
        private final List<String> values;

        private ListingMemberValueVisitor(List<String> values) {
            this.values = values;
        }

        public void visitStringMemberValue(StringMemberValue node) {
            this.values.add(node.getValue());
        }

        public void visitShortMemberValue(ShortMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        public void visitLongMemberValue(LongMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        public void visitIntegerMemberValue(IntegerMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        public void visitFloatMemberValue(FloatMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        public void visitEnumMemberValue(EnumMemberValue node) {
            this.values.add(node.getValue());
        }

        public void visitDoubleMemberValue(DoubleMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        public void visitClassMemberValue(ClassMemberValue node) {
            this.values.add(node.getValue());
        }

        public void visitCharMemberValue(CharMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        public void visitByteMemberValue(ByteMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        public void visitBooleanMemberValue(BooleanMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }

        public void visitArrayMemberValue(ArrayMemberValue node) {
            MemberValue[] nestedValues;
            for (MemberValue v : nestedValues = node.getValue()) {
                v.accept((MemberValueVisitor)new ListingMemberValueVisitor(this.values){

                    @Override
                    public void visitArrayMemberValue(ArrayMemberValue node) {
                        ListingMemberValueVisitor.this.values.add(Arrays.toString(node.getValue()));
                    }
                });
            }
        }

        public void visitAnnotationMemberValue(AnnotationMemberValue node) {
            this.values.add(String.valueOf(node.getValue()));
        }
    }

    private static class SubTypesScanner
    extends AbstractScanner {
        private Multimap<String, ChildClassDescriptor> parentsChildren = HashMultimap.create();
        private Multimap<String, ChildClassDescriptor> children = HashMultimap.create();

        public SubTypesScanner(List<ParentClassDescriptor> parentImplementations) {
            for (ParentClassDescriptor parentClassDescriptor : parentImplementations) {
                this.parentsChildren.putAll((Object)parentClassDescriptor.getName(), parentClassDescriptor.getChildren());
            }
        }

        public void scan(Object cls) {
            ClassFile classFile = (ClassFile)cls;
            String className = classFile.getName();
            String superclass = classFile.getSuperclass();
            boolean isAbstract = (classFile.getAccessFlags() & 0x600) != 0;
            ChildClassDescriptor scannedClass = new ChildClassDescriptor(className, isAbstract);
            if (!superclass.equals(Object.class.getName())) {
                this.children.put((Object)superclass, (Object)scannedClass);
            }
            for (String anInterface : classFile.getInterfaces()) {
                this.children.put((Object)anInterface, (Object)scannedClass);
            }
        }

        public Set<ChildClassDescriptor> getChildrenOf(String name) {
            HashSet<ChildClassDescriptor> result = new HashSet<ChildClassDescriptor>();
            Collection scannedChildren = this.children.get((Object)name);
            for (ChildClassDescriptor child : scannedChildren) {
                result.add(child);
            }
            ArrayList allChildren = new ArrayList();
            allChildren.addAll(scannedChildren);
            allChildren.addAll(this.parentsChildren.get((Object)name));
            for (ChildClassDescriptor child : allChildren) {
                result.addAll(this.getChildrenOf(child.getName()));
            }
            return result;
        }
    }
}

