/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.drill.common.graph.GraphVisitor;
import org.apache.drill.common.logical.ValidationError;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogicalOperatorBase
implements LogicalOperator {
    static final Logger logger = LoggerFactory.getLogger(LogicalOperatorBase.class);
    private List<LogicalOperator> children = new ArrayList<LogicalOperator>();
    private String memo;

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public void setupAndValidate(List<LogicalOperator> operators, Collection<ValidationError> errors) {
    }

    @Override
    public LogicalOperator.NodeBuilder nodeBuilder() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void accept(GraphVisitor<LogicalOperator> visitor) {
        if (visitor.enter(this)) {
            visitor.leave(this);
        }
    }

    @Override
    public void registerAsSubscriber(LogicalOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("You attempted to register a null operators.");
        }
        this.children.add(operator);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [memo=" + this.memo + "]";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="memo")
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public static Set<Class<? extends LogicalOperator>> getSubTypes(ScanResult classpathScan) {
        Set<Class<? extends LogicalOperator>> ops = classpathScan.getImplementations(LogicalOperator.class);
        logger.debug("Found {} logical operator classes: {}.", (Object)ops.size(), ops);
        return ops;
    }
}

