/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common;

import io.netty.util.Recycler;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public abstract class SerializedExecutor
implements Executor {
    private final Recycler<RunnableProcessor> processors = new Recycler<RunnableProcessor>(){

        protected RunnableProcessor newObject(Recycler.Handle handle) {
            return new RunnableProcessor(handle);
        }
    };
    private boolean isProcessing = false;
    private final LinkedList<Runnable> queuedRunnables = new LinkedList();
    private final Executor underlyingExecutor;
    private final String name;

    public SerializedExecutor(String name, Executor underlyingExecutor) {
        this.underlyingExecutor = underlyingExecutor;
        this.name = name;
    }

    protected abstract void runException(Runnable var1, Throwable var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        LinkedList<Runnable> linkedList = this.queuedRunnables;
        synchronized (linkedList) {
            if (this.isProcessing) {
                this.queuedRunnables.addLast(command);
                return;
            }
            this.isProcessing = true;
        }
        this.underlyingExecutor.execute(((RunnableProcessor)this.processors.get()).set(command));
    }

    private class RunnableProcessor
    implements Runnable {
        private final Recycler.Handle handle;
        private Runnable command;

        public RunnableProcessor(Recycler.Handle handle) {
            this.handle = handle;
        }

        public Runnable set(Runnable command) {
            this.command = command;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            String originalThreadName = currentThread.getName();
            currentThread.setName(SerializedExecutor.this.name);
            try {
                while (true) {
                    try {
                        this.command.run();
                    }
                    catch (AssertionError | Exception e) {
                        try {
                            SerializedExecutor.this.runException(this.command, (Throwable)e);
                        }
                        catch (AssertionError | Exception ee) {
                            throw new IllegalStateException("Exception handler threw an exception", (Throwable)ee);
                        }
                    }
                    LinkedList linkedList = SerializedExecutor.this.queuedRunnables;
                    synchronized (linkedList) {
                        if (SerializedExecutor.this.queuedRunnables.isEmpty()) {
                            SerializedExecutor.this.isProcessing = false;
                            return;
                        }
                        this.command = (Runnable)SerializedExecutor.this.queuedRunnables.removeFirst();
                    }
                }
            }
            finally {
                currentThread.setName(originalThreadName);
                this.command = null;
                SerializedExecutor.this.processors.recycle((Object)this, this.handle);
            }
        }
    }
}

