/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common;

import java.util.LinkedList;
import org.apache.drill.common.DeferredException;

public abstract class EventProcessor<T> {
    private final LinkedList<T> queuedEvents = new LinkedList();
    private volatile boolean isProcessing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(T newEvent) {
        LinkedList<T> linkedList = this.queuedEvents;
        synchronized (linkedList) {
            if (this.isProcessing) {
                this.queuedEvents.addLast(newEvent);
                return;
            }
            this.isProcessing = true;
        }
        DeferredException deferredException = new DeferredException();
        T event = newEvent;
        while (true) {
            try {
                this.processEvent(event);
            }
            catch (Exception e) {
                deferredException.addException(e);
            }
            catch (AssertionError ae) {
                deferredException.addException(new RuntimeException("Caught an assertion", (Throwable)((Object)ae)));
            }
            LinkedList<T> ae = this.queuedEvents;
            synchronized (ae) {
                if (this.queuedEvents.isEmpty()) {
                    this.isProcessing = false;
                    break;
                }
                event = this.queuedEvents.removeFirst();
            }
        }
        try {
            deferredException.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exceptions caught during event processing", e);
        }
    }

    protected abstract void processEvent(T var1);
}

