/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common;

import org.slf4j.Logger;

public class AutoCloseables {
    public static void close(AutoCloseable ac, Logger logger) {
        if (ac == null) {
            return;
        }
        try {
            ac.close();
        }
        catch (Exception e) {
            logger.warn("Failure on close(): {}", (Throwable)e);
        }
    }

    public static void close(AutoCloseable[] ac) throws Exception {
        Exception topLevelException = null;
        for (AutoCloseable closeable : ac) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (topLevelException == null) {
                    topLevelException = e;
                    continue;
                }
                topLevelException.addSuppressed(e);
            }
        }
        if (topLevelException != null) {
            throw topLevelException;
        }
    }
}

