/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.common.exceptions.ExpressionParsingException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.AbstractBuilder;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.LogicalOperatorBase;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;

@JsonTypeName(value="join")
public class Join
extends LogicalOperatorBase {
    private final LogicalOperator left;
    private final LogicalOperator right;
    private final JoinRelType type;
    private final JoinCondition[] conditions;

    public static JoinRelType resolve(String val) {
        for (JoinRelType jt : JoinRelType.values()) {
            if (!jt.name().equalsIgnoreCase(val)) continue;
            return jt;
        }
        throw new ExpressionParsingException(String.format("Unable to determine join type for value '%s'.", val));
    }

    @JsonCreator
    public Join(@JsonProperty(value="left") LogicalOperator left, @JsonProperty(value="right") LogicalOperator right, @JsonProperty(value="conditions") JoinCondition[] conditions, @JsonProperty(value="type") String type) {
        this(left, right, conditions, Join.resolve(type));
    }

    @JsonCreator
    public Join(@JsonProperty(value="left") LogicalOperator left, @JsonProperty(value="right") LogicalOperator right, @JsonProperty(value="conditions") JoinCondition[] conditions, @JsonProperty(value="type") JoinRelType type) {
        this.conditions = conditions;
        this.left = left;
        this.right = right;
        left.registerAsSubscriber(this);
        right.registerAsSubscriber(this);
        this.type = type;
    }

    public LogicalOperator getLeft() {
        return this.left;
    }

    public LogicalOperator getRight() {
        return this.right;
    }

    public JoinCondition[] getConditions() {
        return this.conditions;
    }

    @JsonIgnore
    public JoinRelType getJoinType() {
        return this.type;
    }

    public String getType() {
        return this.type.name();
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitJoin(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.forArray((Object[])new LogicalOperator[]{this.getLeft(), this.getRight()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<Join> {
        private LogicalOperator left;
        private LogicalOperator right;
        private JoinRelType type;
        private List<JoinCondition> conditions = Lists.newArrayList();

        public Builder type(JoinRelType type) {
            this.type = type;
            return this;
        }

        public Builder left(LogicalOperator left) {
            this.left = left;
            return this;
        }

        public Builder right(LogicalOperator right) {
            this.right = right;
            return this;
        }

        public Builder addCondition(String relationship, LogicalExpression left, LogicalExpression right) {
            this.conditions.add(new JoinCondition(relationship, left, right));
            return this;
        }

        @Override
        public Join build() {
            Preconditions.checkNotNull((Object)this.left);
            Preconditions.checkNotNull((Object)this.right);
            Preconditions.checkNotNull((Object)this.type);
            return new Join(this.left, this.right, this.conditions.toArray(new JoinCondition[this.conditions.size()]), this.type);
        }
    }
}

