/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical;

import com.google.common.base.Joiner;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.util.PathScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoragePluginConfigBase
extends StoragePluginConfig {
    private static final Logger logger = LoggerFactory.getLogger(StoragePluginConfigBase.class);

    public static synchronized Class<?>[] getSubTypes(DrillConfig config) {
        List packages = config.getStringList("drill.logical.storage.packages");
        Object[] pluginClasses = PathScanner.scanForImplementationsArr(StoragePluginConfig.class, packages);
        String lineBrokenList = pluginClasses.length == 0 ? "" : "\n\t- " + Joiner.on((String)"\n\t- ").join(pluginClasses);
        logger.debug("Found {} storage plugin configuration classes: {}.", (Object)pluginClasses.length, (Object)lineBrokenList);
        return pluginClasses;
    }

    @Override
    public abstract boolean equals(Object var1);
}

