/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical;

import com.google.common.base.Joiner;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.util.PathScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormatPluginConfigBase
implements FormatPluginConfig {
    private static final Logger logger = LoggerFactory.getLogger(FormatPluginConfigBase.class);

    public static synchronized Class<?>[] getSubTypes(DrillConfig config) {
        List packages = config.getStringList("drill.logical.storage.packages");
        Object[] pluginClasses = PathScanner.scanForImplementationsArr(FormatPluginConfig.class, packages);
        String lineBrokenList = pluginClasses.length == 0 ? "" : "\n\t- " + Joiner.on((String)"\n\t- ").join(pluginClasses);
        logger.debug("Found {} format plugin configuration classes: {}.", (Object)pluginClasses.length, (Object)lineBrokenList);
        return pluginClasses;
    }

    public abstract boolean equals(Object var1);
}

