/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.test.DrillTest;
import org.junit.Assert;
import org.junit.Test;

public class PathSegmentTests
extends DrillTest {
    protected PathSegment makeArraySegment(int len, PathSegment tail) {
        PathSegment node = tail;
        for (int i = 0; i < len; ++i) {
            node = new PathSegment.ArraySegment(node);
        }
        return node;
    }

    @Test
    public void testIfMultiLevelCloneWorks() {
        int levels = 10;
        PathSegment.NameSegment segment = new PathSegment.NameSegment((CharSequence)"test", this.makeArraySegment(10, null));
        PathSegment clone = segment.clone();
        Assert.assertEquals((String)"result of clone & original segments must be identical", (Object)segment, (Object)clone);
        PathSegment.NameSegment tail = new PathSegment.NameSegment((CharSequence)"tail");
        PathSegment.NameSegment newSegment = new PathSegment.NameSegment((CharSequence)"test", this.makeArraySegment(10, (PathSegment)tail));
        PathSegment newClone = segment.cloneWithNewChild((PathSegment)tail);
        Assert.assertEquals((String)"result of cloneWithChild & original segment must be identical", (Object)newSegment, (Object)newClone);
    }
}

