/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Set;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfigBase;
import org.apache.drill.common.logical.StoragePluginConfigBase;
import org.apache.drill.common.logical.data.LogicalOperatorBase;
import org.apache.drill.common.scanner.persistence.ScanResult;

public class LogicalPlanPersistence {
    private ObjectMapper mapper = new ObjectMapper();

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public LogicalPlanPersistence(DrillConfig conf, ScanResult scanResult) {
        SimpleModule deserModule = new SimpleModule("LogicalExpressionDeserializationModule").addDeserializer(LogicalExpression.class, (JsonDeserializer)new LogicalExpression.De(conf)).addDeserializer(SchemaPath.class, (JsonDeserializer)new SchemaPath.De());
        this.mapper.registerModule((Module)deserModule);
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.registerSubtypes(LogicalOperatorBase.getSubTypes(scanResult));
        this.registerSubtypes(StoragePluginConfigBase.getSubTypes(scanResult));
        this.registerSubtypes(FormatPluginConfigBase.getSubTypes(scanResult));
    }

    private <T> void registerSubtypes(Set<Class<? extends T>> types) {
        for (Class<T> clazz : types) {
            this.mapper.registerSubtypes(new Class[]{clazz});
        }
    }
}

