/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Calendar;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlBinaryStringLiteral;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDateLiteral;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlTimeLiteral;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLiteralChainOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.BitString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SqlLiteral
extends SqlNode {
    private final SqlTypeName typeName;
    protected final Object value;

    protected SqlLiteral(Object value, SqlTypeName typeName, SqlParserPos pos) {
        super(pos);
        this.value = value;
        this.typeName = typeName;
        assert (typeName != null);
        assert (SqlLiteral.valueMatchesType(value, typeName));
    }

    public SqlTypeName getTypeName() {
        return this.typeName;
    }

    public static boolean valueMatchesType(Object value, SqlTypeName typeName) {
        switch (typeName) {
            case BOOLEAN: {
                return value == null || value instanceof Boolean;
            }
            case NULL: {
                return value == null;
            }
            case DECIMAL: 
            case DOUBLE: {
                return value instanceof BigDecimal;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return value instanceof Calendar;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return value instanceof SqlIntervalLiteral.IntervalValue;
            }
            case BINARY: {
                return value instanceof BitString;
            }
            case CHAR: {
                return value instanceof NlsString;
            }
            case SYMBOL: {
                return value instanceof SqlSymbol || value instanceof SqlSampleSpec || value instanceof TimeUnitRange;
            }
            case MULTISET: 
            case MAP: {
                return true;
            }
        }
        throw Util.unexpected(typeName);
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlLiteral(this.value, this.typeName, pos);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LITERAL;
    }

    public Object getValue() {
        return this.value;
    }

    public <E extends SqlSymbol> E symbolValue() {
        return (E)((SqlSymbol)this.value);
    }

    public boolean booleanValue() {
        return (Boolean)this.value;
    }

    public static SqlSampleSpec sampleValue(SqlNode node) {
        return (SqlSampleSpec)((SqlLiteral)node).value;
    }

    public static Comparable value(SqlNode node) {
        SqlLiteral literal;
        if (node instanceof SqlLiteral) {
            literal = (SqlLiteral)node;
            switch (literal.getTypeName().getFamily()) {
                case CHARACTER: {
                    return (NlsString)literal.value;
                }
                case NUMERIC: {
                    return (BigDecimal)literal.value;
                }
                case INTERVAL_YEAR_MONTH: {
                    SqlIntervalLiteral.IntervalValue valMonth = (SqlIntervalLiteral.IntervalValue)literal.value;
                    return Long.valueOf((long)valMonth.getSign() * SqlParserUtil.intervalToMonths(valMonth));
                }
                case INTERVAL_DAY_TIME: {
                    SqlIntervalLiteral.IntervalValue valTime = (SqlIntervalLiteral.IntervalValue)literal.value;
                    return Long.valueOf((long)valTime.getSign() * SqlParserUtil.intervalToMillis(valTime));
                }
            }
        }
        if (SqlUtil.isLiteralChain(node)) {
            assert (node instanceof SqlCall);
            literal = SqlLiteralChainOperator.concatenateOperands((SqlCall)node);
            assert (SqlTypeUtil.inCharFamily(literal.getTypeName()));
            return (NlsString)literal.value;
        }
        if (node instanceof SqlIntervalQualifier) {
            SqlIntervalQualifier qualifier = (SqlIntervalQualifier)node;
            return qualifier.timeUnitRange;
        }
        switch (node.getKind()) {
            case CAST: {
                assert (node instanceof SqlCall);
                return SqlLiteral.value(((SqlCall)node).operand(0));
            }
            case MINUS_PREFIX: {
                assert (node instanceof SqlCall);
                Comparable o = SqlLiteral.value(((SqlCall)node).operand(0));
                if (!(o instanceof BigDecimal)) break;
                BigDecimal bigDecimal = (BigDecimal)o;
                return bigDecimal.negate();
            }
        }
        throw Util.newInternal("invalid literal: " + node);
    }

    @Deprecated
    public static String stringValue(SqlNode node) {
        if (node instanceof SqlLiteral) {
            SqlLiteral literal = (SqlLiteral)node;
            assert (SqlTypeUtil.inCharFamily(literal.getTypeName()));
            return literal.toValue();
        }
        if (SqlUtil.isLiteralChain(node)) {
            SqlLiteral literal = SqlLiteralChainOperator.concatenateOperands((SqlCall)node);
            assert (SqlTypeUtil.inCharFamily(literal.getTypeName()));
            return literal.toValue();
        }
        if (node instanceof SqlCall && ((SqlCall)node).getOperator() == SqlStdOperatorTable.CAST) {
            return SqlLiteral.stringValue(((SqlCall)node).operand(0));
        }
        throw Util.newInternal("invalid string literal: " + node);
    }

    public static SqlLiteral unchain(SqlNode node) {
        if (node instanceof SqlLiteral) {
            return (SqlLiteral)node;
        }
        if (SqlUtil.isLiteralChain(node)) {
            return SqlLiteralChainOperator.concatenateOperands((SqlCall)node);
        }
        throw Util.newInternal("invalid literal: " + node);
    }

    public String toValue() {
        if (this.value == null) {
            return null;
        }
        switch (this.typeName) {
            case CHAR: {
                return ((NlsString)this.value).getValue();
            }
        }
        return this.value.toString();
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateLiteral(this);
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        if (!(node instanceof SqlLiteral)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        SqlLiteral that = (SqlLiteral)node;
        if (!this.equals(that)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        return true;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        return SqlMonotonicity.CONSTANT;
    }

    public static SqlLiteral createNull(SqlParserPos pos) {
        return new SqlLiteral(null, SqlTypeName.NULL, pos);
    }

    public static SqlLiteral createBoolean(boolean b, SqlParserPos pos) {
        return b ? new SqlLiteral(Boolean.TRUE, SqlTypeName.BOOLEAN, pos) : new SqlLiteral(Boolean.FALSE, SqlTypeName.BOOLEAN, pos);
    }

    public static SqlLiteral createUnknown(SqlParserPos pos) {
        return new SqlLiteral(null, SqlTypeName.BOOLEAN, pos);
    }

    public static SqlLiteral createSymbol(SqlSymbol o, SqlParserPos pos) {
        return new SqlLiteral(o, SqlTypeName.SYMBOL, pos);
    }

    public static SqlLiteral createSample(SqlSampleSpec sampleSpec, SqlParserPos pos) {
        return new SqlLiteral(sampleSpec, SqlTypeName.SYMBOL, pos);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SqlLiteral)) {
            return false;
        }
        SqlLiteral that = (SqlLiteral)obj;
        return Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public int intValue(boolean exact) {
        switch (this.typeName) {
            case DECIMAL: 
            case DOUBLE: {
                BigDecimal bd = (BigDecimal)this.value;
                if (exact) {
                    try {
                        return bd.intValueExact();
                    }
                    catch (ArithmeticException e) {
                        throw SqlUtil.newContextException(this.getParserPosition(), Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
                    }
                }
                return bd.intValue();
            }
        }
        throw Util.unexpected(this.typeName);
    }

    public long longValue(boolean exact) {
        switch (this.typeName) {
            case DECIMAL: 
            case DOUBLE: {
                BigDecimal bd = (BigDecimal)this.value;
                if (exact) {
                    try {
                        return bd.longValueExact();
                    }
                    catch (ArithmeticException e) {
                        throw SqlUtil.newContextException(this.getParserPosition(), Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
                    }
                }
                return bd.longValue();
            }
        }
        throw Util.unexpected(this.typeName);
    }

    @Deprecated
    public int signum() {
        return this.bigDecimalValue().compareTo(BigDecimal.ZERO);
    }

    public BigDecimal bigDecimalValue() {
        switch (this.typeName) {
            case DECIMAL: 
            case DOUBLE: {
                return (BigDecimal)this.value;
            }
        }
        throw Util.unexpected(this.typeName);
    }

    @Deprecated
    public String getStringValue() {
        return ((NlsString)this.value).getValue();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        switch (this.typeName) {
            case BOOLEAN: {
                writer.keyword(this.value == null ? "UNKNOWN" : ((Boolean)this.value != false ? "TRUE" : "FALSE"));
                break;
            }
            case NULL: {
                writer.keyword("NULL");
                break;
            }
            case DECIMAL: 
            case DOUBLE: 
            case BINARY: 
            case CHAR: {
                throw Util.unexpected(this.typeName);
            }
            case SYMBOL: {
                if (this.value instanceof Enum) {
                    Enum enumVal = (Enum)this.value;
                    writer.keyword(enumVal.toString());
                    break;
                }
                writer.keyword(String.valueOf(this.value));
                break;
            }
            default: {
                writer.literal(this.value.toString());
            }
        }
    }

    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        switch (this.typeName) {
            case BOOLEAN: 
            case NULL: {
                RelDataType ret = typeFactory.createSqlType(this.typeName);
                ret = typeFactory.createTypeWithNullability(ret, null == this.value);
                return ret;
            }
            case BINARY: {
                BitString bitString = (BitString)this.value;
                int bitCount = bitString.getBitCount();
                return typeFactory.createSqlType(SqlTypeName.BINARY, bitCount / 8);
            }
            case CHAR: {
                SqlCollation collation;
                NlsString string = (NlsString)this.value;
                Charset charset = string.getCharset();
                if (null == charset) {
                    charset = typeFactory.getDefaultCharset();
                }
                if (null == (collation = string.getCollation())) {
                    collation = SqlCollation.COERCIBLE;
                }
                RelDataType type = typeFactory.createSqlType(SqlTypeName.CHAR, string.getValue().length());
                type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
                return type;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                SqlIntervalLiteral.IntervalValue intervalValue = (SqlIntervalLiteral.IntervalValue)this.value;
                return typeFactory.createSqlIntervalType(intervalValue.getIntervalQualifier());
            }
            case SYMBOL: {
                return typeFactory.createSqlType(SqlTypeName.SYMBOL);
            }
        }
        throw Util.needToImplement(this.toString() + ", operand=" + this.value);
    }

    public static SqlDateLiteral createDate(Calendar calendar, SqlParserPos pos) {
        return new SqlDateLiteral(calendar, pos);
    }

    public static SqlTimestampLiteral createTimestamp(Calendar calendar, int precision, SqlParserPos pos) {
        return new SqlTimestampLiteral(calendar, precision, false, pos);
    }

    public static SqlTimeLiteral createTime(Calendar calendar, int precision, SqlParserPos pos) {
        return new SqlTimeLiteral(calendar, precision, false, pos);
    }

    public static SqlIntervalLiteral createInterval(int sign, String intervalStr, SqlIntervalQualifier intervalQualifier, SqlParserPos pos) {
        SqlTypeName typeName = intervalQualifier.isYearMonth() ? SqlTypeName.INTERVAL_YEAR_MONTH : SqlTypeName.INTERVAL_DAY_TIME;
        return new SqlIntervalLiteral(sign, intervalStr, intervalQualifier, typeName, pos);
    }

    public static SqlNumericLiteral createNegative(SqlNumericLiteral num, SqlParserPos pos) {
        return new SqlNumericLiteral(((BigDecimal)num.getValue()).negate(), num.getPrec(), num.getScale(), num.isExact(), pos);
    }

    public static SqlNumericLiteral createExactNumeric(String s, SqlParserPos pos) {
        int prec;
        int scale;
        BigDecimal value;
        int i = s.indexOf(46);
        if (i >= 0 && s.length() - 1 != i) {
            value = SqlParserUtil.parseDecimal(s);
            scale = s.length() - i - 1;
            assert (scale == value.scale()) : s;
            prec = s.length() - 1;
        } else if (i >= 0 && s.length() - 1 == i) {
            value = SqlParserUtil.parseInteger(s.substring(0, i));
            scale = 0;
            prec = s.length() - 1;
        } else {
            value = SqlParserUtil.parseInteger(s);
            scale = 0;
            prec = s.length();
        }
        return new SqlNumericLiteral(value, prec, scale, true, pos);
    }

    public static SqlNumericLiteral createApproxNumeric(String s, SqlParserPos pos) {
        BigDecimal value = SqlParserUtil.parseDecimal(s);
        return new SqlNumericLiteral(value, null, null, false, pos);
    }

    public static SqlBinaryStringLiteral createBinaryString(String s, SqlParserPos pos) {
        BitString bits;
        try {
            bits = BitString.createFromHexString(s);
        }
        catch (NumberFormatException e) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.binaryLiteralInvalid());
        }
        return new SqlBinaryStringLiteral(bits, pos);
    }

    public static SqlBinaryStringLiteral createBinaryString(byte[] bytes, SqlParserPos pos) {
        BitString bits;
        try {
            bits = BitString.createFromBytes(bytes);
        }
        catch (NumberFormatException e) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.binaryLiteralInvalid());
        }
        return new SqlBinaryStringLiteral(bits, pos);
    }

    public static SqlCharStringLiteral createCharString(String s, SqlParserPos pos) {
        return SqlLiteral.createCharString(s, null, pos);
    }

    public static SqlCharStringLiteral createCharString(String s, String charSet, SqlParserPos pos) {
        NlsString slit = new NlsString(s, charSet, null);
        return new SqlCharStringLiteral(slit, pos);
    }

    public SqlLiteral unescapeUnicode(char unicodeEscapeChar) {
        if (unicodeEscapeChar == '\u0000') {
            return this;
        }
        assert (SqlTypeUtil.inCharFamily(this.getTypeName()));
        NlsString ns = (NlsString)this.value;
        String s = ns.getValue();
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == unicodeEscapeChar) {
                int v;
                if (n > i + 1 && s.charAt(i + 1) == unicodeEscapeChar) {
                    sb.append(unicodeEscapeChar);
                    ++i;
                    continue;
                }
                if (i + 5 > n) {
                    throw SqlUtil.newContextException(this.getParserPosition(), Static.RESOURCE.unicodeEscapeMalformed(i));
                }
                String u = s.substring(i + 1, i + 5);
                try {
                    v = Integer.parseInt(u, 16);
                }
                catch (NumberFormatException ex) {
                    throw SqlUtil.newContextException(this.getParserPosition(), Static.RESOURCE.unicodeEscapeMalformed(i));
                }
                sb.append((char)(v & 0xFFFF));
                i += 4;
                continue;
            }
            sb.append(c);
        }
        ns = new NlsString(sb.toString(), ns.getCharsetName(), ns.getCollation());
        return new SqlCharStringLiteral(ns, this.getParserPosition());
    }

    public static interface SqlSymbol {
        public String name();

        public int ordinal();
    }
}

