/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVariable;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;

public class RexUtil {
    private static final Function<? super RexNode, ? extends RexNode> ADD_NOT = new Function<RexNode, RexNode>(){

        public RexNode apply(RexNode input) {
            return new RexCall(input.getType(), SqlStdOperatorTable.NOT, (List<? extends RexNode>)ImmutableList.of((Object)input));
        }
    };
    private static final Predicate1<RexNode> IS_FLAT_PREDICATE = new Predicate1<RexNode>(){

        public boolean apply(RexNode v1) {
            return RexUtil.isFlat(v1);
        }
    };
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        public String apply(Object input) {
            return input.toString();
        }
    };
    private static final Function<RexNode, RelDataType> TYPE_FN = new Function<RexNode, RelDataType>(){

        public RelDataType apply(RexNode input) {
            return input.getType();
        }
    };
    private static final Function<RelDataType, RelDataTypeFamily> FAMILY_FN = new Function<RelDataType, RelDataTypeFamily>(){

        public RelDataTypeFamily apply(RelDataType input) {
            return input.getFamily();
        }
    };

    private RexUtil() {
    }

    public static double getSelectivity(RexNode exp) {
        if (exp == null || exp.isAlwaysTrue()) {
            return 1.0;
        }
        return 0.1;
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, RelDataType rhsRowType) {
        List<RelDataTypeField> fieldList = rhsRowType.getFieldList();
        int n = fieldList.size();
        assert (n == lhsRowType.getFieldCount()) : "field count: lhs [" + lhsRowType + "] rhs [" + rhsRowType + "]";
        ArrayList<RexNode> rhsExps = new ArrayList<RexNode>();
        for (RelDataTypeField field : fieldList) {
            rhsExps.add(rexBuilder.makeInputRef(field.getType(), field.getIndex()));
        }
        return RexUtil.generateCastExpressions(rexBuilder, lhsRowType, rhsExps);
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, List<RexNode> rhsExps) {
        List<RelDataTypeField> lhsFields = lhsRowType.getFieldList();
        ArrayList<RexNode> castExps = new ArrayList<RexNode>();
        for (Pair<RelDataTypeField, RexNode> pair : Pair.zip(lhsFields, rhsExps, true)) {
            RexNode rhsExp;
            RelDataType rhsType;
            RelDataTypeField lhsField = (RelDataTypeField)pair.left;
            RelDataType lhsType = lhsField.getType();
            if (lhsType.equals(rhsType = (rhsExp = (RexNode)pair.right).getType())) {
                castExps.add(rhsExp);
                continue;
            }
            castExps.add(rexBuilder.makeCast(lhsType, rhsExp));
        }
        return castExps;
    }

    public static boolean isNullLiteral(RexNode node, boolean allowCast) {
        if (node instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)node;
            if (literal.getTypeName() == SqlTypeName.NULL) {
                assert (null == literal.getValue());
                return true;
            }
            return false;
        }
        if (allowCast && node.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)node;
            if (RexUtil.isNullLiteral((RexNode)call.operands.get(0), false)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(RexNode expr) {
        switch (expr.getKind()) {
            case LITERAL: {
                return ((RexLiteral)expr).getValue2() == null;
            }
            case CAST: {
                return RexUtil.isNull((RexNode)((RexCall)expr).operands.get(0));
            }
        }
        return false;
    }

    public static boolean isNullabilityCast(RelDataTypeFactory typeFactory, RexNode node) {
        switch (node.getKind()) {
            case CAST: {
                RexCall call = (RexCall)node;
                RexNode arg0 = call.getOperands().get(0);
                return SqlTypeUtil.equalSansNullability(typeFactory, arg0.getType(), call.getType());
            }
        }
        return false;
    }

    public static RexCall findOperatorCall(final SqlOperator operator, RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (call.getOperator().equals(operator)) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visitCall(call);
                }
            };
            node.accept(visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (RexCall)e.getNode();
        }
    }

    public static boolean containsInputRef(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitInputRef(RexInputRef inputRef) {
                    throw new Util.FoundOne(inputRef);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsFieldAccess(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                    throw new Util.FoundOne(fieldAccess);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean requiresDecimalExpansion(RexNode expr, boolean recurse) {
        if (!(expr instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)expr;
        boolean localCheck = true;
        switch (call.getKind()) {
            case REINTERPRET: 
            case IS_NULL: {
                localCheck = false;
                break;
            }
            case CAST: {
                RelDataType lhsType = call.getType();
                RelDataType rhsType = ((RexNode)call.operands.get(0)).getType();
                if (rhsType.getSqlTypeName() == SqlTypeName.NULL) {
                    return false;
                }
                if (SqlTypeUtil.inCharFamily(lhsType) || SqlTypeUtil.inCharFamily(rhsType)) {
                    localCheck = false;
                    break;
                }
                if (!SqlTypeUtil.isDecimal(lhsType) || lhsType == rhsType) break;
                return true;
            }
            default: {
                localCheck = call.getOperator().requiresDecimalExpansion();
            }
        }
        if (localCheck) {
            if (SqlTypeUtil.isDecimal(call.getType())) {
                return true;
            }
            for (int i = 0; i < call.operands.size(); ++i) {
                if (!SqlTypeUtil.isDecimal(((RexNode)call.operands.get(i)).getType())) continue;
                return true;
            }
        }
        return recurse && RexUtil.requiresDecimalExpansion(call.operands, true);
    }

    public static boolean requiresDecimalExpansion(List<RexNode> operands, boolean recurse) {
        for (RexNode operand : operands) {
            RexCall call;
            if (!(operand instanceof RexCall) || !RexUtil.requiresDecimalExpansion(call = (RexCall)operand, recurse)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresDecimalExpansion(RexProgram program, boolean recurse) {
        List<RexNode> exprList = program.getExprList();
        for (RexNode expr : exprList) {
            if (!RexUtil.requiresDecimalExpansion(expr, recurse)) continue;
            return true;
        }
        return false;
    }

    public static boolean canReinterpretOverflow(RexCall call) {
        assert (call.isA(SqlKind.REINTERPRET)) : "call is not a reinterpret";
        return call.operands.size() > 1;
    }

    public static boolean containCommonExprs(List<RexNode> exprs, boolean fail) {
        ExpressionNormalizer visitor = new ExpressionNormalizer(false);
        for (RexNode expr : exprs) {
            try {
                expr.accept(visitor);
            }
            catch (ExpressionNormalizer.SubExprExistsException e) {
                Util.swallow(e, null);
                assert (!fail);
                return true;
            }
        }
        return false;
    }

    public static boolean containForwardRefs(List<RexNode> exprs, RelDataType inputRowType, boolean fail) {
        ForwardRefFinder visitor = new ForwardRefFinder(inputRowType);
        for (int i = 0; i < exprs.size(); ++i) {
            RexNode expr = exprs.get(i);
            visitor.setLimit(i);
            try {
                expr.accept(visitor);
                continue;
            }
            catch (ForwardRefFinder.IllegalForwardRefException e) {
                Util.swallow(e, null);
                assert (!fail) : "illegal forward reference in " + expr;
                return true;
            }
        }
        return false;
    }

    static boolean containNonTrivialAggs(List<RexNode> exprs, boolean fail) {
        for (RexNode expr : exprs) {
            RexCall rexCall;
            if (!(expr instanceof RexCall) || !((rexCall = (RexCall)expr).getOperator() instanceof SqlAggFunction)) continue;
            for (RexNode operand : rexCall.operands) {
                if (operand instanceof RexLocalRef || operand instanceof RexLiteral) continue;
                assert (!fail) : "contains non trivial agg: " + operand;
                return true;
            }
        }
        return false;
    }

    public static boolean containComplexExprs(List<RexNode> exprs) {
        for (RexNode expr : exprs) {
            if (!(expr instanceof RexCall)) continue;
            for (RexNode operand : ((RexCall)expr).operands) {
                if (RexUtil.isAtomic(operand)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAtomic(RexNode expr) {
        return expr instanceof RexLiteral || expr instanceof RexVariable;
    }

    public static boolean isCallTo(RexNode expr, SqlOperator op) {
        return expr instanceof RexCall && ((RexCall)expr).getOperator() == op;
    }

    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<RexNode> exprs) {
        return RexUtil.createStructType(typeFactory, exprs, null);
    }

    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<? extends RexNode> exprs, List<String> names) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (int i = 0; i < exprs.size(); ++i) {
            String name;
            if (names == null || (name = names.get(i)) == null) {
                name = "$f" + i;
            }
            builder.add(name, exprs.get(i).getType());
        }
        return builder.build();
    }

    public static boolean compatibleTypes(List<RexNode> exprs, RelDataType type, boolean fail) {
        List<RelDataTypeField> fields = type.getFieldList();
        if (exprs.size() != fields.size()) {
            assert (!fail) : "rowtype mismatches expressions";
            return false;
        }
        for (int i = 0; i < fields.size(); ++i) {
            RelDataType fieldType;
            RelDataType exprType = exprs.get(i).getType();
            if (RelOptUtil.eq("type1", exprType, "type2", fieldType = fields.get(i).getType(), fail)) continue;
            return false;
        }
        return true;
    }

    public static Pair<String, String> makeKey(RexNode expr) {
        return Pair.of(expr.toString(), expr.getType().getFullTypeString());
    }

    public static boolean containIdentity(List<? extends RexNode> exprs, RelDataType rowType, boolean fail) {
        List<RelDataTypeField> fields = rowType.getFieldList();
        if (exprs.size() < fields.size()) {
            assert (!fail) : "exprs/rowType length mismatch";
            return false;
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (!(exprs.get(i) instanceof RexInputRef)) {
                assert (!fail) : "expr[" + i + "] is not a RexInputRef";
                return false;
            }
            RexInputRef inputRef = (RexInputRef)exprs.get(i);
            if (inputRef.getIndex() != i) {
                assert (!fail) : "expr[" + i + "] has ordinal " + inputRef.getIndex();
                return false;
            }
            if (RelOptUtil.eq("type1", exprs.get(i).getType(), "type2", fields.get(i).getType(), fail)) continue;
            return false;
        }
        return true;
    }

    public static RexNode composeConjunction(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes, boolean nullOnEmpty) {
        ImmutableList<RexNode> list = RexUtil.flattenAnd(nodes);
        switch (list.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(true);
            }
            case 1: {
                return (RexNode)list.get(0);
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, (List<? extends RexNode>)list);
    }

    public static ImmutableList<RexNode> flattenAnd(Iterable<? extends RexNode> nodes) {
        if (nodes instanceof Collection && ((Collection)nodes).isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet digests = Sets.newHashSet();
        for (RexNode rexNode : nodes) {
            if (rexNode == null || !digests.add(rexNode.digest)) continue;
            RexUtil.addAnd((ImmutableList.Builder<RexNode>)builder, rexNode);
        }
        return builder.build();
    }

    private static void addAnd(ImmutableList.Builder<RexNode> builder, RexNode node) {
        switch (node.getKind()) {
            case AND: {
                for (RexNode operand : ((RexCall)node).getOperands()) {
                    RexUtil.addAnd(builder, operand);
                }
                return;
            }
        }
        if (!node.isAlwaysTrue()) {
            builder.add((Object)node);
        }
    }

    public static RexNode composeDisjunction(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes, boolean nullOnEmpty) {
        ImmutableList<RexNode> list = RexUtil.flattenOr(nodes);
        switch (list.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(false);
            }
            case 1: {
                return (RexNode)list.get(0);
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, (List<? extends RexNode>)list);
    }

    public static ImmutableList<RexNode> flattenOr(Iterable<? extends RexNode> nodes) {
        if (nodes instanceof Collection && ((Collection)nodes).isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet digests = Sets.newHashSet();
        for (RexNode rexNode : nodes) {
            if (!digests.add(rexNode.digest)) continue;
            RexUtil.addOr((ImmutableList.Builder<RexNode>)builder, rexNode);
        }
        return builder.build();
    }

    private static void addOr(ImmutableList.Builder<RexNode> builder, RexNode node) {
        switch (node.getKind()) {
            case OR: {
                for (RexNode operand : ((RexCall)node).getOperands()) {
                    RexUtil.addOr(builder, operand);
                }
                return;
            }
        }
        if (!node.isAlwaysFalse()) {
            builder.add((Object)node);
        }
    }

    public static List<RelCollation> apply(Mappings.TargetMapping mapping, List<RelCollation> collationList) {
        ArrayList<RelCollation> newCollationList = new ArrayList<RelCollation>();
        for (RelCollation collation : collationList) {
            RelCollation newCollation;
            RelFieldCollation fieldCollation;
            RelFieldCollation newFieldCollation;
            if (collation == RelCollations.PRESERVE) {
                newCollationList.add(collation);
                continue;
            }
            ArrayList<RelFieldCollation> newFieldCollationList = new ArrayList<RelFieldCollation>();
            Iterator<RelFieldCollation> i$ = collation.getFieldCollations().iterator();
            while (i$.hasNext() && (newFieldCollation = RexUtil.apply(mapping, fieldCollation = i$.next())) != null) {
                newFieldCollationList.add(newFieldCollation);
            }
            if (newFieldCollationList.isEmpty() || newCollationList.contains(newCollation = RelCollations.of(newFieldCollationList))) continue;
            newCollationList.add(newCollation);
        }
        return newCollationList;
    }

    public static RelCollation apply(Mappings.TargetMapping mapping, RelCollation collation) {
        List<RelFieldCollation> fieldCollations = RexUtil.applyFields(mapping, collation.getFieldCollations());
        return fieldCollations.equals(collation.getFieldCollations()) ? collation : RelCollations.of(fieldCollations);
    }

    public static RelFieldCollation apply(Mappings.TargetMapping mapping, RelFieldCollation fieldCollation) {
        int target = mapping.getTargetOpt(fieldCollation.getFieldIndex());
        if (target < 0) {
            return null;
        }
        return fieldCollation.copy(target);
    }

    public static List<RelFieldCollation> applyFields(Mappings.TargetMapping mapping, List<RelFieldCollation> fieldCollations) {
        ArrayList<RelFieldCollation> newFieldCollations = new ArrayList<RelFieldCollation>();
        for (RelFieldCollation fieldCollation : fieldCollations) {
            newFieldCollations.add(RexUtil.apply(mapping, fieldCollation));
        }
        return newFieldCollations;
    }

    public static RexNode apply(Mappings.TargetMapping mapping, RexNode node) {
        return node.accept(RexPermuteInputsShuttle.of(mapping));
    }

    public static Iterable<RexNode> apply(Mappings.TargetMapping mapping, Iterable<? extends RexNode> nodes) {
        final RexPermuteInputsShuttle shuttle = RexPermuteInputsShuttle.of(mapping);
        return Iterables.transform(nodes, (Function)new Function<RexNode, RexNode>(){

            public RexNode apply(RexNode input) {
                return input.accept(shuttle);
            }
        });
    }

    public static <T extends RexNode> T[] apply(RexVisitor<T> shuttle, T[] exprs) {
        RexNode[] newExprs = (RexNode[])exprs.clone();
        for (int i = 0; i < newExprs.length; ++i) {
            RexNode expr = newExprs[i];
            if (expr == null) continue;
            newExprs[i] = (RexNode)expr.accept(shuttle);
        }
        return newExprs;
    }

    public static void apply(RexVisitor<Void> visitor, RexNode[] exprs, RexNode expr) {
        for (RexNode e : exprs) {
            e.accept(visitor);
        }
        if (expr != null) {
            expr.accept(visitor);
        }
    }

    public static void apply(RexVisitor<Void> visitor, List<? extends RexNode> exprs, RexNode expr) {
        for (RexNode rexNode : exprs) {
            rexNode.accept(visitor);
        }
        if (expr != null) {
            expr.accept(visitor);
        }
    }

    public static RexNode flatten(RexBuilder rexBuilder, RexNode node) {
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            SqlOperator op = call.getOperator();
            List<RexNode> flattenedOperands = RexUtil.flatten(call.getOperands(), op);
            if (!RexUtil.isFlat(call.getOperands(), op)) {
                return rexBuilder.makeCall(call.getType(), op, flattenedOperands);
            }
        }
        return node;
    }

    public static List<RexNode> flatten(List<? extends RexNode> exprs, SqlOperator op) {
        if (RexUtil.isFlat(exprs, op)) {
            return exprs;
        }
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexUtil.flattenRecurse(list, exprs, op);
        return list;
    }

    private static boolean isFlat(List<? extends RexNode> exprs, final SqlOperator op) {
        return !RexUtil.isAssociative(op) || !RexUtil.exists(exprs, new Predicate1<RexNode>(){

            public boolean apply(RexNode expr) {
                return RexUtil.isCallTo(expr, op);
            }
        });
    }

    public static boolean isFlat(RexNode expr) {
        if (!(expr instanceof RexCall)) {
            return true;
        }
        RexCall call = (RexCall)expr;
        return RexUtil.isFlat(call.getOperands(), call.getOperator()) && RexUtil.all(call.getOperands(), IS_FLAT_PREDICATE);
    }

    private static void flattenRecurse(List<RexNode> list, List<? extends RexNode> exprs, SqlOperator op) {
        for (RexNode rexNode : exprs) {
            if (rexNode instanceof RexCall && ((RexCall)rexNode).getOperator() == op) {
                RexUtil.flattenRecurse(list, ((RexCall)rexNode).getOperands(), op);
                continue;
            }
            list.add(rexNode);
        }
    }

    public static RexNode toCnf(RexBuilder rexBuilder, RexNode rex) {
        return new CnfHelper(rexBuilder).toCnf(rex);
    }

    public static RexNode toDnf(RexBuilder rexBuilder, RexNode rex) {
        return new DnfHelper(rexBuilder).toDnf(rex);
    }

    private static boolean isAssociative(SqlOperator op) {
        return op.getKind() == SqlKind.AND || op.getKind() == SqlKind.OR;
    }

    public static <E> boolean exists(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (!predicate.apply(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean all(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (predicate.apply(e)) continue;
            return false;
        }
        return true;
    }

    public static RexNode shift(RexNode node, int offset) {
        return node.accept(new RexShiftShuttle(offset));
    }

    public static Iterable<RexNode> shift(Iterable<RexNode> nodes, int offset) {
        return new RexShiftShuttle(offset).apply(nodes);
    }

    public static RexNode shift(RexNode node, final int start, final int offset) {
        return node.accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef input) {
                int index = input.getIndex();
                if (index < start) {
                    return input;
                }
                return new RexInputRef(index + offset, input.getType());
            }
        });
    }

    public static RexNode pullFactors(RexBuilder rexBuilder, RexNode node) {
        return new CnfHelper(rexBuilder).pull(node);
    }

    public static List<RexNode> fixUp(final RexBuilder rexBuilder, List<RexNode> nodes, RelDataType rowType) {
        final List<RelDataType> typeList = RelOptUtil.getFieldTypeList(rowType);
        return new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef ref) {
                RelDataType rightType = (RelDataType)typeList.get(ref.getIndex());
                RelDataType refType = ref.getType();
                if (refType == rightType) {
                    return ref;
                }
                RelDataType refType2 = rexBuilder.getTypeFactory().createTypeWithNullability(refType, rightType.isNullable());
                if (refType2 == rightType) {
                    return new RexInputRef(ref.getIndex(), refType2);
                }
                throw new AssertionError((Object)("mismatched type " + ref + " " + rightType));
            }
        }.apply(nodes);
    }

    public static List<RelDataType> types(List<? extends RexNode> nodes) {
        return Lists.transform(nodes, TYPE_FN);
    }

    public static List<RelDataTypeFamily> families(List<RelDataType> types) {
        return Lists.transform(types, FAMILY_FN);
    }

    public static boolean removeAll(List<RexNode> targets, RexNode e) {
        int count = 0;
        Iterator<RexNode> iterator = targets.iterator();
        while (iterator.hasNext()) {
            RexNode next = iterator.next();
            if (!RexUtil.equivalent(next, e)) continue;
            ++count;
            iterator.remove();
        }
        return count > 0;
    }

    private static boolean equivalent(RexNode e1, RexNode e2) {
        return e1 == e2 || e1.toString().equals(e2.toString());
    }

    public static RexNode simplify(RexBuilder rexBuilder, RexNode e) {
        switch (e.getKind()) {
            case AND: {
                return RexUtil.simplifyAnd(rexBuilder, (RexCall)e);
            }
            case OR: {
                return RexUtil.simplifyOr(rexBuilder, (RexCall)e);
            }
            case CASE: {
                return RexUtil.simplifyCase(rexBuilder, (RexCall)e);
            }
            case IS_NULL: {
                return ((RexCall)e).getOperands().get(0).getType().isNullable() ? e : rexBuilder.makeLiteral(false);
            }
            case IS_NOT_NULL: {
                return ((RexCall)e).getOperands().get(0).getType().isNullable() ? e : rexBuilder.makeLiteral(true);
            }
        }
        return e;
    }

    private static RexNode simplifyCase(RexBuilder rexBuilder, RexCall call) {
        ArrayList<RexNode> newOperands;
        List<RexNode> operands;
        block13: {
            operands = call.getOperands();
            newOperands = new ArrayList<RexNode>();
            for (int i = 0; i < operands.size(); ++i) {
                RexNode operand = operands.get(i);
                if (RexUtil.isCasePredicate(call, i)) {
                    if (operand.isAlwaysTrue()) {
                        newOperands.add(operands.get(i + 1));
                        break;
                    }
                    if (operand.isAlwaysFalse()) {
                        ++i;
                        continue;
                    }
                }
                newOperands.add(operand);
            }
            assert (newOperands.size() % 2 == 1);
            switch (newOperands.size()) {
                case 1: {
                    return (RexNode)newOperands.get(0);
                }
            }
            if (call.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                List<Pair<RexNode, RexNode>> pairs = RexUtil.casePairs(rexBuilder, newOperands);
                for (Ord pair : Ord.zip(pairs)) {
                    if (((RexNode)((Pair)pair.e).getValue()).isAlwaysTrue() || ((RexNode)((Pair)pair.e).getValue()).isAlwaysFalse()) continue;
                    break block13;
                }
                ArrayList<RexNode> terms = new ArrayList<RexNode>();
                ArrayList notTerms = new ArrayList();
                for (Ord pair : Ord.zip(pairs)) {
                    if (((RexNode)((Pair)pair.e).getValue()).isAlwaysTrue()) {
                        terms.add(RexUtil.andNot(rexBuilder, (RexNode)((Pair)pair.e).getKey(), notTerms));
                        continue;
                    }
                    notTerms.add(((Pair)pair.e).getKey());
                }
                return RexUtil.composeDisjunction(rexBuilder, terms, false);
            }
        }
        if (newOperands.equals(operands)) {
            return call;
        }
        return call.clone(call.getType(), newOperands);
    }

    private static List<Pair<RexNode, RexNode>> casePairs(RexBuilder rexBuilder, List<RexNode> operands) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < operands.size() - 1; i += 2) {
            builder.add(Pair.of(operands.get(i), operands.get(i + 1)));
        }
        builder.add(Pair.of(rexBuilder.makeLiteral(true), Util.last(operands)));
        return builder.build();
    }

    public static RexNode simplifyAnd(RexBuilder rexBuilder, RexCall e) {
        List<RexNode> terms = RelOptUtil.conjunctions(e);
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        block4: for (int i = 0; i < terms.size(); ++i) {
            RexNode term = terms.get(i);
            switch (term.getKind()) {
                case NOT: {
                    notTerms.add(((RexCall)term).getOperands().get(0));
                    terms.remove(i);
                    --i;
                    continue block4;
                }
                case LITERAL: {
                    if (!RexLiteral.booleanValue(term)) {
                        return term;
                    }
                    terms.remove(i);
                    --i;
                }
            }
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return rexBuilder.makeLiteral(true);
        }
        for (RexNode notDisjunction : notTerms) {
            List<RexNode> terms2 = RelOptUtil.conjunctions(notDisjunction);
            if (!terms.containsAll(terms2)) continue;
            return rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction));
        }
        return RexUtil.composeConjunction(rexBuilder, terms, false);
    }

    public static RexNode simplifyOr(RexBuilder rexBuilder, RexCall call) {
        assert (call.getKind() == SqlKind.OR);
        List<RexNode> terms = RelOptUtil.disjunctions(call);
        for (int i = 0; i < terms.size(); ++i) {
            RexNode term = terms.get(i);
            switch (term.getKind()) {
                case LITERAL: {
                    if (RexLiteral.booleanValue(term)) {
                        return term;
                    }
                    terms.remove(i);
                    --i;
                }
            }
        }
        return RexUtil.composeDisjunction(rexBuilder, terms, false);
    }

    public static RexNode andNot(RexBuilder rexBuilder, RexNode e, RexNode ... notTerms) {
        return RexUtil.andNot(rexBuilder, e, Arrays.asList(notTerms));
    }

    public static RexNode andNot(RexBuilder rexBuilder, RexNode e, Iterable<? extends RexNode> notTerms) {
        switch (e.getKind()) {
            case EQUALS: {
                final RexCall call = (RexCall)e;
                if (!(call.getOperands().get(1) instanceof RexLiteral)) break;
                notTerms = Iterables.filter(notTerms, (Predicate)new Predicate<RexNode>(){

                    public boolean apply(RexNode input) {
                        switch (input.getKind()) {
                            case EQUALS: {
                                RexCall call2 = (RexCall)input;
                                if (!call2.getOperands().get(0).equals(call.getOperands().get(0)) || !(call2.getOperands().get(1) instanceof RexLiteral)) break;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
        }
        return RexUtil.composeConjunction(rexBuilder, Iterables.concat((Iterable)ImmutableList.of((Object)e), (Iterable)Iterables.transform(notTerms, RexUtil.notFn(rexBuilder))), false);
    }

    public static boolean isCasePredicate(RexCall call, int i) {
        assert (call.getKind() == SqlKind.CASE);
        return i < call.operands.size() - 1 && (call.operands.size() - i) % 2 == 1;
    }

    public static Function<RexNode, RexNode> notFn(final RexBuilder rexBuilder) {
        return new Function<RexNode, RexNode>(){

            public RexNode apply(RexNode input) {
                return input.isAlwaysTrue() ? rexBuilder.makeLiteral(false) : (input.isAlwaysFalse() ? rexBuilder.makeLiteral(true) : (input.getKind() == SqlKind.NOT ? (RexNode)((RexCall)input).operands.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, input)));
            }
        };
    }

    public static boolean containsCorrelation(RexNode condition) {
        try {
            condition.accept(CorrelationFinder.INSTANCE);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    public static List<String> strings(List<RexNode> list) {
        return Lists.transform(list, TO_STRING);
    }

    private static class CorrelationFinder
    extends RexVisitorImpl<Void> {
        static final CorrelationFinder INSTANCE = new CorrelationFinder();

        private CorrelationFinder() {
            super(true);
        }

        @Override
        public Void visitCorrelVariable(RexCorrelVariable var) {
            throw Util.FoundOne.NULL;
        }
    }

    private static class RexShiftShuttle
    extends RexShuttle {
        private final int offset;

        public RexShiftShuttle(int offset) {
            this.offset = offset;
        }

        @Override
        public RexNode visitInputRef(RexInputRef input) {
            return new RexInputRef(input.getIndex() + this.offset, input.getType());
        }
    }

    private static class DnfHelper {
        final RexBuilder rexBuilder;

        private DnfHelper(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode toDnf(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)rex).getOperands());
                    RexNode head = (RexNode)operands.get(0);
                    RexNode headDnf = this.toDnf(head);
                    List<RexNode> headDnfs = RelOptUtil.disjunctions(headDnf);
                    RexNode tail = this.and(Util.skip(operands));
                    RexNode tailDnf = this.toDnf(tail);
                    List<RexNode> tailDnfs = RelOptUtil.disjunctions(tailDnf);
                    ArrayList list = Lists.newArrayList();
                    for (RexNode h : headDnfs) {
                        for (RexNode t : tailDnfs) {
                            list.add(this.and((Iterable<? extends RexNode>)ImmutableList.of((Object)h, (Object)t)));
                        }
                    }
                    return this.or(list);
                }
                case OR: {
                    ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)rex).getOperands());
                    return this.or(this.toDnfs((List<RexNode>)operands));
                }
                case NOT: {
                    RexNode arg = ((RexCall)rex).getOperands().get(0);
                    switch (arg.getKind()) {
                        case NOT: {
                            return this.toDnf(((RexCall)arg).getOperands().get(0));
                        }
                        case OR: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toDnf(this.and(Lists.transform(RexUtil.flattenOr(operands), (Function)ADD_NOT)));
                        }
                        case AND: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toDnf(this.or(Lists.transform(RexUtil.flattenAnd(operands), (Function)ADD_NOT)));
                        }
                    }
                    return rex;
                }
            }
            return rex;
        }

        private List<RexNode> toDnfs(List<RexNode> nodes) {
            ArrayList list = Lists.newArrayList();
            block3: for (RexNode node : nodes) {
                RexNode dnf = this.toDnf(node);
                switch (dnf.getKind()) {
                    case OR: {
                        list.addAll(((RexCall)dnf).getOperands());
                        continue block3;
                    }
                }
                list.add(dnf);
            }
            return list;
        }

        private RexNode and(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeConjunction(this.rexBuilder, nodes, false);
        }

        private RexNode or(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeDisjunction(this.rexBuilder, nodes, false);
        }
    }

    private static class CnfHelper {
        final RexBuilder rexBuilder;

        private CnfHelper(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode toCnf(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)rex).getOperands());
                    return this.and(this.toCnfs((List<RexNode>)operands));
                }
                case OR: {
                    ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)rex).getOperands());
                    RexNode head = (RexNode)operands.get(0);
                    RexNode headCnf = this.toCnf(head);
                    List<RexNode> headCnfs = RelOptUtil.conjunctions(headCnf);
                    RexNode tail = this.or(Util.skip(operands));
                    RexNode tailCnf = this.toCnf(tail);
                    List<RexNode> tailCnfs = RelOptUtil.conjunctions(tailCnf);
                    ArrayList list = Lists.newArrayList();
                    for (RexNode h : headCnfs) {
                        for (RexNode t : tailCnfs) {
                            list.add(this.or((Iterable<? extends RexNode>)ImmutableList.of((Object)h, (Object)t)));
                        }
                    }
                    return this.and(list);
                }
                case NOT: {
                    RexNode arg = ((RexCall)rex).getOperands().get(0);
                    switch (arg.getKind()) {
                        case NOT: {
                            return this.toCnf(((RexCall)arg).getOperands().get(0));
                        }
                        case OR: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toCnf(this.and(Lists.transform(RexUtil.flattenOr(operands), (Function)ADD_NOT)));
                        }
                        case AND: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toCnf(this.or(Lists.transform(RexUtil.flattenAnd(operands), (Function)ADD_NOT)));
                        }
                    }
                    return rex;
                }
            }
            return rex;
        }

        private List<RexNode> toCnfs(List<RexNode> nodes) {
            ArrayList list = Lists.newArrayList();
            block3: for (RexNode node : nodes) {
                RexNode cnf = this.toCnf(node);
                switch (cnf.getKind()) {
                    case AND: {
                        list.addAll(((RexCall)cnf).getOperands());
                        continue block3;
                    }
                }
                list.add(cnf);
            }
            return list;
        }

        private RexNode pull(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)rex).getOperands());
                    return this.and(this.pullList((List<RexNode>)operands));
                }
                case OR: {
                    ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)rex).getOperands());
                    Map<String, RexNode> factors = this.commonFactors((List<RexNode>)operands);
                    if (factors.isEmpty()) {
                        return this.or((Iterable<? extends RexNode>)operands);
                    }
                    ArrayList list = Lists.newArrayList();
                    for (RexNode operand : operands) {
                        list.add(this.removeFactor(factors, operand));
                    }
                    return this.and(Iterables.concat(factors.values(), (Iterable)ImmutableList.of((Object)this.or(list))));
                }
            }
            return rex;
        }

        private List<RexNode> pullList(List<RexNode> nodes) {
            ArrayList list = Lists.newArrayList();
            block3: for (RexNode node : nodes) {
                RexNode pulled = this.pull(node);
                switch (pulled.getKind()) {
                    case AND: {
                        list.addAll(((RexCall)pulled).getOperands());
                        continue block3;
                    }
                }
                list.add(pulled);
            }
            return list;
        }

        private Map<String, RexNode> commonFactors(List<RexNode> nodes) {
            HashMap map = Maps.newHashMap();
            int i = 0;
            for (RexNode node : nodes) {
                if (i++ == 0) {
                    for (RexNode conjunction : RelOptUtil.conjunctions(node)) {
                        map.put(conjunction.toString(), conjunction);
                    }
                    continue;
                }
                map.keySet().retainAll(RexUtil.strings(RelOptUtil.conjunctions(node)));
            }
            return map;
        }

        private RexNode removeFactor(Map<String, RexNode> factors, RexNode node) {
            ArrayList list = Lists.newArrayList();
            for (RexNode operand : RelOptUtil.conjunctions(node)) {
                if (factors.containsKey(operand.toString())) continue;
                list.add(operand);
            }
            return this.and(list);
        }

        private RexNode and(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeConjunction(this.rexBuilder, nodes, false);
        }

        private RexNode or(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeDisjunction(this.rexBuilder, nodes, false);
        }
    }

    public static class FieldAccessFinder
    extends RexVisitorImpl<Void> {
        private final List<RexFieldAccess> fieldAccessList = new ArrayList<RexFieldAccess>();

        public FieldAccessFinder() {
            super(true);
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            this.fieldAccessList.add(fieldAccess);
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            for (RexNode operand : call.operands) {
                operand.accept(this);
            }
            return null;
        }

        public List<RexFieldAccess> getFieldAccessList() {
            return this.fieldAccessList;
        }
    }

    private static class ForwardRefFinder
    extends RexVisitorImpl<Void> {
        private int limit = -1;
        private final RelDataType inputRowType;

        public ForwardRefFinder(RelDataType inputRowType) {
            super(true);
            this.inputRowType = inputRowType;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            super.visitInputRef(inputRef);
            if (inputRef.getIndex() >= this.inputRowType.getFieldCount()) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        @Override
        public Void visitLocalRef(RexLocalRef inputRef) {
            super.visitLocalRef(inputRef);
            if (inputRef.getIndex() >= this.limit) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        static class IllegalForwardRefException
        extends ControlFlowException {
            IllegalForwardRefException() {
            }
        }
    }

    private static class ExpressionNormalizer
    extends RexVisitorImpl<RexNode> {
        final Map<String, RexNode> mapDigestToExpr = new HashMap<String, RexNode>();
        final boolean allowDups;

        protected ExpressionNormalizer(boolean allowDups) {
            super(true);
            this.allowDups = allowDups;
        }

        protected RexNode register(RexNode expr) {
            String key = expr.toString();
            RexNode previous = this.mapDigestToExpr.put(key, expr);
            if (!this.allowDups && previous != null) {
                throw new SubExprExistsException(expr);
            }
            return expr;
        }

        protected RexNode lookup(RexNode expr) {
            return this.mapDigestToExpr.get(expr.toString());
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            return this.register(inputRef);
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            return this.register(literal);
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.register(correlVariable);
        }

        @Override
        public RexNode visitCall(RexCall call) {
            ArrayList<RexNode> normalizedOperands = new ArrayList<RexNode>();
            int diffCount = 0;
            for (RexNode operand : call.getOperands()) {
                operand.accept(this);
                RexNode normalizedOperand = this.lookup(operand);
                normalizedOperands.add(normalizedOperand);
                if (normalizedOperand == operand) continue;
                ++diffCount;
            }
            if (diffCount > 0) {
                call = call.clone(call.getType(), normalizedOperands);
            }
            return this.register(call);
        }

        @Override
        public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.register(dynamicParam);
        }

        @Override
        public RexNode visitRangeRef(RexRangeRef rangeRef) {
            return this.register(rangeRef);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode expr = fieldAccess.getReferenceExpr();
            expr.accept(this);
            RexNode normalizedExpr = this.lookup(expr);
            if (normalizedExpr != expr) {
                fieldAccess = new RexFieldAccess(normalizedExpr, fieldAccess.getField());
            }
            return this.register(fieldAccess);
        }

        private static class SubExprExistsException
        extends ControlFlowException {
            SubExprExistsException(RexNode expr) {
                Util.discard(expr);
            }
        }
    }
}

