/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;

public class ProjectJoinTransposeRule
extends RelOptRule {
    public static final ProjectJoinTransposeRule INSTANCE = new ProjectJoinTransposeRule(PushProjector.ExprCondition.FALSE);
    private final PushProjector.ExprCondition preserveExprCondition;

    protected ProjectJoinTransposeRule(PushProjector.ExprCondition preserveExprCondition) {
        super(ProjectJoinTransposeRule.operand(LogicalProject.class, ProjectJoinTransposeRule.operand(Join.class, ProjectJoinTransposeRule.any()), new RelOptRuleOperand[0]));
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject origProj = (LogicalProject)call.rel(0);
        Join join = (Join)call.rel(1);
        if (join instanceof SemiJoin) {
            return;
        }
        PushProjector pushProject = new PushProjector(origProj, join.getCondition(), join, this.preserveExprCondition);
        if (pushProject.locateAllRefs()) {
            return;
        }
        LogicalProject leftProjRel = pushProject.createProjectRefsAndExprs(join.getLeft(), true, false);
        LogicalProject rightProjRel = pushProject.createProjectRefsAndExprs(join.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProject.getAdjustments();
        if (join.getCondition() != null) {
            ArrayList<RelDataTypeField> projJoinFieldList = new ArrayList<RelDataTypeField>();
            projJoinFieldList.addAll(join.getSystemFieldList());
            projJoinFieldList.addAll(leftProjRel.getRowType().getFieldList());
            projJoinFieldList.addAll(rightProjRel.getRowType().getFieldList());
            newJoinFilter = pushProject.convertRefsAndExprs(join.getCondition(), projJoinFieldList, adjustments);
        }
        Join newJoinRel = join.copy(join.getTraitSet(), newJoinFilter, leftProjRel, rightProjRel, join.getJoinType(), join.isSemiJoinDone());
        RelNode topProject = pushProject.createNewProject(newJoinRel, adjustments);
        call.transformTo(topProject);
    }
}

