/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import org.apache.calcite.jdbc.CalciteAbstractSchema;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.MetadataSchema;
import org.apache.calcite.jdbc.SimpleCalciteRootSchema;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.Compatible;

public class SimpleCalciteSchema
extends CalciteAbstractSchema {
    private Map<String, SimpleCalciteSchema> subSchemaMap = Maps.newHashMap();
    private Map<String, CalciteSchema.TableEntry> tableMap = Maps.newHashMap();

    public SimpleCalciteSchema(CalciteSchema parent, Schema schema, String name) {
        super(parent, schema, name);
    }

    @Override
    public CalciteSchema.TableEntry add(String tableName, Table table) {
        CalciteAbstractSchema.TableEntryImpl e = new CalciteAbstractSchema.TableEntryImpl(this, tableName, table, (ImmutableList<String>)ImmutableList.of());
        this.tableMap.put(tableName, e);
        return e;
    }

    @Override
    public CalciteSchema.TableEntry add(String tableName, Table table, ImmutableList<String> sqls) {
        CalciteAbstractSchema.TableEntryImpl entry = new CalciteAbstractSchema.TableEntryImpl(this, tableName, table, sqls);
        this.tableMap.put(tableName, entry);
        return entry;
    }

    @Override
    public CalciteSchema.TableEntry getTableBySql(String sql) {
        for (CalciteSchema.TableEntry tableEntry : this.tableMap.values()) {
            if (!tableEntry.sqls.contains(sql)) continue;
            return tableEntry;
        }
        return null;
    }

    @Override
    public CalciteSchema.TableEntry getTable(String tableName, boolean caseSensitive) {
        CalciteSchema.TableEntry e;
        Table t = this.schema.getTable(tableName);
        if (t == null && (e = this.tableMap.get(tableName)) != null) {
            t = e.getTable();
        }
        if (t != null) {
            return new CalciteAbstractSchema.TableEntryImpl(this, tableName, t, (ImmutableList<String>)ImmutableList.of());
        }
        return null;
    }

    @Override
    public NavigableSet<String> getTableNames() {
        return Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf((Collection)Sets.union(this.schema.getTableNames(), this.tableMap.keySet())));
    }

    @Override
    public CalciteSchema add(String name, Schema schema) {
        SimpleCalciteSchema s = new SimpleCalciteSchema(this, schema, name);
        this.subSchemaMap.put(name, s);
        return s;
    }

    @Override
    public CalciteSchema getSubSchema(String schemaName, boolean caseSensitive) {
        Schema s = this.schema.getSubSchema(schemaName);
        if (s != null) {
            return new SimpleCalciteSchema(this, s, schemaName);
        }
        return this.subSchemaMap.get(schemaName);
    }

    @Override
    public NavigableMap<String, CalciteSchema> getSubSchemaMap() {
        return Compatible.INSTANCE.navigableMap(ImmutableSortedMap.copyOf(this.subSchemaMap));
    }

    @Override
    public CalciteSchema.FunctionEntry add(String name, Function function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support add function yet!");
    }

    @Override
    public Collection<Function> getFunctions(String name, boolean caseSensitive) {
        return this.schema.getFunctions(name);
    }

    @Override
    public NavigableSet<String> getFunctionNames() {
        return Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf(this.schema.getFunctionNames()));
    }

    @Override
    public NavigableMap<String, Table> getTablesBasedOnNullaryFunctions() {
        return Compatible.INSTANCE.navigableMap(ImmutableSortedMap.of());
    }

    @Override
    public CalciteSchema.TableEntry getTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        return null;
    }

    @Override
    public CalciteSchema.LatticeEntry add(String name, Lattice lattice) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support add lattice yet!");
    }

    @Override
    public NavigableMap<String, CalciteSchema.LatticeEntry> getLatticeMap() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support getLatticeMap yet!");
    }

    @Override
    public void setCache(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCacheEnabled() {
        return false;
    }

    public static SchemaPlus createRootSchema(boolean addMetadataSchema) {
        SimpleCalciteRootSchema rootSchema = new SimpleCalciteRootSchema(new CalciteConnectionImpl.RootSchema());
        if (addMetadataSchema) {
            rootSchema.add("metadata", MetadataSchema.INSTANCE);
        }
        return rootSchema.plus();
    }
}

