/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.calcite.jdbc.CalciteAbstractSchema;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.CalciteRootSchema;
import org.apache.calcite.jdbc.CalciteRootSchemaImpl;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.MetadataSchema;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.util.Compatible;

public class CalciteSchemaImpl
extends CalciteAbstractSchema {
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int c = o1.compareToIgnoreCase(o2);
            if (c == 0) {
                c = o1.compareTo(o2);
            }
            return c;
        }
    };
    private final NavigableMap<String, CalciteSchema.TableEntry> tableMap = new TreeMap<String, CalciteSchema.TableEntry>(COMPARATOR);
    private final Multimap<String, CalciteSchema.FunctionEntry> functionMap = LinkedListMultimap.create();
    private final NavigableMap<String, CalciteSchema.LatticeEntry> latticeMap = new TreeMap<String, CalciteSchema.LatticeEntry>(COMPARATOR);
    private final NavigableSet<String> functionNames = new TreeSet<String>(COMPARATOR);
    private final NavigableMap<String, CalciteSchema.FunctionEntry> nullaryFunctionMap = new TreeMap<String, CalciteSchema.FunctionEntry>(COMPARATOR);
    private final NavigableMap<String, CalciteSchema> subSchemaMap = new TreeMap<String, CalciteSchema>(COMPARATOR);
    private final Cached<SubSchemaCache> implicitSubSchemaCache;
    private final Cached<NavigableSet<String>> implicitTableCache;
    private final Cached<NavigableSet<String>> implicitFunctionCache;
    private boolean cache = true;

    public CalciteSchemaImpl(CalciteSchema parent, final Schema schema, String name) {
        super(parent, schema, name);
        assert (parent == null == this instanceof CalciteRootSchema);
        this.implicitSubSchemaCache = new AbstractCached<SubSchemaCache>(){

            @Override
            public SubSchemaCache build() {
                return new SubSchemaCache(CalciteSchemaImpl.this, Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf((Comparator)COMPARATOR, schema.getSubSchemaNames())));
            }
        };
        this.implicitTableCache = new AbstractCached<NavigableSet<String>>(){

            @Override
            public NavigableSet<String> build() {
                return Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf((Comparator)COMPARATOR, schema.getTableNames()));
            }
        };
        this.implicitFunctionCache = new AbstractCached<NavigableSet<String>>(){

            @Override
            public NavigableSet<String> build() {
                return Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf((Comparator)COMPARATOR, schema.getFunctionNames()));
            }
        };
    }

    @Override
    public CalciteSchema.TableEntry add(String tableName, Table table, ImmutableList<String> sqls) {
        CalciteAbstractSchema.TableEntryImpl entry = new CalciteAbstractSchema.TableEntryImpl(this, tableName, table, sqls);
        this.tableMap.put(tableName, entry);
        return entry;
    }

    @Override
    public CalciteSchema.FunctionEntry add(String name, Function function) {
        CalciteAbstractSchema.FunctionEntryImpl entry = new CalciteAbstractSchema.FunctionEntryImpl(this, name, function);
        this.functionMap.put((Object)name, (Object)entry);
        this.functionNames.add(name);
        if (function.getParameters().isEmpty()) {
            this.nullaryFunctionMap.put(name, entry);
        }
        return entry;
    }

    @Override
    public CalciteSchema.LatticeEntry add(String name, Lattice lattice) {
        if (this.latticeMap.containsKey(name)) {
            throw new RuntimeException("Duplicate lattice '" + name + "'");
        }
        CalciteAbstractSchema.LatticeEntryImpl entry = new CalciteAbstractSchema.LatticeEntryImpl(this, name, lattice);
        this.latticeMap.put(name, entry);
        return entry;
    }

    @Override
    public void setCache(boolean cache) {
        if (cache == this.cache) {
            return;
        }
        long now = System.currentTimeMillis();
        this.implicitSubSchemaCache.enable(now, cache);
        this.implicitTableCache.enable(now, cache);
        this.implicitFunctionCache.enable(now, cache);
        this.cache = cache;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cache;
    }

    @Override
    public final CalciteSchema getSubSchema(String schemaName, boolean caseSensitive) {
        if (caseSensitive) {
            CalciteSchema entry = (CalciteSchema)this.subSchemaMap.get(schemaName);
            if (entry != null) {
                return entry;
            }
            long now = System.currentTimeMillis();
            SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
            if (subSchemaCache.names.contains(schemaName)) {
                return (CalciteSchema)subSchemaCache.cache.getUnchecked((Object)schemaName);
            }
            return null;
        }
        Iterator i$ = CalciteSchemaImpl.find(this.subSchemaMap, schemaName).entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry entry = i$.next();
            return (CalciteSchema)entry.getValue();
        }
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        String schemaName2 = subSchemaCache.names.floor(schemaName);
        if (schemaName2 != null) {
            return (CalciteSchema)subSchemaCache.cache.getUnchecked((Object)schemaName2);
        }
        return null;
    }

    @Override
    public CalciteSchema add(String name, Schema schema) {
        CalciteSchemaImpl calciteSchema = new CalciteSchemaImpl(this, schema, name);
        this.subSchemaMap.put(name, calciteSchema);
        return calciteSchema;
    }

    @Override
    public final CalciteSchema.TableEntry getTableBySql(String sql) {
        for (CalciteSchema.TableEntry tableEntry : this.tableMap.values()) {
            if (!tableEntry.sqls.contains(sql)) continue;
            return tableEntry;
        }
        return null;
    }

    @Override
    public final CalciteSchema.TableEntry getTable(String tableName, boolean caseSensitive) {
        Table table;
        if (caseSensitive) {
            Table table2;
            CalciteSchema.TableEntry entry = (CalciteSchema.TableEntry)this.tableMap.get(tableName);
            if (entry != null) {
                return entry;
            }
            long now = System.currentTimeMillis();
            if (this.implicitTableCache.get(now).contains(tableName) && (table2 = this.schema.getTable(tableName)) != null) {
                return this.tableEntry(tableName, table2);
            }
            return null;
        }
        Iterator i$ = CalciteSchemaImpl.find(this.tableMap, tableName).entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry entry = i$.next();
            return (CalciteSchema.TableEntry)entry.getValue();
        }
        long now = System.currentTimeMillis();
        NavigableSet<String> implicitTableNames = this.implicitTableCache.get(now);
        String tableName2 = implicitTableNames.floor(tableName);
        if (tableName2 != null && (table = this.schema.getTable(tableName2)) != null) {
            return this.tableEntry(tableName2, table);
        }
        return null;
    }

    @Override
    public NavigableMap<String, CalciteSchema> getSubSchemaMap() {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(COMPARATOR);
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        for (String name : subSchemaCache.names) {
            builder.put((Object)name, subSchemaCache.cache.getUnchecked((Object)name));
        }
        builder.putAll(this.subSchemaMap);
        return Compatible.INSTANCE.navigableMap(builder.build());
    }

    @Override
    public NavigableMap<String, CalciteSchema.LatticeEntry> getLatticeMap() {
        return Compatible.INSTANCE.immutableNavigableMap(this.latticeMap);
    }

    @Override
    public NavigableSet<String> getTableNames() {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(COMPARATOR);
        builder.addAll(this.tableMap.keySet());
        builder.addAll((Iterable)this.implicitTableCache.get(System.currentTimeMillis()));
        return Compatible.INSTANCE.navigableSet(builder.build());
    }

    @Override
    public Collection<Function> getFunctions(String name, boolean caseSensitive) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (caseSensitive) {
            Collection<Function> functions;
            Collection functionEntries = this.functionMap.get((Object)name);
            if (functionEntries != null) {
                for (CalciteSchema.FunctionEntry functionEntry : functionEntries) {
                    builder.add((Object)functionEntry.getFunction());
                }
            }
            if ((functions = this.schema.getFunctions(name)) != null) {
                builder.addAll(functions);
            }
        } else {
            for (String name2 : CalciteSchemaImpl.find(this.functionNames, name)) {
                Collection functionEntries = this.functionMap.get((Object)name2);
                if (functionEntries == null) continue;
                for (CalciteSchema.FunctionEntry functionEntry : functionEntries) {
                    builder.add((Object)functionEntry.getFunction());
                }
            }
            for (String name2 : CalciteSchemaImpl.find(this.implicitFunctionCache.get(System.currentTimeMillis()), name)) {
                Collection<Function> functions = this.schema.getFunctions(name2);
                if (functions == null) continue;
                builder.addAll(functions);
            }
        }
        return builder.build();
    }

    @Override
    public NavigableSet<String> getFunctionNames() {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(COMPARATOR);
        builder.addAll((Iterable)this.functionMap.keySet());
        builder.addAll((Iterable)this.implicitFunctionCache.get(System.currentTimeMillis()));
        return Compatible.INSTANCE.navigableSet(builder.build());
    }

    @Override
    public NavigableMap<String, Table> getTablesBasedOnNullaryFunctions() {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(COMPARATOR);
        for (Map.Entry entry : this.nullaryFunctionMap.entrySet()) {
            Function function = ((CalciteSchema.FunctionEntry)entry.getValue()).getFunction();
            if (!(function instanceof TableMacro)) continue;
            assert (function.getParameters().isEmpty());
            TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
            builder.put(entry.getKey(), (Object)table);
        }
        for (String string : this.implicitFunctionCache.get(System.currentTimeMillis())) {
            for (Function function : this.schema.getFunctions(string)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                builder.put((Object)string, (Object)table);
            }
        }
        return Compatible.INSTANCE.navigableMap(builder.build());
    }

    @Override
    public CalciteSchema.TableEntry getTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            Function function;
            CalciteSchema.FunctionEntry functionEntry = (CalciteSchema.FunctionEntry)this.nullaryFunctionMap.get(tableName);
            if (functionEntry != null && (function = functionEntry.getFunction()) instanceof TableMacro) {
                assert (function.getParameters().isEmpty());
                TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
            for (Function function2 : this.schema.getFunctions(tableName)) {
                if (!(function2 instanceof TableMacro) || !function2.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function2).apply((List<Object>)ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
        } else {
            for (Map.Entry entry : CalciteSchemaImpl.find(this.nullaryFunctionMap, tableName).entrySet()) {
                Function function = ((CalciteSchema.FunctionEntry)entry.getValue()).getFunction();
                if (!(function instanceof TableMacro)) continue;
                assert (function.getParameters().isEmpty());
                TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
            NavigableSet<String> set = this.implicitFunctionCache.get(System.currentTimeMillis());
            for (String s : CalciteSchemaImpl.find(set, tableName)) {
                for (Function function : this.schema.getFunctions(s)) {
                    if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                    TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                    return this.tableEntry(tableName, table);
                }
            }
        }
        return null;
    }

    public static CalciteRootSchema createRootSchema(boolean addMetadataSchema) {
        CalciteRootSchemaImpl rootSchema = new CalciteRootSchemaImpl(new CalciteConnectionImpl.RootSchema());
        if (addMetadataSchema) {
            rootSchema.add("metadata", MetadataSchema.INSTANCE);
        }
        return rootSchema;
    }

    private CalciteAbstractSchema.TableEntryImpl tableEntry(String name, Table table) {
        return new CalciteAbstractSchema.TableEntryImpl(this, name, table, (ImmutableList<String>)ImmutableList.of());
    }

    private static <V> NavigableMap<String, V> find(NavigableMap<String, V> map, String s) {
        assert (map.comparator() == COMPARATOR);
        return map.subMap(s.toUpperCase(), true, s.toLowerCase(), true);
    }

    private static Iterable<String> find(NavigableSet<String> set, String name) {
        assert (set.comparator() == COMPARATOR);
        return set.subSet(name.toUpperCase(), true, name.toLowerCase(), true);
    }

    private static class SubSchemaCache {
        final NavigableSet<String> names;
        final LoadingCache<String, CalciteSchema> cache;

        private SubSchemaCache(final CalciteSchema calciteSchema, NavigableSet<String> names) {
            this.names = names;
            this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, CalciteSchema>(){

                public CalciteSchema load(String schemaName) {
                    Schema subSchema = calciteSchema.getSchema().getSubSchema(schemaName);
                    if (subSchema == null) {
                        throw new RuntimeException("sub-schema " + schemaName + " not found");
                    }
                    return new CalciteSchemaImpl(calciteSchema, subSchema, schemaName);
                }
            });
        }
    }

    private abstract class AbstractCached<T>
    implements Cached<T> {
        T t;
        long checked = Long.MIN_VALUE;

        private AbstractCached() {
        }

        @Override
        public T get(long now) {
            if (!CalciteSchemaImpl.this.cache) {
                return this.build();
            }
            if (this.checked == Long.MIN_VALUE || CalciteSchemaImpl.this.schema.contentsHaveChangedSince(this.checked, now)) {
                this.t = this.build();
            }
            this.checked = now;
            return this.t;
        }

        @Override
        public void enable(long now, boolean enabled) {
            if (!enabled) {
                this.t = null;
            }
            this.checked = Long.MIN_VALUE;
        }
    }

    private static interface Cached<T> {
        public T get(long var1);

        public T build();

        public void enable(long var1, boolean var3);
    }
}

